<?php
// Start the session
session_start();

// Check if the user is logged in
if (isset($_SESSION['user'])) {
  require_once './config/database.php';
  require_once './functions/function.php';
  // Get the user details from the database
  $user_id = $_SESSION['user'];

  $user = getUser($user_id);
  $wallet = getWallet($user_id);
  $profile = getProfile($user_id);
  $transaction = getTransactions($user_id);
 

} else {
    header("Location: ./login.php");
}

$title = 'Pay Electric Bill';

?>

<!DOCTYPE html>
<html lang="en" class="js">

<head>
    <meta charset="utf-8">
    <meta name="author" content="Dasodhub">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="Pay Bills Seamlessly With the Trilspay App">
    <!-- Fav Icon -->
    <link rel="shortcut icon" href="./assets/images/favicon1.png">
    
    <!-- Site Title  -->
    <title><?php echo $title ?> - Pay Bills Seamlessly with Trilspay</title>
    <!-- Vendor Bundle CSS -->
    <link rel="stylesheet" href="assets/css/vendor.bundle49f7.css?ver=104">
    <!-- Custom styles for this template -->
    <link rel="stylesheet" href="assets/css/style.css" id="layoutstyle">
    
    <script>
        (function(i, s, o, g, r, a, m) {
            i['GoogleAnalyticsObject'] = r;
            i[r] = i[r] || function() {
                (i[r].q = i[r].q || []).push(arguments)
            }, i[r].l = 1 * new Date();
            a = s.createElement(o), m = s.getElementsByTagName(o)[0];
            a.async = 1;
            a.src = g;
            m.parentNode.insertBefore(a, m)
        })(window, document, 'script', '../../www.google-analytics.com/analytics.js', 'ga');
        ga('create', 'UA-91615293-2', 'auto');
        ga('send', 'pageview');
    </script>
</head>







<?php 
require_once './topbar.php';
?>

<!-- .topbar-wrap -->
<div class="page-content">
    <div class="container">
        <div class="card"></div>
            <!-- .card -->
            <div class="col-lg-12">

            <?php
                 //CODE TO RETURN EITHER  AN ERROR OR SUCCESS MESSAGE
                    if (isset($_GET['error'])) {
                        $errorMessage = urldecode($_GET['error']);
                        echo "<div class='alert alert-danger'>$errorMessage</div>";
                    }

                    if (isset($_GET['message'])) {
                        $message = urldecode($_GET['message']);
                        echo "<div class='alert alert-success'>$message</div>";
                    }

                    //END OF CODE TO RETURN EITHER ERROR OR SUCCESS MESSAGE
                    ?>
                <div class="content-area card">
                    <div class="card-innr card-innr-fix">
                        <div class="card-head">
                            <h6 class="card-title">Pay Electric Bill</h6>
                        </div>
                        <div class="gaps-1x"></div>
                        <!-- .gaps -->
                        <form action="./functions/pay-bills" method="post">
                            <div class="row">
                                <div class="col-md-6">
                                <input class="input-bordered" type="text" value="<?php echo $wallet['wallet_id']; ?>"  name="wallet" hidden>
                                    <input class="input-bordered" type="text" value="<?php echo $user['user_id']; ?>"  name="user" hidden>

                                    <input class="input-bordered" type="text" value="<?php echo $profile['user_id']; ?>"  name="profile" hidden>
                                    
                                    <div class="input-item input-with-label">
                                        <label class="input-item-label text-exlight">Electric Distribution Company</label>
                                        <select id="edc-selector" class="input-bordered" name="electric-distributor">
                                            <option disabled selected>Select an electric distribution company...</option>
                                            <option value="ikeja-electric">Ikeja Electricity Distribution Company (IKEDC)</option>
                                            <option value="eko-electric">Eko Electricity Distribution Company (EKEDC)</option>
                                            <option value="kano-electric">Kano Electricity Distribution Company (KEDCO)</option>
                                            <option value="portharcourt-electric">Port Harcourt Electric Distribution Company (PHED)</option>
                                            <option value="ibadan-electric">Ibadan Electricity Distribution Company (IBEDC)</option>
                                            <option value="kaduna-electric">Kaduna Electric</option>
                                            <option value="abuja-electric">Abuja Electricity Distribution Company (AEDC)</option>
                                            <option value="enugu-electric">Enugu Electric</option>
                                            <option value="benin-electric">Benin Electricity Distribution Company (BEDC)</option>
                                            <option value="aba-electric">ABA Electricity Distribution Company (ABA)</option>
                                            <option value="yola-electric">YOLA Electricity Distribution Company (YEDC)</option>
                                        </select>
                                    </div>
                                </div>
                               
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                <style>
                                        input[type="number"]::-webkit-inner-spin-button,
                                        input[type="number"]::-webkit-outer-spin-button {
                                            -webkit-appearance: none;
                                            margin: 0;
                                        }
                                        input[type="number"] {
                                            -moz-appearance: textfield;
                                        }
                                    </style>
                                    <div class="input-item input-with-label"><label class="input-item-label text-exlight">Meter No</label>
                                        <div class="relative"><span class="input-icon"></span><input class="input-bordered" type="number" id="meter" name="meter"></div><span class="input-note">Input your Meter No. </span></div>

                                        <div class="input-item input-with-label"><label class="input-item-label text-exlight">Amount</label>
                                <div class="relative "><span class="input-icon"></span><input class="input-bordered" type="number" id="meter" name="amount"></div><span class="input-note">Input your Amount </span>
                            </div>
                                </div>
                               
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="input-item input-with-label">
                                        <label class="input-item-label text-exlight">Meter Type</label>
                                        <select id="type-selector" class="input-bordered" name="meter-type">
                                            <option disabled selected>Select a meter type...</option>
                                            <option value="prepaid">Prepaid</option>
                                            <option value="postpaid">Postpaid</option>
                                            
                                        </select>
                                    </div>
                                </div>
                               
                            </div>
                            <div id="info-container"></div>
                           
                            

                            
                            
                            <div class="gaps-1x"></div><button class="btn btn-primary" id="process-electricity" name="process-electric">Pay</button></form>
                    </div>
                    <!-- .card-innr -->
                </div>
                <!-- .card -->


            </div>


    </div>
        <!-- .container -->
</div>
    <!-- .page-content -->

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).ready(function () {
    let edcSelector = $("#edc-selector");
    let meterInput = $("#meter");
    let meterTypeSelector = $("#type-selector");
    let processElectricityButton = $("#process-electricity");
    let verificationSpinner = $("#verification-spinner");

    processElectricityButton.prop("disabled", true);

    function verifyDetails(edc, meter, meterType) {
        processElectricityButton.prop("disabled", true);
        verificationSpinner.removeClass("d-none");

        $.ajax({
            url: "./verify-electric.php",
            type: "POST",
            data: {
                edc: edc,
                meter: meter,
                meterType: meterType
            },
            success: function (response) {
                console.log(response);

                const jsonResponse = JSON.parse(response);

                if (jsonResponse.error) {
                    console.error(jsonResponse.error);
                } else {
                    console.log(jsonResponse);
                    //smartcardVerified = true;
                    // Handle the output in a Bootstrap-styled div
                    const container = $('<div class="alert alert-info mt-3">');

                    container.append($('<p>', {
                        text: `Customer Name: ${jsonResponse.data.customerName}`
                    }));

                    // container.append($('<p>', {
                    //     text: `Due Date: ${jsonResponse.data.dueDate}`
                    // }));

                    // container.append($('<p>', {
                    //     text: `Current Plan: ${jsonResponse.data.currentPlan}`
                    // }));

                    $('#info-container').empty().append(container);

                }

                verificationSpinner.addClass("d-none");
                processElectricityButton.prop("disabled", false);
            },
            error: function (jqXHR, textStatus, errorThrown) {
                console.log("Error: " + textStatus + ": " + errorThrown);

                verificationSpinner.addClass("d-none");
                processElectricityButton.prop("disabled", false);
            }
        });
    }

    edcSelector.on("change", function () {
        let edc = edcSelector.val();

        if (edc && meterInput.val() && meterTypeSelector.val()) {
            verifyDetails(edc, meterInput.val(), meterTypeSelector.val());
        }
    });

    meterInput.on("input", function () {
        let edc = edcSelector.val();
        let meter = meterInput.val();

        if (edc && meter && meterTypeSelector.val()) {
            verifyDetails(edc, meter, meterTypeSelector.val());
        }
    });

    meterTypeSelector.on("change", function () {
        let edc = edcSelector.val();
        let meter = meterInput.val();
        let meterType = meterTypeSelector.val();

        if (edc && meter && meterType) {
            verifyDetails(edc, meter, meterType);
        }
    });

    // Trigger the change event on the form fields when the page loads
    edcSelector.trigger("change");
    meterInput.trigger("input");
    meterTypeSelector.trigger("change");
});
</script>

<?php 




require_once './footer.php';
?>