<?php
// Start the session
session_start();

// Check if the user is logged in
if (isset($_SESSION['user'])) {
  require_once './config/database.php';
  require_once './functions/function.php';
  // Get the user details from the database
  $user_id = $_SESSION['user'];

  $user = getUser($user_id);
  $wallet = getWallet($user_id);
  $profile = getProfile($user_id);
  $transaction = getTransactions($user_id);
 

} else {
    header("Location: ./login.php");
}

$title = 'TV Cable Subscription';

?>

<!DOCTYPE html>
<html lang="en" class="js">

<head>
    <meta charset="utf-8">
    <meta name="author" content="Dasodhub">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="Pay Bills Seamlessly With the Trilspay App">
    <!-- Fav Icon -->
    <link rel="shortcut icon" href="./assets/images/favicon1.png">
    
    <!-- Site Title  -->
    <title><?php echo $title ?> - Pay Bills Seamlessly with Trilspay</title>
    <!-- Vendor Bundle CSS -->
    <link rel="stylesheet" href="assets/css/vendor.bundle49f7.css?ver=104">
    <!-- Custom styles for this template -->
    <link rel="stylesheet" href="assets/css/style.css" id="layoutstyle">
    
    <script>
        (function(i, s, o, g, r, a, m) {
            i['GoogleAnalyticsObject'] = r;
            i[r] = i[r] || function() {
                (i[r].q = i[r].q || []).push(arguments)
            }, i[r].l = 1 * new Date();
            a = s.createElement(o), m = s.getElementsByTagName(o)[0];
            a.async = 1;
            a.src = g;
            m.parentNode.insertBefore(a, m)
        })(window, document, 'script', '../../www.google-analytics.com/analytics.js', 'ga');
        ga('create', 'UA-91615293-2', 'auto');
        ga('send', 'pageview');
    </script>
</head>








<?php 
require_once './topbar.php';

?>

<!-- .topbar-wrap -->
<div class="page-content">
    <div class="container">
        <div class="card"></div>
        <!-- .card -->
        <div class="col-lg-12">
                <?php
                 //CODE TO RETURN EITHER  AN ERROR OR SUCCESS MESSAGE
                    if (isset($_GET['error'])) {
                        $errorMessage = urldecode($_GET['error']);
                        echo "<div class='alert alert-danger'>$errorMessage</div>";
                    }

                    if (isset($_GET['message'])) {
                        $message = urldecode($_GET['message']);
                        echo "<div class='alert alert-success'>$message</div>";
                    }

                    //END OF CODE TO RETURN EITHER ERROR OR SUCCESS MESSAGE
                    ?>
                <div class="content-area card">
                
                    <div class="card-innr card-innr-fix">
                        <div class="card-head">
                            <h6 class="card-title">Cable TV Subscription</h6>
                        </div>
                        <div class="gaps-1x"></div>
                        <!-- .gaps -->
                        <form action="./functions/pay-bills" method="post" id="verify-smartcard-form" >
                        <div class="row">
                    <div class="col-md-12">
                    <label class="input-item-label ucap text-exlight">Service Provider</label><br>
                    <ul class="d-flex flex-wrap checkbox-list">
        <li>
            <div class="input-item text-left">
                <input class="input-radio input-radio-sm" id="pma-dstv" name="service" type="radio"
                    value="dstv">
                <span class="input-radio-circle"></span>
                <label for="pma-dstv"><img src="./assets/images/dstv.png" alt="DSTV"
                        class="payment-icon payment-icon-small" style="width: 36px;"> DSTV</label>
            </div>
        </li>
        <li>
            <div class="input-item text-left">
                <input class="input-radio input-radio-sm" id="pma-gotv" name="service" type="radio"
                    value="gotv">
                <span class="input-radio-circle"></span>
                <label for="pma-gotv"><img src="./assets/images/gotv.png" alt="GOTV"
                        class="payment-icon payment-icon-small" style="width: 36px;"> GOTV</label>
            </div>
        </li>
        <li>
            <div class="input-item text-left">
                <input class="input-radio input-radio-sm" id="pma-startimes" name="service" type="radio"
                    value="startimes">
                <span class="input-radio-circle"></span>
                <label for="pma-startimes"><img src="./assets/images/startimes.jpg" alt="STARTIMES"
                        class="payment-icon payment-icon-small" style="width: 36px;"> STARTIMES</label>
            </div>
        </li>
    </ul>
    <br>
    <select id="product-select"></select>
                        <script>
                            $("input[name='service']").on("change", function() {
                                const selectedService = $("input[name='service']:checked").val();
                                getPlans(selectedService);
                            });

                        </script>
                    </div>
                    </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <input class="input-bordered" type="text" value="<?php echo $wallet['wallet_id']; ?>"  name="wallet" hidden>
                                    <input class="input-bordered" type="text" value="<?php echo $user['user_id']; ?>"  name="user" hidden>

                                    <input class="input-bordered" type="text" value="<?php echo $profile['user_id']; ?>"  name="profile" hidden>
                                    

                                    <style>
                                        input[type="number"]::-webkit-inner-spin-button,
                                        input[type="number"]::-webkit-outer-spin-button {
                                            -webkit-appearance: none;
                                            margin: 0;
                                        }
                                        input[type="number"] {
                                            -moz-appearance: textfield;
                                        }
                                    </style>
                                        <br>
                                    <div class="input-item input-with-label">
                                        <label class="input-item-label text-exlight">SmartCard Number</label>
                                        <input class="form-control input input-bordered smartcard-input" type="number" name="smartcard" id="smartcard" min="6" step="1">

                                        <script>
                                            $(document).ready(function() {
                                                let smartcardInput = $("input.smartcard-input");
                                            
                                            });
                                        </script>
                                        <span class="input-note">Please wait a few minute for your smartCard to be verified</span>
                                        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>


                                        <div id="info-container"></div>
                                    </td>


                                

                                    </div>

                                    
                                    

                                </div>

                                
                            </div>
                            <!-- <div class="row">
                                <div class="col-md-6">
                                    <div class="input-item input-with-label"><label class="input-item-label text-exlight">Phone No</label>
                                        <div class="relative"><span class="input-icon input-icon-right"><em class="ti ti-mobile"></em></span><input class="input-bordered" type="tel" name="phone_number"></div><span class="input-note">Input your contact No. </span></div>
                                </div>
                                

                                <div class="col-md-6">
                                <div class="input-item input-with-label"><label class="input-item-label text-exlight">Amount</label><input class="input-bordered" type="number" name="amount"  id="price-input" disabled></div>
                              </div>
                                
                            </div> -->
                           
                            
                            <div class="gaps-1x"></div><button class="btn btn-primary" name="subscribe" id="process-subscription-button">Process Subscription</button></form>
                    </div>
                    <!-- .card-innr -->
                </div>
                <!-- .card -->


            </div>



    </div>
    <!-- .container -->
</div>
<!-- .page-content -->

<script>
    $(document).ready(function () {
        let smartcardInput = $(".input[name='smartcard']");
        let service;
        let processSubscriptionButton = $("#process-subscription-button");
        let smartcardVerified = false;
        let spinner = $("#spinner");

        processSubscriptionButton.prop("disabled", true);

        $("input[name='service']").change(function () {
            service = $("input[name='service']:checked").val();
        });

        smartcardInput.on("input", function () {
            clearTimeout($.data(this, "timer"));

            let smartcard = smartcardInput.val();

            if (smartcard && service) {
                if (smartcard !== "") {
                    if (!smartcardVerified) {
                        console.log(`Smartcard: ${smartcard}, Service: ${service}`);

                        processSubscriptionButton.prop("disabled", true);

                        // Show the spinner
                        spinner.removeClass("d-none");

                        $.ajax({
                            url: "./verify-smartcard",
                            type: "POST",
                            data: {
                                smartcard: smartcard,
                                service: service
                            },
                            success: function (response) {
                                console.log(response);

                                const jsonResponse = JSON.parse(response);

                                if (jsonResponse.error) {
                                    console.error(jsonResponse.error);
                                } else {
                                    console.log(jsonResponse);
                                    smartcardVerified = true;
                                    // Handle the output in a Bootstrap-styled div
                                    const container = $('<div class="alert alert-info mt-3">');

                                    container.append($('<p>', {
                                        text: `Customer Name: ${jsonResponse.data.customerName}`
                                    }));

                                    // container.append($('<p>', {
                                    //     text: `Due Date: ${jsonResponse.data.dueDate}`
                                    // }));

                                    container.append($('<p>', {
                                        text: `Current Plan: ${jsonResponse.data.currentPlan}`
                                    }));

                                    $('#info-container').empty().append(container);

                                    // Hide the spinner
                                    spinner.addClass("d-none");

                                    processSubscriptionButton.prop("disabled", false);
                                }
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                console.log("Error: " + textStatus + ": " + errorThrown);

                                // Hide the spinner
                                spinner.addClass("d-none");

                                processSubscriptionButton.prop("disabled", true);
                                smartcardVerified = false;
                            }
                        });
                    } else {
                        smartcardVerified = false;
                    }
                }
            }
        });
    });
</script>





</script>

<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script>
$(document).ready(function() {
  // Add event listener to input with name "service"
  $('input[name="service"]').change(function() {
    var selectedService = $(this).val();

    // Send AJAX request to query-products with GET method
    $.ajax({
      url: 'query-products.php',
      type: 'GET',
      data: {
        // Send selected service as query parameter
        service: selectedService
      },
      success: function(data) {
        var products = JSON.parse(data);
        var selectHtml = '<option value="">Select a Subscription Plan</option>';

        // Populate select element with product options
        products.forEach(function(product) {
          selectHtml += '<option value="' + product.product_code + '">' + product.product_name + '</option>';
        });

        // Add Bootstrap form control and label to select element
        $('#product-select').addClass('form-control col-md-6 input-bordered');
        $('#product-select-label').addClass('form-label');
        $('#product-select-container').removeClass('d-none');

        $('#product-select').html(selectHtml).attr('name', 'product_select');
      }
    });
  });
})
</script>



<?php 
if(isset($_POST['subscribe'])) {
    print_r($_POST);
}


 require_once './footer.php';
?>
