<?php

use Dotenv\Dotenv;

require_once __DIR__ . '/../vendor/autoload.php';



// Load environment variables from .env file
$dotenv = Dotenv::createImmutable(__DIR__ . '/..');
$getenv = $dotenv->load();

// echo($getenv['DB_NAME']);



// Database configuration
$host = $getenv['DB_HOST'];
$username = $getenv['DB_USERNAME'];
$password = $getenv['DB_PASSWORD'];
$database = $getenv['DB_NAME'];

// API key
$api_key = $getenv['API_KEY'];
$site_url = $getenv['APP_URL'];
$site_name = $getenv['APP_NAME'];
$site_email = $getenv['APP_EMAIL'];

$vtpass_api = $getenv['VTPASS_API_KEY'];
$vtpass_sk = $getenv['VTPASS_SECRET_KEY'];
$vtpass_pk = $getenv['VTPASS_PUBLIC_KEY'];


if (!function_exists('openssl_random_pseudo_bytes') &&
    !function_exists('random_bytes') &&
    !function_exists('mcrypt_create_iv')) {
    throw new Exception("No suitable random number generator found.");
}

$applicationKey = bin2hex(random_bytes(32));

$config['APP_KEY'] = $applicationKey;

//print_r($config['APP_KEY']);


function checkAppKey()
{
    $appKey = isset($GLOBALS['config']['APP_KEY']) ? $GLOBALS['config']['APP_KEY'] : null;

    if (!$appKey) {
      
        trigger_error('Configuration warning: APP_KEY is not set in the configuration file.', E_USER_WARNING);
    }
    return $appKey;
}

// Check if APP_KEY is available
checkAppKey();

// Use the application key in your code
$applicationKey = checkAppKey();

















?>