<?php
// Start the session
session_start();

// Check if the user is logged in
if (isset($_SESSION['user'])) {
  require_once './config/database.php';
  require_once './functions/function.php';
  // Get the user details from the database
  $user_id = $_SESSION['user'];

  $user = getUser($user_id);
  $wallet = getWallet($user_id);
  $profile = getProfile($user_id);
  $transaction = getTransactions($user_id);
 

} else {
    header("Location: ./login.php");
}

$title = 'Dashboard';

///////////////////////////////////////////////////////////////////

   /////////////////////////////////////////////////////////////
   $api_url = "http://102.216.128.75:9090/bank9ja/api/v2/k1/authenticate";
   $username = "trilspay";
   $password = "uMmNx3B4sDJTgdETq2FPOq5z38aandFl2FSObKg9jmTyvxgYca";
   $client_id = "waas";
   $client_secret = "cRAwnWElcNMUZpALdnlve6PubUkCPOQR";

   $data = array(
       'username' => $username,
       'password' => $password,
       'clientId' => $client_id,
       'clientSecret' => $client_secret
   );

   $ch = curl_init();

   curl_setopt($ch, CURLOPT_URL, $api_url);
   curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
   curl_setopt($ch, CURLOPT_POST, 1);
   curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
   curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));

   $response = curl_exec($ch);
   // JSON response containing the access token
   $json_response = $response;

   // Decode the JSON response
   $response_data = json_decode($json_response, true);

   // Extract the access token value
   $access_token = $response_data['accessToken'];

   // Output the access token value
   //echo "Access Token: " . $access_token;

   if (!$response) {
       die('Error: "' . curl_error($ch) . '" - Code: ' . curl_errno($ch));
   }

   curl_close($ch);

   $result = json_decode($response, true);
   //print_r($response);
   //////////////////////////////////////////////////////////////
   $url = 'http://102.216.128.75:9090/waas/api/v1/wallet_enquiry';
   $token = $access_token;
   $accountNo = '1100029273';

   $headers = array(
       'Authorization: Bearer ' . $token,
       'Content-Type: application/json'
   );

   $data = array(
       'accountNo' => $accountNo
   );

   $ch = curl_init($url);
   curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
   curl_setopt($ch, CURLOPT_POST, true);
   curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
   curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

   $response = curl_exec($ch);
   curl_close($ch);

   //echo $response;

   $data = json_decode($response, true);

   $accountNumber = $data['data']['nuban'];
   $name = $data['data']['name'];
   $balance = $data['data']['availableBalance'];

?>

<!DOCTYPE html>
<html lang="en" class="js">

<head>
    <meta charset="utf-8">
    <meta name="author" content="Dasodhub">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="Pay Bills Seamlessly With the Trilspay App">
    <!-- Fav Icon -->
    <link rel="shortcut icon" href="./assets/images/favicon1.png">
    
    <!-- Site Title  -->
    <title><?php echo $title ?> - Pay Bills Seamlessly with Trilspay</title>
    <!-- Vendor Bundle CSS -->
    <link rel="stylesheet" href="assets/css/vendor.bundle49f7.css?ver=104">
    <!-- Custom styles for this template -->
    <link rel="stylesheet" href="assets/css/style.css" id="layoutstyle">
    
    <script>
        (function(i, s, o, g, r, a, m) {
            i['GoogleAnalyticsObject'] = r;
            i[r] = i[r] || function() {
                (i[r].q = i[r].q || []).push(arguments)
            }, i[r].l = 1 * new Date();
            a = s.createElement(o), m = s.getElementsByTagName(o)[0];
            a.async = 1;
            a.src = g;
            m.parentNode.insertBefore(a, m)
        })(window, document, 'script', '../../www.google-analytics.com/analytics.js', 'ga');
        ga('create', 'UA-91615293-2', 'auto');
        ga('send', 'pageview');
    </script>
</head>









<?php 
require_once './topbar.php';
?>

        
    <!-- .topbar-wrap -->
    <div class="page-content">
        <div class="container">
            <?php if (empty($profile['user_transaction_pin'])): ?>
        <!-- Do something if user transaction pin is empty -->
        <div class="alert alert-warning text-center">Kindly Fill out your transaction pin from your profile page or  <a href="./profile">Click here</a></div>
        <!-- Do something if user transaction pin is not empty -->
            <?php endif; ?>
            <div class="row">
                <div class="col-lg-4">
                    <div class="token-statistics card card-token height-auto">
                        <div class="card-innr">
                            <div class="token-balance token-balance-with-icon">
                                <div class="token-balance-icon"><img src="./assets/images/wallet.png" alt="logo"></div>
                                <div class="token-balance-text">
                                    <h6 class="card-sub-title">Wallet Balance</h6><span class="lead"><?php echo number_format($wallet['balance'], 2, '.', ',');  ?> <span>NGN</span></span>
                                </div>
                            </div>
                          
              
                    <div class="token-balance token-balance-s2">
                            <h6 class="card-sub-title">Your Analytics</h6>
                        <ul class="token-balance-list">
                              <li class="token-balance-sub"><span class="lead">2.646</span><span class="sub">ETH</span></li>
                              <li class="token-balance-sub"><span class="lead">1.265</span><span class="sub">BTC</span></li>
                              <li class="token-balance-sub"><span class="lead">6.506</span><span class="sub">LTC</span></li>
                        </ul>
                    </div>
                   

                            
                        </div>
                    </div>
                </div>
                <!-- .col -->
                <div class="col-lg-8">
                    <div class="token-information card card-full-height">
                        <div class="row no-gutters height-100">
                            <div class="col-md-6 text-center">
                                <div class="token-info"><img class="token-info-icon" src="./assets/images/commision.png" alt="logo-sm">
                                    <div class="gaps-2x"></div>
                                    <h1 class="token-info-head text-light">Commission Earnings</h1>
                                    <h5 class="token-info-sub">1 ETH = 254.05 USD</h5>
                                </div>
                            </div>
                            <?php 
                            
                            if ($profile['is_kyc_verified'] === 1):
                                
                            ?>


                                <div class="col-md-6">
                                    <div class="token-info bdr-tl">
                                        <div>
                                        <h4>Quick Automated Wallet Funding</h4>
                                            <ul class="token-info-list">
                                                
                                                <li><span>Bank Name:</span> <?php echo trim( $name); ?></li>
                                                <li><span>Bank Account No:</span> <?php echo $accountNumber; ?></li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            <?php else: ?>
                                
                                <div class="col-md-6">
                                    <div class="token-info bdr-tl">
                                        <div>

                                        <h4>Quick Automated Wallet Funding</h4>
                                            <p>Please complete your KYC to use this feature.</p>
                                        </div>
                                    </div>
                                </div>
                          
                        <?php endif; ?>

                        </div>
                    </div>
                    <!-- .card -->
                </div>
                <!-- .col -->
          
                <div class="content-area card col-xl-8 col-lg-7">
    <div class="card-innr">
        <div class="card-head">
            <?php
                //CODE TO RETURN EITHER  AN ERROR OR SUCCESS MESSAGE
                if (isset($_GET['error'])) {
                    $errorMessage = urldecode($_GET['error']);
                    echo "<div class='alert alert-danger alert-dismissible'>
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                            $errorMessage
                        </div>";
                }
                if (isset($_GET['message'])) {
                    $message = urldecode($_GET['message']);
                    echo "<div class='alert alert-success alert-dismissible'>
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                            $message
                        </div>";
                }
                //END OF CODE TO RETURN EITHER ERROR OR SUCCESS MESSAGE
            ?>
            <h6 class="card-title">Easily Settle Your Bills</h6>
        </div>
        <div class="gaps-1x"></div>
        <ul class="nav nav-tabs nav-tabs-line" role="tablist">
            <li class="nav-item"><a class="nav-link active" data-toggle="tab" href="#tab-item-1">Airtime</a></li>
            <li class="nav-item"><a class="nav-link" data-toggle="tab" href="#tab-item-2">Data Bundle</a></li>
            <li class="nav-item"><a class="nav-link" href="./cable-tv">Cable TV</a></li>
            <li class="nav-item"><a class="nav-link" href="./buy-electric">Electricity</a></li>
            <!-- <li class="nav-item"><a class="nav-link" data-toggle="tab" href="#tab-item-8">Exam Pin</a></li> -->
        </ul>
        <div class="tab-content">
            <div class="tab-pane fade active show" id="tab-item-1">
                <h4>Buy Airtime</h4>
                <div class="col-lg-12">
                    <div class="content-area card">
                        <div class="card-innr card-innr-fix">
                            <div class="gaps-1x"></div>
                            <!-- .gaps -->
                            <form action="./functions/pay-bills.php" method="post">
                                <div class="row">
                                    <div class="col-md-12">
                                        <label class="input-item-label ucap text-exlight">Network Provider</label>
                                        <ul class="d-flex flex-wrap checkbox-list">
                                            <li>
                                            <div class="input-item text-left"> 
                                    <input class="input-radio input-radio-sm" id="pma-mtn" name="network" type="radio" value="mtn"> 
                                    <span class="input-radio-circle"></span> 
                                    <label for="pma-mtn"><img src="./assets/images/mtn-icon.jpg" alt="MTN" class="payment-icon payment-icon-small" style="width: 24px;"> MTN</label> 
                                </div> 
                            </li> 
                            <li> 
                                <div class="input-item text-left"> 
                                    <input class="input-radio input-radio-sm" id="pma-glo" name="network" type="radio" value="glo"> 
                                    <span class="input-radio-circle"></span> 
                                    <label for="pma-glo"><img src="./assets/images/glo-icon.jpeg" alt="Glo" class="payment-icon payment-icon-small" style="width: 24px;"> Glo</label> 
                                </div> 
                            </li> 
                            <li> 
                                <div class="input-item text-left"> 
                                    <input class="input-radio input-radio-sm" id="pma-9mobile" name="network" type="radio" value="etisalat"> 
                                    <span class="input-radio-circle"></span> 
                                    <label for="pma-9mobile"><img src="./assets/images/9mobile-icon.png" alt="9Mobile" class="payment-icon payment-icon-small" style="width: 24px;"> 9Mobile</label> 
                                </div> 
                            </li> 
                            <li> 
                                <div class="input-item text-left"> 
                                    <input class="input-radio input-radio-sm" id="pma-airtime" name="network" type="radio" value="airtel"> 
                                    <span class="input-radio-circle"></span> 
                                    <label for="pma-airtime"><img src="./assets/images/airtel-icon.svg" alt="Airtel" class="payment-icon payment-icon-small" style="width: 36px;"> Airtel</label> 
                                </div> 
                            </li> 
                                            <!-- Add similar list items for other network providers -->
                                        </ul>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <input class="input-bordered" type="text" value="<?php echo $wallet['wallet_id']; ?>" name="wallet" hidden>
                                        <input class="input-bordered" type="text" value="<?php echo $user['user_id']; ?>" name="user" hidden>
                                        <input class="input-bordered" type="text" value="<?php echo $profile['user_id']; ?>" name="profile" hidden>
                                        <div class="input-item input-with-label">
                                            <label class="input-item-label text-exlight">Phone No</label>
                                            <div class="relative">
                                                <span class="input-icon input-icon-right"><em class="ti ti-mobile"></em></span>
                                                <input class="input-bordered" type="tel" name="phone_number">
                                            </div>
                                            <span class="input-note">Input your contact No. </span>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="input-item input-with-label">
                                            <label class="input-item-label text-exlight">Amount</label>
                                            <input class="input-bordered" type="number" min='50' max='50000' name="amount">
                                            <span class="input-note">Input your Payment Amount. </span>
                                        </div>
                                    </div>
                                </div>
                                <div class="gaps-1x"></div>
                                <button name="buy-airtime" class="btn btn-primary">Buy Airtime</button>
                            </form>
                        </div>
                        <!-- .card-innr -->
                    </div>
                    <!-- .card -->
                </div>
            </div>
            <!-- .tab-pane -->
            <div class="tab-pane fade" id="tab-item-2">
                <!-- Data Bundle content goes here -->
                <h4>Buy Data Bundle</h4>
                <div class="col-lg-12">
                    <div class="content-area card">
                        <div class="card-innr card-innr-fix">
                            <div class="gaps-1x"></div>
                            <!-- .gaps -->
                            <div class="gaps-1x"></div>
                        <!-- .gaps -->
                        <form action="./functions/pay-bills.php" method="post">
                        <div class="row">
                    <div class="col-md-12">
                    <label class="input-item-label ucap text-exlight">Network Provider</label><br>
                    <ul class="d-flex flex-wrap checkbox-list">
                                <li>
                                    <div class="input-item text-left">
                                        <input class="input-radio input-radio-sm" id="pma-mtn-data" name="data_network" type="radio" value="mtn-data">
                                        <span class="input-radio-circle"></span>
                                        <label for="pma-mtn-data"><img src="./assets/images/mtn-icon.jpg" alt="MTN" class="payment-icon payment-icon-small" style="width: 24px;"> MTN</label>
                                    </div>
                                </li>
                                <li>
                                    <div class="input-item text-left">
                                        <input class="input-radio input-radio-sm" id="pma-glo-data" name="data_network" type="radio" value="glo-data">
                                        <span class="input-radio-circle"></span>
                                        <label for="pma-glo-data"><img src="./assets/images/glo-icon.jpeg" alt="Glo" class="payment-icon payment-icon-small" style="width: 24px;"> Glo</label>
                                    </div>
                                </li>
                                <li>
                                    <div class="input-item text-left">
                                        <input class="input-radio input-radio-sm" id="pma-9mobile-data" name="data_network" type="radio" value="etisalat-data">
                                        <span class="input-radio-circle"></span>
                                        <label for="pma-9mobile-data"><img src="./assets/images/9mobile-icon.png" alt="9Mobile" class="payment-icon payment-icon-small" style="width: 24px;"> 9Mobile</label>
                                    </div>
                                </li>
                                <li>
                                    <div class="input-item text-left">
                                        <input class="input-radio input-radio-sm" id="pma-airtel-data" name="data_network" type="radio" value="airtel-data">
                                        <span class="input-radio-circle"></span>
                                        <label for="pma-airtel-data"><img src="./assets/images/airtel-icon.svg" alt="Airtel" class="payment-icon payment-icon-small" style="width: 36px;"> Airtel</label>
                                    </div>
                                </li>
                            </ul>
                    </div>
                    </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <input class="input-bordered" type="text" value="<?php echo $wallet['wallet_id']; ?>"  name="wallet" hidden>
                                    <input class="input-bordered" type="text" value="<?php echo $user['user_id']; ?>"  name="user" hidden>

                                    <input class="input-bordered" type="text" value="<?php echo $profile['user_id']; ?>"  name="profile" hidden>

                                    <div class="input-item input-with-label">
                                        <label class="input-item-label text-exlight">Duration</label>
                                        <select class="input-bordered" name="duration" id="duration-list">
                                            <option value="" selected disabled>Please select a duration</option>
                                            <!-- Duration options will be inserted here automatically -->
                                        </select>
                                        <span class="input-note">Please choose the billing duration here for the service</span>
                                    </div>


                                    <div class="input-item input-with-label">
                                        <label class="input-item-label text-exlight">Data Plans</label>
                                        <select class="input-bordered" name="data-plans" id="data-plans">
                                            <option value="" selected disabled>Please select a data plan</option>
                                            <!-- Data options will be inserted here automatically -->
                                        </select>
                                        <span class="input-note">Please choose the Data plan here for the network</span>
                                    </div>
                                    

                                </div>

                                
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="input-item input-with-label"><label class="input-item-label text-exlight">Phone No</label>
                                        <div class="relative"><span class="input-icon input-icon-right"><em class="ti ti-mobile"></em></span><input class="input-bordered" type="tel" name="phone_number"></div><span class="input-note">Input your contact No. </span></div>
                                </div>
                                

                                <div class="col-md-6">
                                <div class="input-item input-with-label"><label class="input-item-label text-exlight">Amount</label><input class="input-bordered" type="number" name="amount"  id="price-input" value="" disabled></div>
                              </div>
                                
                            </div>
                           
                            
                            <div class="gaps-1x"></div><button class="btn btn-primary" name="buy-data">Buy Data Bundle</button>
                          </form>
                        </div>
                        <!-- .card-innr -->
                    </div>
                    <!-- .card -->
                     <!-- ///////////////////////////////////////////////////////////////////// -->

                     <script>
                        // Set up an onchange event for duration and network
                        const networkRadios = document.querySelectorAll("input[name='data_network']");
                        const durationSelect = document.querySelector('#duration-list');
                        const dataPlansSelect = document.querySelector('#data-plans');
                        const priceInput = document.getElementById("price-input");

                        dataPlansSelect.addEventListener("change", getPrice);

                        networkRadios.forEach(radio => {
                            radio.addEventListener("change", getDurations);
                        });

                        durationSelect.addEventListener("change", getProducts);

                        function getDurations() {
                            // Get the selected network value
                            const network = document.querySelector('input[name="data_network"]:checked').value;
                            //console.log("Selected network: " + network);

                            // Send a request to the server to retrieve the duration options
                            fetch("./get_durations.php", {
                                method: "POST",
                                headers: {
                                    "Content-Type": "application/x-www-form-urlencoded"
                                },
                                body: "data_network=" + network
                            })
                            .then(response => {
                                // Check if the request was successful
                                if (!response.ok) {
                                    throw new Error("HTTP error " + response.status);
                                }
                                return response.text();
                            })
                            .then(data => {
                                // Output the duration options
                                const durationList = document.getElementById("duration-list");
                                durationList.innerHTML = data;
                            })
                            .catch(error => {
                                // Handle any errors
                                //console.error("Error:", error);
                            });
                        }

                        //----------------------------------------------------------------

                        function getProducts() {
                            // Get the selected network and duration
                            const network = document.querySelector('input[name="data_network"]:checked').value;
                            const duration = durationSelect.value;
                            //console.log(duration);

                            // Send a request to the server to retrieve the product options
                            fetch("get_products.php", {
                                method: "POST",
                                headers: {
                                    "Content-Type": "application/x-www-form-urlencoded"
                                },
                                body: `data_network=${encodeURIComponent(
                                    network
                                )}&duration=${encodeURIComponent(duration)}`
                            })
                            .then(response => {
                                // Check if the request was successful
                                if (!response.ok) {
                                    throw new Error("HTTP error " + response.status);
                                }
                                return response.text();
                            })
                            .then(data => {
                                //console.log(data);
                                const dataPlans = document.getElementById("data-plans");
                                dataPlans.innerHTML = data;
                            })
                            .catch(error => {
                                // Handle any errors
                                //console.error("Error:", error);
                            });
                        }

                        //----------------------------------------------------------------
                        //Function to get product price
                        function getPrice() {
                            const dataPlan = dataPlansSelect.value;
                            //console.log(dataPlan);

                            // Send a request to the server to retrieve the price
                            fetch("./get_product_price.php", {
                                method: "POST",
                                headers: {
                                    "Content-Type": "application/x-www-form-urlencoded"
                                },
                                body: "data_plan=" + encodeURIComponent(dataPlan)
                            })
                            .then(response => {
                                // Check if the request was successful
                                if (!response.ok) {
                                    throw new Error("HTTP error " + response.status);
                                }
                                return response.text();
                            })
                            .then(data => {
                                // Output the price
                                priceInput.value = data;
                                console.log("Price: " + data);
                            })
                            .catch(error => {
                                // Handle any errors
                                console.error("Error:", error);
                            });
                        }
                    </script>


                     <!--////////////////////////////////////////////////////////////////////////// -->
                </div>
            </div>
            <!-- .tab-pane -->
        </div>
        <!-- .tab-content -->
    </div>
    <!-- .card-innr -->
</div>
<!-- .content-area card -->
        <!-- .card -->

        <script>
    // Add JavaScript code here to enable tab functionality
   $('.nav-tabs a').click(function (e) {
              e.preventDefault();
               $(this).tab('show');
             });
</script>
            
                <div class="col-xl-4 col-lg-5">
                    <div class="token-sales card card-full-height">
                        <div class="card-innr">
                            
                        </div>
                    </div>
                </div>

                <!-- .col -->
                <div class="col-xl-8 col-lg-7">
                    <div class="token-transaction card card-full-height">
                        <div class="card-innr">
                            <div class="card-head has-aside">
                                <h4 class="card-title">Transaction</h4>
                                <div class="card-opt"><a href="transactions" class="link ucap">View ALL <em class="fas fa-angle-right ml-2"></em></a></div>
                            </div>
                            
                            <table class="table tnx-table">
                                <thead>
                                    <tr>
                                        <th>Tranx Ref</th>
                                        <th>Amount</th>
                                        <th class="d-none d-sm-table-cell tnx-date">Date</th>
                                        <th class="tnx-type">
                                            <div class="tnx-type-text"></div>
                                        </th>
                                    </tr>
                                    <!-- tr -->
                                </thead>
                                <!-- thead -->
                                <tbody>

                                    <?php

                                    require_once './functions/validation.php';
                                    getTop5LatestTransactions($user['user_id']);
                                    
                                    ?>
                                    
                                    <!-- tr -->
                                </tbody>
                                <!-- tbody -->
                            </table>
                            <!-- .table -->
                        </div>
                    </div>
                </div>
                <div class="col-xl-4 col-lg-5">
                    <div class="token-calculator card card-full-height">
                        <div class="card-innr">
                            
                        </div>
                    </div>
                </div>
            </div>
            <!-- .row -->
            
            <!-- .row -->
        </div>
        <!-- .container -->
    </div>
    <!-- .page-content -->





<script>

    document.getElementById("provider-list").addEventListener("change", getDurations);

    function getDurations() {
        const radioInputs = document.querySelectorAll("[name='network']");
        let selectedNetwork = radiolInputs
            .find(radio => radio.checked)
            .getAttribute("data-service");

        const xhr = new XMLHttpRequest();
        xhr.open("GET", "./functions/get_durations.php?network=" + encodeURIComponent(selectedNetwork));
        xhr.onreadystatechange = () => {
            if (xhr.readyState === XMLHttpRequest.DONE && xhr.status === 200) {
                const durationList = document.getElementById("duration-list");
                durationList.innerHTML = xhr.responseText;
            }
        };
        xhr.send();
    }








    // Select the icon elements by their id attribute
const icon1 = document.getElementById('icon-1');
const icon2 = document.getElementById('icon-2');

// Select the input elements by their id attribute
const input1 = document.getElementById('input-1');
const input2 = document.getElementById('input-2');

// Add a click event listener to the first icon
icon1.addEventListener('click', () => {
  input1.focus();
});

// Add a click event listener to the second icon
icon2.addEventListener('click', () => {
  input2.focus();
});
</script>

























<?php 

require_once 'footer.php';

?>