<?php
// Start the session
session_start();

// Check if the user is logged in
if (isset($_SESSION['user'])) {
  require_once './config/database.php';
  require_once './functions/function.php';
  // Get the user details from the database
  $user_id = $_SESSION['user'];

  $user = getUser($user_id);
  $wallet = getWallet($user_id);
  $profile = getProfile($user_id);
  $transaction = getTransactions($user_id);
 

} else {
    header("Location: ./login.php");
}

$title = 'Buy Data Bundle';

?>

<!DOCTYPE html>
<html lang="en" class="js">

<head>
    <meta charset="utf-8">
    <meta name="author" content="Dasodhub">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="Pay Bills Seamlessly With the Trilspay App">
    <!-- Fav Icon -->
    <link rel="shortcut icon" href="./assets/images/favicon1.png">
    
    <!-- Site Title  -->
    <title><?php echo $title ?> - Pay Bills Seamlessly with Trilspay</title>
    <!-- Vendor Bundle CSS -->
    <link rel="stylesheet" href="assets/css/vendor.bundle49f7.css?ver=104">
    <!-- Custom styles for this template -->
    <link rel="stylesheet" href="assets/css/style.css" id="layoutstyle">
    
    <script>
        (function(i, s, o, g, r, a, m) {
            i['GoogleAnalyticsObject'] = r;
            i[r] = i[r] || function() {
                (i[r].q = i[r].q || []).push(arguments)
            }, i[r].l = 1 * new Date();
            a = s.createElement(o), m = s.getElementsByTagName(o)[0];
            a.async = 1;
            a.src = g;
            m.parentNode.insertBefore(a, m)
        })(window, document, 'script', '../../www.google-analytics.com/analytics.js', 'ga');
        ga('create', 'UA-91615293-2', 'auto');
        ga('send', 'pageview');
    </script>
</head>








<?php 
 require_once './topbar.php';
?>



<!-- .topbar-wrap -->
<div class="page-content">
    <div class="container">
        <div class="card"></div>
        <!-- .card -->
        <div class="col-lg-12">
        <?php
                 //CODE TO RETURN EITHER  AN ERROR OR SUCCESS MESSAGE
                    if (isset($_GET['error'])) {
                        $errorMessage = urldecode($_GET['error']);
                        echo "<div class='alert alert-danger'>$errorMessage</div>";
                    }

                    if (isset($_GET['message'])) {
                        $message = urldecode($_GET['message']);
                        echo "<div class='alert alert-success'>$message</div>";
                    }

                    //END OF CODE TO RETURN EITHER ERROR OR SUCCESS MESSAGE
                    ?>
                <div class="content-area card">
                    <div class="card-innr card-innr-fix">
                        <div class="card-head">
                            <h6 class="card-title">Buy Data Bundle</h6>
                        </div>
                        <div class="gaps-1x"></div>
                        <!-- .gaps -->
                        <form action="./functions/pay-bills.php" method="post">
                        <div class="row">
                    <div class="col-md-12">
                    <label class="input-item-label ucap text-exlight">Network Provider</label><br>
                        <ul class="d-flex flex-wrap checkbox-list">
                            <li>
                                <div class="input-item text-left">
                                    <input class="input-radio input-radio-sm" id="pma-mtn" name="network" type="radio" value="mtn-data">
                                    <span class="input-radio-circle"></span>
                                    <label for="pma-mtn"><img src="./assets/images/mtn-icon.jpg" alt="MTN" class="payment-icon payment-icon-small" style="width: 24px;"> MTN</label>
                                </div>
                            </li>
                            <li>
                                <div class="input-item text-left">
                                    <input class="input-radio input-radio-sm" id="pma-glo" name="network" type="radio" value="glo-data">
                                    <span class="input-radio-circle"></span>
                                    <label for="pma-glo"><img src="./assets/images/glo-icon.jpeg" alt="Glo" class="payment-icon payment-icon-small" style="width: 24px;"> Glo</label>
                                </div>
                            </li>
                            <li>
                                <div class="input-item text-left">
                                    <input class="input-radio input-radio-sm" id="pma-9mobile" name="network" type="radio" value="etisalat-data">
                                    <span class="input-radio-circle"></span>
                                    <label for="pma-9mobile"><img src="./assets/images/9mobile-icon.png" alt="9Mobile" class="payment-icon payment-icon-small" style="width: 24px;"> 9Mobile</label>
                                </div>
                            </li>
                            <li>
                                <div class="input-item text-left">
                                    <input class="input-radio input-radio-sm" id="pma-airtime" name="network" type="radio" value="airtel-data">
                                    <span class="input-radio-circle"></span>
                                    <label for="pma-airtime"><img src="./assets/images/airtel-icon.svg" alt="Airtel" class="payment-icon payment-icon-small" style="width: 36px;"> Airtel</label>
                                </div>
                            </li>
                        </ul>
                    </div>
                    </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <input class="input-bordered" type="text" value="<?php echo $wallet['wallet_id']; ?>"  name="wallet" hidden>
                                    <input class="input-bordered" type="text" value="<?php echo $user['user_id']; ?>"  name="user" hidden>

                                    <input class="input-bordered" type="text" value="<?php echo $profile['user_id']; ?>"  name="profile" hidden>

                                    <div class="input-item input-with-label">
                                        <label class="input-item-label text-exlight">Duration</label>
                                        <select class="input-bordered" name="duration" id="duration-list">
                                            <option value="" selected disabled>Please select a duration</option>
                                            <!-- Duration options will be inserted here automatically -->
                                        </select>
                                        <span class="input-note">Please choose the billing duration here for the service</span>
                                    </div>


                                    <div class="input-item input-with-label">
                                        <label class="input-item-label text-exlight">Data Plans</label>
                                        <select class="input-bordered" name="data-plans" id="data-plans">
                                            <option value="" selected disabled>Please select a data plan</option>
                                            <!-- Data options will be inserted here automatically -->
                                        </select>
                                        <span class="input-note">Please choose the Data plan here for the network</span>
                                    </div>
                                    

                                </div>

                                
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="input-item input-with-label"><label class="input-item-label text-exlight">Phone No</label>
                                        <div class="relative"><span class="input-icon input-icon-right"><em class="ti ti-mobile"></em></span><input class="input-bordered" type="tel" name="phone_number"></div><span class="input-note">Input your contact No. </span></div>
                                </div>
                                

                                <div class="col-md-6">
                                <div class="input-item input-with-label"><label class="input-item-label text-exlight">Amount</label><input class="input-bordered" type="number" name="amount"  id="price-input" value="" disabled></div>
                              </div>
                                
                            </div>
                           
                            
                            <div class="gaps-1x"></div><button class="btn btn-primary" name="buy-data">Buy Data Bundle</button>
                          </form>
                    </div>
                    <!-- .card-innr -->
                </div>
                <!-- .card -->


            </div>



    </div>
    <!-- .container -->
</div>
<!-- .page-content -->

<script>
  // Set up an onchange event for duration and network
  const networkRadios = document.querySelectorAll("input[name='network']");
  const durationSelect = document.querySelector('#duration-list');
  const dataPlansSelect = document.querySelector('#data-plans');
  const priceInput = document.getElementById("price-input");

  dataPlansSelect.addEventListener("change", getPrice);

  networkRadios.forEach(radio => {
    radio.addEventListener("change", getDurations);
  });

  durationSelect.addEventListener("change", getProducts);

  function getDurations() {
    // Get the selected network value
    const network = document.querySelector('input[name="network"]:checked').value;
    //console.log("Selected network: " + network);

    // Send a request to the server to retrieve the duration options
    fetch("./get_durations.php", {
      method: "POST",
      headers: {
        "Content-Type": "application/x-www-form-urlencoded"
      },
      body: "network=" + network
    })
    .then(response => {
      // Check if the request was successful
      if (!response.ok) {
        throw new Error("HTTP error " + response.status);
      }
      return response.text();
    })
    .then(data => {
      // Output the duration options
      const durationList = document.getElementById("duration-list");
      durationList.innerHTML = data;
    })
    .catch(error => {
      // Handle any errors
      //console.error("Error:", error);
    });
  }

  //----------------------------------------------------------------

  function getProducts() {
    // Get the selected network and duration
    const network = document.querySelector('input[name="network"]:checked').value;
    const duration = durationSelect.value;
    //console.log(duration);

    // Send a request to the server to retrieve the product options
    fetch("get_products.php", {
      method: "POST",
      headers: {
        "Content-Type": "application/x-www-form-urlencoded"
      },
      body: `network=${encodeURIComponent(
        network
      )}&duration=${encodeURIComponent(duration)}`
    })
    .then(response => {
      // Check if the request was successful
      if (!response.ok) {
        throw new Error("HTTP error " + response.status);
      }
      return response.text();
    })
    .then(data => {
    //console.log(data);
    const dataPlans = document.getElementById("data-plans");
    dataPlans.innerHTML = data;
    })
    .catch(error => {
      // Handle any errors
      //console.error("Error:", error);
    });
  }

//----------------------------------------------------------------
//Function to get product price
function getPrice() {
    const dataPlan = dataPlansSelect.value;
    //console.log(dataPlan);

    // Send a request to the server to retrieve the price
    fetch("./get_product_price.php", {
        method: "POST",
        headers: {
            "Content-Type": "application/x-www-form-urlencoded"
        },
        body: "data_plan=" + encodeURIComponent(dataPlan)
    })
   .then(response => {
        // Check if the request was successful
        if (!response.ok) {
            throw new Error("HTTP error " + response.status);
        }
        return response.text();
    })
   .then(data => {
        // Output the price
        document.getElementById("price-input").value = data;
        console.log("Price: " + data);
    })
   .catch(error => {
        // Handle any errors
        console.error("Error:", error);
    });
}




</script>







<?php 


if(isset($_POST['buy-data'])){
  print_r($_POST);
}



require_once './footer.php';
?>