<?php

if(isset($_POST['reset-password'])) {
    require '../config/config.php';
    require_once '../config/database.php';
   

    $email = filter_var($_POST['email'], FILTER_SANITIZE_EMAIL);

    if(empty($email)) {
        // Return the user back to the login page with an error message
        header ('Location:../forgot?error=Email+is+required');
        exit();
    }

    


    // Prepare the SQL statement
    $sql = "SELECT * FROM users WHERE email = :email";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':email', $email);

    // Execute the statement
    $stmt->execute();

    // Check if the email exists in the database
    if($stmt->rowCount() > 0) {
       
        // The email exists in the database, continue with the code to reset the password
            // Generate a random 16 digit alphanumeric code
        $forget_password = substr(str_shuffle("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTU234567890ABCDEF"), 0, 16);

        // Prepare the SQL statement
        $sql = "UPDATE users SET forget_password = :forget_password WHERE email = :email";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':email', $email);
        $stmt->bindParam(':forget_password', $forget_password);

        // Execute the statement
        $stmt->execute();

        require_once './mailer.php';
        // Send the email to the user
        $recipient = $email;
        $subject = 'Password Reset Request';
        $message = 'Hello User,
        You have requested to reset your password. Your new password is '. $forget_password.'
        Please visit the following link to reset your password: '. $site_url.'/reset_password?email='. $email.'&token='. $forget_password.'
        Thank you.';
        $send = sendEmail($recipient, $senderName, $subject, $message);
        
        if($send) {
            header('Location:../forgot?success=Email+sent+successfully');
        } else {
            header('Location:../forgot?error=Email+not+sent');
        }

    } else {
        // The email does not exist in the database, return the user back to the forget page with an error message
        header ('Location:../forgot?success=Email+sent+successfully');
        exit();
    }





} else {
    header ('Location: ../forgot');
}