<?php


//FUNCTION TO VALIDATE USERNAME
function validate_username($username) {
    // Check if the username is at least 3 characters
    if (strlen($username) < 3) {
        return false;
    }

    // Check if the username contains only letters and numbers
    if (!preg_match('/^[a-zA-Z0-9]+$/', $username)) {
        return false;
    }

    return true;
}


//FUNCTION TO GENERATE REFERRAL CODE

function generate_referral_code() {
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $referral_code = '';

    // Generate a random referral code
    for ($i = 0; $i < 6; $i++) {
        $referral_code .= $characters[rand(0, strlen($characters) - 1)];
    }

    return $referral_code;
}

//FUNCTION TO GENERATE USER VERIFICATION CODE

function generate_unique_verification_string_md5($length = 10) {
    // Generate a random number
    $random = rand();

    // Generate the current time
    $current_time = time();

    // Combine the random number and the current time
    $string = $random . $current_time;

    // Generate an MD5 hash of the string
    $verification_string = md5($string);


    return $verification_string;
}


//FUNCTION TO GENERATE A UNIQUE USER ID ON REGISTRATION

// Function to generate a random 6-digit code
function generateRandomCode() {
    $code = '';
    $characters = '0123456789';
    for ($i = 0; $i < 6; $i++) {
        $code .= $characters[mt_rand(0, strlen($characters) - 1)];
    }
    return $code;
}

// Function to check if the user ID exists in the database
function checkIfUserIdExists($userId) {
    global $pdo;
    $stmt = $pdo->prepare('SELECT COUNT(*) FROM users WHERE user_id = :user_id');
    $stmt->bindValue(':user_id', $userId);
    $stmt->execute();
    $count = $stmt->fetchColumn();
    return $count > 0;
}


// Function to insert a new user profile record
function createUserProfile($pdo, $user_id, $referredBy) {
     // Check if the user exists in the users table
     $stmt = $pdo->prepare('SELECT * FROM users WHERE user_id = :user_id');
     $stmt->bindParam(':user_id', $user_id);
     $stmt->execute();
 
     if ($stmt->rowCount() > 0) {
         // User exists, so create a new row in the user_profiles table
         $stmt = $pdo->prepare('
             INSERT INTO user_profiles (user_id, referred_by)
             VALUES (:user_id, :referredBy)
         ');
         $stmt->bindParam(':user_id', $user_id);
         $stmt->bindParam(':referredBy', $referredBy);
 
         return $stmt->execute();
     }
 
     return false;
}


//FUNCTION TO GENERATE RANDOM USER WALLET ID

function generateRandomWalletId($pdo): string
{
    $walletId = '';
    $currentTime = time();

    // Generate a random string of 13 characters
    for ($i = 0; $i < 13; $i++) {
        $random = mt_rand(0, 35);

        if ($random < 10) {
            $walletId .= chr($random + ord('0'));

        } else {
            $walletId .= chr($random + ord('A') - 10);
        }
    }

    // Add the current timestamp
    $walletId .= substr($currentTime, -5);

    // Make sure the wallet ID is unique
    do {
        // Check if the wallet ID is already taken
        $stmt = $pdo->prepare('
            SELECT COUNT(wallet_id)
            FROM wallets
            WHERE wallet_id = :wallet_id
        ');
        $stmt->bindValue(':wallet_id', $walletId, PDO::PARAM_STR);
        $stmt->execute();

        $count = $stmt->fetchColumn();

        if ($count > 0) {
            // If the wallet ID is taken, generate a new one
            $walletId = '';

            for ($i = 0; $i < 13; $i++) {
                $random = mt_rand(0, 35);

                if ($random < 10) {
                    $walletId .= chr($random + ord('0'));

                } else {
                    $walletId .= chr($random + ord('A') - 10);
                }
            }

            $walletId .= substr($currentTime, -5);
        }

    } while ($count > 0);

    return $walletId;
}


/**
 * Generate a new wallet record for the user with the specified user ID.
 *
 * @param PDO $pdo PDO database connection
 * @param string $userId User ID
 *
 * @return bool TRUE if the wallet record was created successfully, FALSE otherwise.
 */
function createWalletForUser(PDO $pdo, string $userId)
{
    $walletId = generateRandomWalletId($pdo);
    $stmt = $pdo->prepare('
        INSERT INTO wallets (wallet_id,user_id, balance)
        VALUES (:wallet_id, :user_id, 0)
    ');

    $stmt->bindValue(':user_id', $userId, PDO::PARAM_STR);
    $stmt->bindValue(':wallet_id', $walletId, PDO::PARAM_STR);

    try {
        $result = $stmt->execute();

        if ($result) {
            $walletId = $pdo->lastInsertId();
            return [
                'walletId' => $walletId,
                'userId' => $userId,
                'balance' => 0,
                'created' => date('Y-m-d H:i:s'),
                'updated' => date('Y-m-d H:i:s'),
            ];
        }
        return false;
    } catch (PDOException $e) {
        return false;
    }
}




//FUNCTION TO SEND USER VERIFICATION LINK

function sendVerificationEmail($email, $verificationCode, $username, $verificationTime)
{
    // Email configuration
    global $baseUrl;
    $fromEmail = 'your-email@example.com';
    $fromName = 'Your Name';
    $toEmail = $email;
    $subject = 'Email Verification';
    $message = "
        Hello $username,\n

        Welcome to our platform! To complete your registration, please click on the following link:\n

        .$baseUrl./verify-email?code=$verificationCode&time=$verificationTime

        This link will expire in 24 hours.

        Regards,
        Your Name
    ";
    $headers = "From: $fromName <$fromEmail>" . "\r\n" .
              "Reply-To: $fromEmail" . "\r\n" .
              "X-Mailer: PHP/" . phpversion();

    // Send the email
    if (mail($toEmail, $subject, $message, $headers)) {
        echo "Verification email sent successfully...\n";

    } else {
        echo "Failed to send verification email...\n";
    }
}


//FUNCTION TO VERIFY USER EMAIL OR USERNAME

// function checkUserInput($input, $pdo) {
//     // Check if the input is a valid email
//     if (filter_var($input, FILTER_VALIDATE_EMAIL)) {
//       // The input is an email
//       $stmt = $pdo->prepare('
//         SELECT *
//         FROM users
//         WHERE email = :email
//       ');
  
//     } else {
//       // The input is not an email
//       $stmt = $pdo->prepare('
//         SELECT *
//         FROM users
//         WHERE username = :username
//       ');
  
//       $stmt->bindValue(':username', $input);
  
//     }
  
//     if (!empty($input)) {
//        $stmt = $pdo->prepare('
//         SELECT *
//         FROM users
//         WHERE email = :email
//         LIMIT 1
// ');

// $stmt->bindValue(':email', $input);
//         $stmt->bindValue(':email', $input);
//     }
  
//     $stmt->execute();
  
//     $user = $stmt->fetch(PDO::FETCH_ASSOC);
  
//     if ($user) {
//       return $user;
//     }
  
//     return null;
//   }


// // Validate the login input
// function get_user_by_username_or_email($login) {
//     // Replace this with actual database query
//     $db = new PDO('mysql:host=localhost;dbname=trilspay-new;charset=utf8', 'root', '');
//     $stmt = $db->prepare('SELECT * FROM users WHERE username = :input OR email = :input');
//     $stmt->bindParam(':input', $login);
//     $stmt->execute();
//     $user = $stmt->fetch();

//     // Return the user array if found, or null otherwise
//     if ($user) {
//         return $user;
//         print_r($user);
//     } else {
//         return null;
//     }
// }


//FUNCTION TO SET COOKIES FOR USERS 

function setRememberMeCookie($username, $expiration) {
    // Set the cookie name
    $cookieName = 'rememberMe';
  
    // Set the cookie value
    $cookieValue = hash('sha256', $username . $expiration);
  
    // Set the cookie expiration time
    $expiry = time() + ($expiration * 24 * 60 * 60);
  
    // Set the cookie
    setcookie($cookieName, $cookieValue, $expiry, '/');
  }
  
 

  //FUNCTION TO CHECK IF USER SET COOKIES

  function checkRememberMeCookie() {
    // Set the cookie name
    $cookieName = 'rememberMe';
  
    // Check if the cookie exists
    if (isset($_COOKIE[$cookieName])) {
      // Get the cookie value
      $cookieValue = $_COOKIE[$cookieName];
  
      // Get the current time
      $currentTime = time();
  
      // Set the expiration time
      $expiry = $currentTime + (24 * 60 * 60);
  
      // Check if the cookie is still valid
      if ($currentTime < $expiry) {
        // Get the username from the cookie value
        $cookieValueParts = explode('|', $cookieValue);
        $username = $cookieValueParts[0];
  
        // Get the expiration time from the cookie value
        $expiration = $cookieValueParts[1];
  
        // Check if the username and expiration time match
        if ($username && $expiration) {
          return true;
        }
      }
    }
  
    return false;
  }
  

  //Verify the CSRF token on form submission

  function verifyCsrfToken() {
    // Get the token from the form
    $token = $_POST['csrf_token'];
  
    // Check if the token matches the stored token
    if ($token !== $_SESSION['csrf_token']) {
      // Token does not match
      return false;
    }
  
    // Token matches
    return true;
  }
  


  //FUNCTION TO CHECK USER INPUT AND GET USER DETAILS

function getUserDetails($userInput, $password) {
    if (filter_var($userInput, FILTER_VALIDATE_EMAIL)) {
        // The user input is an email address
        $email = $userInput;
        $username = null;
    } else {
        // The user input is not an email address, so it should be a username
        if (preg_match('/^[a-zA-Z0-9]{4,16}$/', $userInput)) {
            // The username is valid, so you can proceed
            $username = $userInput;
            $email = null;
        } else {
            // The username is not valid, so you can return an error message
            return false;
        }
    }

    global $pdo; // You need to have a $pdo variable that contains the PDO connection object to the database

    if ($username) {
        $stmt = $pdo->prepare("SELECT user_id, password FROM users WHERE username = :username LIMIT 1");
        $stmt->bindParam(":username", $username);
        $stmt->execute();
    }
    else if ($email) {
        $stmt = $pdo->prepare("SELECT user_id, password FROM users WHERE email = :email LIMIT 1");
        $stmt->bindParam(":email", $email);
        $stmt->execute();
    }

    if ($stmt->rowCount() > 0) {
        $user = $stmt->fetch();

        // Check if the password is not empty
        if (empty($password)) {
            // The password is not provided
            $error_message = urlencode("The password is not provided. Please try again.");
            return [false, $error_message];
        }

        // Hash the password provided by the user
        $hashed_password = password_hash($password, PASSWORD_DEFAULT);

        // Check if the provided password matches the hashed password stored in the database
        if (!password_verify($password, $user['password'])) {
            // The password is incorrect
            $error_message = urlencode("The password is incorrect. Please try again.");
            return [false, $error_message];
        }

        return [$user, ''];
    }
    else {
        return [false, 'The user could not be found in the database. Please try again.'];
    }
}


//CHECK IF USER COOKIES ARE SET

function autoLogIn()
{
    // Check if the user's cookie is set
    if (isset($_COOKIE['user']) && !empty($_COOKIE['user'])) {

        // Decode the user's cookie
        $user_cookie = json_decode($_COOKIE['user']);

        // Check if the user's cookie is still valid
        if (isset($user_cookie->expiration) && $user_cookie->expiration > time()) {

            // The user's cookie is still valid, so set the user's session

            // Connect to the database
            require '../config/database.php';

            // Sanitize the user input
            $user_input = htmlspecialchars(trim($user_cookie->userInput), ENT_QUOTES, 'UTF-8');

            // Check if the user input is a valid email
            if (filter_var($user_input, FILTER_VALIDATE_EMAIL)) {

                $query = "SELECT * FROM users WHERE email = ?";

            } else {

                // The user input is not a valid email, so assume it is a username

                $query = "SELECT * FROM users WHERE username = ?";

            }

            // Prepare the query
            $stmt = $conn->prepare($query);

            // Bind the user input
            $stmt->bind_param("s", $user_input);

            // Execute the query
            $stmt->execute();

            // Get the user's details
            $result = $stmt->get_result();

            if ($row = $result->fetch_assoc()) {

                // The user's details are valid, so set the user's session

                // Set the user session
                session_start();
                $_SESSION['user'] = $row;

                // Redirect the user to the dashboard
                header('Location: ../dashboard.php');
                exit();

            }

        }

    }

}

//----------------------------------------------------------------
//GET USER DETAILS ON DASHBOARD
function getUser($user_id) {
    global $pdo;

    try {
        // Prepare a query to get the user details
        $stmt = $pdo->prepare('SELECT * FROM users WHERE user_id = ?');

        // Bind the user ID to the query
        $stmt->bindValue(1, $user_id);

        // Execute the query
        $stmt->execute();

        // Check if the query succeeded
        if ($stmt->execute()) {
            // Fetch the user details
            $user = $stmt->fetch(PDO::FETCH_ASSOC);

            // Return the user details
            return $user;
        } else {
            echo "Error executing query: " . $pdo->errorInfo();
        }
    } catch (PDOException $e) {
        echo "Error connecting to the database: " . $e->getMessage();
    }
}

//----------------------------------------------------------------
//GET USER WALLET DETAILS ON DASHBOARD
function getWallet($user_id) {
    global $pdo;

    try {
        // Prepare a query to get the user details
        $stmt = $pdo->prepare('SELECT * FROM wallets WHERE user_id = ?');

        // Bind the user ID to the query
        $stmt->bindValue(1, $user_id);

        // Execute the query
        $stmt->execute();

        // Check if the query succeeded
        if ($stmt->execute()) {
            // Fetch the user details
            $user = $stmt->fetch(PDO::FETCH_ASSOC);

            // Return the user details
            return $user;
        } else {
            echo "Error executing query: " . $pdo->errorInfo();
        }
    } catch (PDOException $e) {
        echo "Error connecting to the database: " . $e->getMessage();
    }
}


//----------------------------------------------------------------
//GET USER WALLET DETAILS ON DASHBOARD
function getProfile($user_id) {
    global $pdo;

    try {
        // Prepare a query to get the user details
        $stmt = $pdo->prepare('SELECT * FROM user_profiles WHERE user_id = ?');

        // Bind the user ID to the query
        $stmt->bindValue(1, $user_id);

        // Execute the query
        $stmt->execute();

        // Check if the query succeeded
        if ($stmt->execute()) {
            // Fetch the user details
            $user = $stmt->fetch(PDO::FETCH_ASSOC);

            // Return the user details
            return $user;
        } else {
            echo "Error executing query: " . $pdo->errorInfo();
        }
    } catch (PDOException $e) {
        echo "Error connecting to the database: " . $e->getMessage();
    }
}

//----------------------------------------------------------------
//GET USER WALLET DETAILS ON DASHBOARD
function getTransactions($user_id) {
    global $pdo;

    try {
        // Prepare a query to get the user details
        $stmt = $pdo->prepare('SELECT * FROM transactions WHERE user_id = ?');

        // Bind the user ID to the query
        $stmt->bindValue(1, $user_id);

        // Execute the query
        $stmt->execute();

        // Check if the query succeeded
        if ($stmt->execute()) {
            // Fetch the user details
            $user = $stmt->fetch(PDO::FETCH_ASSOC);

            // Return the user details
            return $user;
        } else {
            echo "Error executing query: " . $pdo->errorInfo();
        }
    } catch (PDOException $e) {
        echo "Error connecting to the database: " . $e->getMessage();
    }
}