<?php

if (isset($_POST['login'])) {

//COLLECT USER INPUT
require '../config/database.php';
require './function.php';

//SANITIZE THE USER INPUT
$userInput = filter_var($_POST['userInput'], FILTER_SANITIZE_FULL_SPECIAL_CHARS);

$password = filter_var($_POST['password'], FILTER_SANITIZE_FULL_SPECIAL_CHARS);

$remember_me = '';

// CHECK IF USER INPUT IS EMPTY
if (empty($userInput)) {
  // RETURN AN ERROR TO THE LOGIN PAGE
  $error_message = urlencode("Username cannot be empty!");
  header('Location: ../login?error=' . $error_message);
  exit();
}

$user_details = getUserDetails($userInput, $password);

if ($user_details[0] === false) {
  // The user's details could not be retrieved
  header('Location: ../login?error=' . $user_details[1]);
  exit();
}

// Set user session and cookie based on the value of the "remember me" checkbox
if ($remember_me) {
  // Set user session and cookie
  session_start();
  $_SESSION['user'] = $user_details[0]['user_id'];
  setcookie('user', json_encode($user_details), time() + 60 * 60 * 24 * 30, '/', null, true, true);
  // Redirect the user to the dashboard
header('Location: ../dashboard');
  exit();

  
} else {
  // Set user session
  session_start();
  $_SESSION['user'] = $user_details[0]['user_id'];
  
  
  // Redirect the user to the dashboard
header('Location: ../dashboard');
  exit();

}

print_r($_POST);
echo '<br>';
print_r(session_regenerate_id());






} else {
    header('Location: ../login');
}