<?php
require_once __DIR__ . '/../vendor/autoload.php';
 use GuzzleHttp\Client;






//         //----------------------------------------------------------------
// //FUNCTION TO BUY AIRTIME FROM VTPASS

// function sendRequest($client, $network, $phone_number, $amount, $paymentReference)
// {
//     $data = [
//         'request_id' => $paymentReference,  // Use a unique reference for each transaction
//         'serviceID' => $network,
//         'phone' => $phone_number,
//         'amount' => $amount,
//     ];

//     try {
//         $response = $client->post('purchase/buy_airtime', [
//             'form_params' => $data,
//         ]);

//         if ($response->getStatusCode() === 000) {
//             $body = $response->getBody();
//             $responseData = json_decode($body, true);

//             // Successful purchase, handle the response here
//             // For example, save it to the database or show it to the user

//         } else {
//             // There was an error with the response, handle it here
//             // For example, the response could be a 400 error due to invalid input
//             $error = json_decode($response->getBody(), true);
//             // Log or show the error message
//             echo 'Error: ' . $error['message'];
//         }

//     } catch (Exception $e) {
//         // Handle network-related errors or exceptions here
//         echo 'Error: ' . $e->getMessage();
//     }
// }

//FUNCTION TO GENERATE PAYMENT REFERENCE 

function generatePaymentReference($length = 20)
{
    // Generate a random string
    $randomString = '';
    $alphanumericChars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
    while (strlen($randomString) < $length - 8) {
        $randomChar = $alphanumericChars[mt_rand(0, strlen($alphanumericChars) - 1)];
        $randomString .= $randomChar;
    }

    // Generate the date portion of the payment reference
    $date = gmdate('YmdGis', time() + (60 * 60)); // get GMT+1 timestring

    // Combine the date and random string to create the payment reference
    $paymentReference = "$date$randomString";

    // Check if the payment reference is of the required length
    if (strlen($paymentReference) !== $length) {
        throw new Exception('Unable to generate payment reference of the required length.');
    }

    return $paymentReference;
}

//FUNCTION TO GENERATE 5 RANDOM STRING FOR TRANSACTION
function generateRandomString($length = 5) {
    $characters = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    $charactersLength = strlen($characters);
    $randomString = "";
    for ($i= 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, $charactersLength -1)];
    }
    return $randomString;
}

        date_default_timezone_set('Africa/Lagos');
        //Get current time
        $currentTime = new DateTime();
        $formattedTime = $currentTime->format('YmdHi');


// ////////////////////////////////////////////////////////////////



// // Check if the form was submitted
// if ($_SERVER['REQUEST_METHOD'] == 'POST') {
//     include '../config/database.php';
//     // Check if the "Buy Airtime" button was clicked
//     if (isset($_POST['buy-airtime'])) {


//         $client = new Client(['base_uri' => 'https://sandbox.vtpass.com/api/pay']);

//         // You might want to store the base_uri and other configurations to variables
//         // and reuse them throughout your application
        
//         $base_uri = 'https://sandbox.vtpass.com/api/pay';
//         $headers = [
//             'Content-Type' => 'application/x-www-form-urlencoded',
//         ];
        
//         // Make sure you use your actual API key
//         $api_key = '72fd2f4ca43d10fcb04fa3adf8169f1f';

//         //Make sure to use your actual secret key here 
//         $secret_key = 'SK_50073a1d1587e219db742762f08eff3c82cc395e801';
        
//         $config = [
//             'base_uri' => $base_uri,
//             'headers' => [
//                 'ApiKey' => $api_key,
//                 'Content-Type' => 'application/x-www-form-urlencoded',
//                 'SecretKey' => $secret_key,
//             ],
//         ];
        
//         $client = new Client($config);

//         // Validate and sanitize network input
//         if (empty($_POST['network'])) {
//             $error = 'Please select a network provider.';
//             header('Location: ../dashboard.php?error=' . urlencode($error));
//             exit;
//         }
//         

//         /////////////////////////////////////////////


//         try {
//             // Establish a connection to the MySQL database
            
        
//             // Query the users table
//             $userStmt = $pdo->prepare('SELECT * FROM users WHERE user_id = :userId');
//             $userStmt->bindParam(':userId', $user);
//             $userStmt->execute();
//             $userRow = $userStmt->fetch(PDO::FETCH_ASSOC);
        
//             // Query the wallets table
//             $walletStmt = $pdo->prepare('SELECT * FROM wallets WHERE wallet_id = :walletId');
//             $walletStmt->bindParam(':walletId', $wallet);
//             $walletStmt->execute();
//             $walletRow = $walletStmt->fetch(PDO::FETCH_ASSOC);
        
//             // Query the profile table
//             $profileStmt = $pdo->prepare('SELECT * FROM user_profiles WHERE user_id = :userId');
//             $profileStmt->bindParam(':userId', $profile);
//             $profileStmt->execute();
//             $profileRow = $profileStmt->fetch(PDO::FETCH_ASSOC);
        
//             // Check if the rows were retrieved
//             if ($userRow && $walletRow && $profileRow) {
//                 // Continue with your business logic using these variables
//             } else {
//                 // Handle the situation if any rows were not retrieved
//             }
        
//         } catch(PDOException $e) {
//             // Handle the situation if there is an error while connecting or querying the database
//             echo 'Error: ' . $e->getMessage();
//         }


//         //////////////////////////  








//         
//         $phone_number = filter_var($_POST['phone_number'], FILTER_SANITIZE_NUMBER_INT);

//         // Validate and sanitize amount input
//         if (empty($_POST['amount']) || !filter_var($_POST['amount'], FILTER_VALIDATE_INT)) {
//             $error = 'Please enter a valid amount.';
//             header('Location: ../dashboard.php?error=' . urlencode($error));
//             exit;
//         }
//         $amount = filter_var($_POST['amount'], FILTER_SANITIZE_NUMBER_INT);
        
        
//         if ($profileRow['is_email_verified'] == true && $profileRow['is_kyc_verified'] == true) {
//             // Check if the balance is sufficient
//             if ($walletRow['balance'] >= $amount) {
//                 // Function call to PaymentReference
//                 try {
//                     $paymentReference = generatePaymentReference();
        
//                     sendRequest($client, $network, $phone_number, $amount, $paymentReference);
        
//                     // Output the generated payment reference
//                     echo $paymentReference;
        
//                 } catch (Exception $e) {
//                     // Display the error message if something goes wrong
//                     echo $e->getMessage();
//                 }
        
//             } else {
//                 // The user's wallet balance is insufficient
//                 $error = 'Insufficient balance in your wallet.';
//                 header('Location: ../dashboard.php?error=' . urlencode($error));
//                 exit;
//             }
//         } else {
//             // If the user's email is not verified or KYC is not verified
//             $error = 'Please ensure your email is verified and you have completed KYC verification.';
//             header('Location: ../dashboard.php?error=' . urlencode($error));
//             exit;
//         }


//         // If no errors, redirect to dashboard with success message
//         $success = 'Airtime purchase successful';
//         header('Location: ../dashboard.php?success=' . urlencode($success));
//         exit;
//     }
// }






//Check if the buy airtime button was clicked

if(isset($_POST['buy-airtime'])) {

    //print out the sent datas 
   

    //CHECK IF THE FIELDS ARE NOT EMPTY

    if (empty($_POST['network'])) {
            $error = 'Please select a network provider.';
            header('Location: ../dashboard?error=' . urlencode($error));
            exit;
         }



    if (empty($_POST['phone_number']) || !preg_match('/^[0-9]{11}$/', $_POST['phone_number'])) {
        $error = 'Please enter a valid 11-digit phone number.';
        header('Location: ../dashboard?error=' . urlencode($error));
        exit;
    }

    if (empty($_POST['amount']) || !filter_var($_POST['amount'], FILTER_VALIDATE_INT)) {
        $error = 'Please enter a valid amount.';
        header('Location: ../dashboard?error=' . urlencode($error));
        exit;
    }


//FILTER THE USER ENTERED DETAILS TO MAKE SURE IT IS CORRECT
    $randomString = generateRandomString();
    $phone_number = filter_var($_POST['phone_number'], FILTER_SANITIZE_NUMBER_INT);
    $amount = filter_var($_POST['amount'], FILTER_SANITIZE_NUMBER_INT);
    $network = filter_input(INPUT_POST, 'network', FILTER_SANITIZE_SPECIAL_CHARS);
    $user = filter_input(INPUT_POST, 'user', FILTER_SANITIZE_SPECIAL_CHARS);
    $wallet = filter_input(INPUT_POST, 'wallet', FILTER_SANITIZE_SPECIAL_CHARS);
    $profile = filter_input(INPUT_POST, 'profile', FILTER_SANITIZE_SPECIAL_CHARS);
    $paymentReference = $formattedTime . $randomString;
    
// CHECK IF USER IS VALIDATED 


    try {
    //Call the database connection
        require_once '../config/database.php';
    // Query the users table
        $userStmt = $pdo->prepare('SELECT * FROM users WHERE user_id = :userId');
        $userStmt->bindParam(':userId', $user);
        $userStmt->execute();
        $userRow = $userStmt->fetch(PDO::FETCH_ASSOC);
        
    // Query the wallets table
        $walletStmt = $pdo->prepare('SELECT * FROM wallets WHERE wallet_id = :walletId');
        $walletStmt->bindParam(':walletId', $wallet);
        $walletStmt->execute();
        $walletRow = $walletStmt->fetch(PDO::FETCH_ASSOC);
        
    // Query the profile table
        $profileStmt = $pdo->prepare('SELECT * FROM user_profiles WHERE user_id = :userId');
        $profileStmt->bindParam(':userId', $profile);
        $profileStmt->execute();
        $profileRow = $profileStmt->fetch(PDO::FETCH_ASSOC);

    // Prepare and execute the SQL query
        $sql = "
            SELECT SUM(
                    CASE transaction_type
                        WHEN 'Bill payment' THEN transaction_amount
                        WHEN 'Transfer' THEN transaction_amount
                        WHEN 'Withdraw' THEN transaction_amount
                        ELSE 0
                    END
                ) as total_amount
            FROM transactions
            WHERE user_id = :user_id
            AND (transaction_type = 'Bill payment'
                    OR transaction_type = 'Transfer'
                    OR transaction_type = 'Withdraw')
        ";

        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':user_id', $userRow['user_id'], PDO::PARAM_INT);
        $stmt->execute();
        $transactionsTotal = $stmt->fetch(PDO::FETCH_ASSOC);

        // Get the total success deposits
        $sql = "SELECT SUM(deposit_amount) as total_success_deposit FROM deposits WHERE deposit_status = 'approved' AND user_id = :user_id";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':user_id', $userRow['user_id'], PDO::PARAM_INT);
        $stmt->execute();
        $depositsResult = $stmt->fetch(PDO::FETCH_ASSOC);

        // Compare the wallet balance with the total success deposits - total transaction amounts
        $totalSuccessDeposits = $depositsResult['total_success_deposit'];
        $totalAmount = $transactionsTotal['total_amount'];
            //REACTIVATE THIS WHEN IT IS SET
        // if ($walletRow['balance'] != $totalSuccessDeposits - $totalAmount) {
        //     // Redirect with the error message
        //     $errorMessage = 'Mismatch Between Balance And Total Amount. Total Deposits: ' . number_format($totalSuccessDeposits, 2, '.',',') . ', Total Tranx Amount: ' . number_format($totalAmount, 2, '.', ',') . ', Wallet Balance: ' . number_format( $walletRow['balance'], 2, '.', ',');

        //     header('Location: ../dashboard?error=' . urlencode($errorMessage));
        //     exit;
        // }

            $discount = '';

            if($network === 'mtn') {
                $discount = 0.5;
            } else if ($network === 'glo') {
                $discount = 2;
            } else if($network === 'airtel') {
                $discount = 2.3;
            } else if ($network === 'etisalat') {
                $discount = 3;
            } else {
                $discount = 0;
            }

            $discountedPrice = $amount - (($discount / 100) * $amount);

    // Check if the rows were retrieved
        if ($userRow && $walletRow && $profileRow) {
            //CHECK IF THE USER WALLET BALANCE IS GREATER THAN OR EQUAL TO THE TOTAL BALANCE
            if ($walletRow['balance'] >= $amount) {
                
                    //VTPass Integration
                    $apiUrl = "https://sandbox.vtpass.com/api/pay";
                    $data = array(
                        "request_id" => $paymentReference,
                        "serviceID" => $network,
                        "amount" => $amount,
                        "phone" => $phone_number
                    );
            
                    //Setup cURL Config
                    $ch = curl_init($apiUrl);
                    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
                    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                        "api-key: 3102513ed61158fba8421f5702df0f73",
                        "secret-key: SK_320fee7b00786294796d39a675a510770b257f51c5d",
                        "Content-Type: application/json"
                    ));
                    $response = curl_exec($ch);
                    
            
                    if ($response === false) {
                        die("cURL error: " . curl_error($ch));
                    }
            
                    $httpStatusCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            
                    if ($httpStatusCode !== 200) {
                        $error = "Error: Unexpected HTTP status code: " . $httpStatusCode;
                        header('Location: ../dashboard?error=' . urlencode($error));
                        exit();
                    } else {
                        try {
                            // Subtract the product cost from the wallet balance
                            $productCost = (float) $amount;
                            $updatedBalance = $walletRow["balance"] - $discountedPrice;

                            // Prepare and execute theSQL query
                            $stmt = $pdo->prepare("UPDATE wallets SET balance = balance - :amount WHERE wallet_id = :wallet_id");
                            $stmt->bindParam(':amount', $discountedPrice, PDO::PARAM_INT);
                            $stmt->bindParam(':wallet_id', $wallet, PDO::PARAM_INT);
                            $stmt->execute();
                    
                            if ($stmt->rowCount() > 0) {
                               
                            } else {
                                // Wallet ID not found in the table
                                $error = "Error: Could not find the specified wallet.";
                                header('Location: ../dashboard?error=' . urlencode($error));
                                exit;
                            }
                        } catch (PDOException $e) {
                            // Handle the exception
                            $error = "Error: " . $e->getMessage();
                            header('Location: ../dashboard?error=' . urlencode($error));
                            exit;
                        }
                    }
            
                    $result = json_decode($response);
            
                    if ($result === null && json_last_error() !== JSON_ERROR_NONE) {
                        $error = "Error: Invalid JSON response from the API";
                        header('Location: ../dashboard?error=' . urlencode($error));
                        exit();
                    } else if (isset($result->content->response_description) && $result->content->response_description) {
                        $error = "Error: " . $result->content->response_description;
                        header('Location: ../dashboard?error=' . urlencode($error));
                        exit();
                    }
            
                    // Process the successful request
                    //print_r($result);


                // Prepare the SQL statement
                    $sql = "INSERT INTO bill_payments (payment_id, user_id, service_type, product_name, biller_code, payment_amount, payment_status, total_amount, payment_reference)
                    VALUES (:payment_id, :user_id, :service_type, :product_name, :biller_code, :payment_amount, :payment_status, :total_amount, :payment_reference)";
                    $stmt = $pdo->prepare($sql);

                    // Define all the needed variables
                    $payment_id = $result->requestId;
                    $user_id = $user;
                    $service_type = $result->content->transactions->type;
                    $product_name = $result->content->transactions->product_name;
                    $biller_code = $result->content->transactions->unique_element;
                    $payment_amount = $result->content->transactions->unit_price;
                    $payment_status = $result->content->transactions->status;
                    $total_amount = $result->content->transactions->total_amount;
                    $payment_ref = $result->content->transactions->transactionId;

                    // Bind all the values
                    $stmt->bindValue(':payment_id', $payment_id);
                    $stmt->bindValue(':user_id', $user_id);
                    $stmt->bindValue(':service_type', $service_type);
                    $stmt->bindValue(':product_name', $product_name);
                    $stmt->bindValue(':biller_code', $biller_code);
                    $stmt->bindValue(':payment_amount', $payment_amount);
                    $stmt->bindValue(':payment_status', $payment_status);
                    $stmt->bindValue(':total_amount', $total_amount);
                    $stmt->bindValue(':payment_reference', $payment_ref);

                    // Execute the SQL
                    try {
                    $stmt->execute();

                    if ($stmt->rowCount() > 0) {
                        
                    // Insertion successful
                                // Prepare the SQL statement
                                $sql = "INSERT INTO transactions (user_id, transaction_type, transaction_status, transaction_reference, transaction_amount, transaction_total_amount, transaction_description, transaction_notes, user_paid, profit)
                                VALUES (:user_id, :transaction_type, :transaction_status, :transaction_reference, :transaction_amount, :transaction_total_amount, :transaction_description, :transaction_note, :discountedPrice, :profit)";
                                $stmt = $pdo->prepare($sql);

                                // Define all the needed variables
                                $user_id = $user;
                                $transaction_type = 'Bill payment';
                                $transaction_status = $payment_status;
                                $transaction_reference = $payment_id;
                                $transaction_amount = $payment_amount;
                                $transaction_total_amount = $total_amount;
                                $transaction_description = $product_name;
                                $transaction_note = $service_type;

                                $profit = $discountedPrice - $transaction_total_amount;

                                // Bind all the values
                                $stmt->bindValue(':user_id', $user_id);
                                $stmt->bindValue(':transaction_type', $transaction_type);
                                $stmt->bindValue(':transaction_status', $transaction_status);
                                $stmt->bindValue(':transaction_reference', $transaction_reference);
                                $stmt->bindValue(':transaction_amount', $transaction_amount);
                                $stmt->bindValue(':transaction_total_amount', $transaction_total_amount);
                                $stmt->bindValue(':transaction_description', $transaction_description);
                                $stmt->bindValue(':transaction_note', $transaction_note);
                                $stmt->bindValue(':discountedPrice', $discountedPrice);
                                $stmt->bindValue(':profit', $profit);

                                // Execute the SQL
                                try {
                                $stmt->execute();

                                if ($stmt->rowCount() > 0) {
                                // Insertion successful
                                $success = "Transaction has been recorded successfully.";
                                // Redirect to the dashboard, or display success message depending on your app
                                header('Location: ../dashboard?message=' . urlencode($success));
                                exit;
                                } else {
                                // Failed to insert
                                $error = "Error: Transaction recording failed.";
                                header('Location: ../dashboard?error=' . urlencode($error));
                                exit;
                                }
                                } catch (PDOException $e) {
                                // Handle the exception
                                $error = "Error: " . $e->getMessage();
                                header('Location: ../dashboard?error=' . urlencode($error));
                                exit;
                                }








                    
                    header('Location: ../dashboard?message=' . urlencode($success));
                    exit;
                    } else {
                    // Failed to insert
                    $error = "Error: Payment recording failed.";
                    header('Location: ../dashboard?error=' . urlencode($error));
                    exit;
                    }
                    } catch (PDOException $e) {
                    // Handle the exception
                    $error = "Error: " . $e->getMessage();
                    header('Location: ../dashboard?error=' . urlencode($error));
                    exit;
                    }
                    

                    

         
        } else {
        // The user's wallet balance is insufficient
            $error = 'Insufficient balance in your wallet.';
            header('Location: ../dashboard?error=' . urlencode($error));
            exit;
        }









        } else {
                // Handle the situation if any rows were not retrieved
            $error = 'Oops an error occured, Please try again.';
            header('Location: ../dashboard?error=' . urlencode($error));
            exit;
        }
        
        } catch(PDOException $e) {
            // Handle the situation if there is an error while connecting or querying the database
            echo 'Error: ' . $e->getMessage();
        }




}



//----------------------------------------------------------------
//FUNCTION TO PROCESS THE BUYING OF DATA BUNDLE

if(isset($_POST['buy-data'])) {

    //print_r($_POST);
//CHECK IF THE FIELDS ARE NOT EMPTY

    if (empty($_POST['data_network'])) {
        $error = 'Please select a network provider.';
        header('Location: ../dashboard?error=' . urlencode($error));
        exit;
    }

    if (empty($_POST['data-plans'])) {
        $error = 'Please select a network provider.';
        header('Location: ../dashboard?error=' . urlencode($error));
        exit;
    }




    if (empty($_POST['phone_number']) || !preg_match('/^[0-9]{11}$/', $_POST['phone_number'])) {
        $error = 'Please enter a valid 11-digit phone number.';
        header('Location: ../dashboard?error=' . urlencode($error));
        exit;
    }

    //FILTER THE USER ENTERED DETAILS TO MAKE SURE IT IS CORRECT
    $randomString = generateRandomString();
    $phone_number = filter_var($_POST['phone_number'], FILTER_SANITIZE_NUMBER_INT);

    //$amount = filter_var($_POST['amount'], FILTER_SANITIZE_NUMBER_INT);
    $network = filter_input(INPUT_POST, 'data_network', FILTER_SANITIZE_SPECIAL_CHARS);
    $dataPlan = filter_input(INPUT_POST, 'data-plans', FILTER_SANITIZE_SPECIAL_CHARS);
    $user = filter_input(INPUT_POST, 'user', FILTER_SANITIZE_SPECIAL_CHARS);
    $wallet = filter_input(INPUT_POST, 'wallet', FILTER_SANITIZE_SPECIAL_CHARS);
    $profile = filter_input(INPUT_POST, 'profile', FILTER_SANITIZE_SPECIAL_CHARS);
    $paymentReference = $formattedTime . $randomString;



    // Database connection
    require_once '../config/database.php';

    try {
        // Connect to the database
        // $pdo = new PDO("mysql:host=$hostname;dbname=$dbname", $username, $password);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        // Query the users table
        $userStmt = $pdo->prepare('SELECT * FROM users WHERE user_id = :userId');
        $userStmt->bindParam(':userId', $user);
        $userStmt->execute();
        $userRow = $userStmt->fetch(PDO::FETCH_ASSOC);

        // Query the wallets table
        $walletStmt = $pdo->prepare('SELECT * FROM wallets WHERE wallet_id = :walletId');
        $walletStmt->bindParam(':walletId', $wallet);
        $walletStmt->execute();
        $walletRow = $walletStmt->fetch(PDO::FETCH_ASSOC);

        // Query the profile table
        $profileStmt = $pdo->prepare('SELECT * FROM user_profiles WHERE user_id = :userId');
        $profileStmt->bindParam(':userId', $profile);
        $profileStmt->execute();
        $profileRow = $profileStmt->fetch(PDO::FETCH_ASSOC);

        // Query the product table
        $productStmt = $pdo->prepare('SELECT * FROM products WHERE product_code = :productCode');
        $productStmt->bindParam(':productCode', $dataPlan);
        $productStmt->execute();
        $productRow = $productStmt->fetch(PDO::FETCH_ASSOC);
        //print_r($productRow);

        $amount = $productRow['cost_price'];
        // Prepare and execute the SQL query
        $sql = "
            SELECT SUM(
                    CASE transaction_type
                        WHEN 'Bill payment' THEN transaction_amount
                        WHEN 'Transfer' THEN transaction_amount
                        WHEN 'Withdraw' THEN transaction_amount
                        ELSE 0
                    END
                ) as total_amount
            FROM transactions
            WHERE user_id = :user_id
            AND (transaction_type = 'Bill payment'
                    OR transaction_type = 'Transfer'
                    OR transaction_type = 'Withdraw')
        ";

        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':user_id', $userRow['user_id'], PDO::PARAM_INT);
        $stmt->execute();
        $transactionsTotal = $stmt->fetch(PDO::FETCH_ASSOC);

        // Get the total success deposits
        $sql = "SELECT SUM(deposit_amount) as total_success_deposit FROM deposits WHERE deposit_status = 'approved' AND user_id = :user_id";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':user_id', $userRow['user_id'], PDO::PARAM_INT);
        $stmt->execute();
        $depositsResult = $stmt->fetch(PDO::FETCH_ASSOC);

        // Compare the wallet balance with the total success deposits - total transaction amounts
        $totalSuccessDeposits = $depositsResult['total_success_deposit'];
        $totalAmount = $transactionsTotal['total_amount'];
            //REACTIVATE THIS WHEN IT IS SET
            // if ($walletRow['balance'] != $totalSuccessDeposits - $totalAmount) {
            //     // Redirect with the error message
            //     $errorMessage = 'Mismatch Between Balance And Total Amount. Total Deposits: ' . number_format($totalSuccessDeposits, 2, '.',',') . ', Total Tranx Amount: ' . number_format($totalAmount, 2, '.', ',') . ', Wallet Balance: ' . number_format( $walletRow['balance'], 2, '.', ',');
    
            //     header('Location: ../dashboard?error=' . urlencode($errorMessage));
            //     exit;
            // }


        $discount = '';

            if($network === 'mtn-data') {
                $discount = 2.5;
            } else if ($network === 'glo-data') {
                $discount = 2;
            } else if($network === 'airtel-data') {
                $discount = 2.3;
            } else if ($network === 'etisalat-data') {
                $discount = 3;
            } else {
                $discount = 0;
            }

            $discountedPrice = $amount - (($discount / 100) * $amount);
      

         // Check if all rows exist
        if (!$userRow || !$walletRow || !$profileRow || !$productRow) {
            // Redirect to ../data.php with an error
            $errorMessage = 'Error: User, wallet, profile, or product data missing.';
            header("Location: ../data?err=$errorMessage");
            exit();
        }

        // Check if the wallet balance is greater than or equal to the product cost
        if ($walletRow["balance"] < $productRow["cost_price"]) {
            $errorMessage = 'Error: Insufficient balance to fulfill the request.';
            header("Location: ../data?error=$errorMessage");
            exit();
        }

         // Subtract the product cost from the wallet balance
        $productCost = (float) $productRow["cost_price"];
        $updatedBalance = $walletRow["balance"] - $discountedPrice;

        // // Prepare and execute the balance update query
        // $updateBalanceStmt = $pdo->prepare('UPDATE wallets SET balance = :newBalance WHERE wallet_id = :walletId');
        // $updateBalanceStmt->bindParam(':newBalance', $updatedBalance, PDO::PARAM_INT);
        // $updateBalanceStmt->bindParam(':walletId', $wallet, PDO::PARAM_INT);
        // $updateBalanceStmt->execute();

                 //VTPass Integration
                 $apiUrl = "https://sandbox.vtpass.com/api/pay";
                 $data = array(
                     "request_id" => $paymentReference,
                     "serviceID" => $network,
                     "billersCode" => $phone_number,
                     "variation_code" => $dataPlan,
                     "amount" => $productRow['cost_price'],
                     "phone" => $phone_number
                 );
         
                 //Setup cURL Config
                 $ch = curl_init($apiUrl);
                 curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
                 curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
                 curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                 curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                     "api-key: 3102513ed61158fba8421f5702df0f73",
                     "secret-key: SK_320fee7b00786294796d39a675a510770b257f51c5d",
                     "Content-Type: application/json"
                 ));
                 $response = curl_exec($ch);
                 
         
                 if ($response === false) {
                     die("cURL error: " . curl_error($ch));
                 }
         
                 $httpStatusCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
         
                 if ($httpStatusCode !== 200) {
                    $error = "Error: Unexpected HTTP status code: " . $httpStatusCode;
                    header('Location: ../dashboard?error=' . urlencode($error));
                    exit();
                } else {
                    try {
                        // Prepare and execute theSQL query
                        $stmt = $pdo->prepare("UPDATE wallets SET balance = balance - :amount WHERE wallet_id = :wallet_id");
                        $stmt->bindParam(':amount', $discountedPrice, PDO::PARAM_INT);
                        $stmt->bindParam(':wallet_id', $wallet, PDO::PARAM_INT);
                        $stmt->execute();
                
                        if ($stmt->rowCount() > 0) {
                           
                        } else {
                            // Wallet ID not found in the table
                            $error = "Error: Could not find the specified wallet.";
                            header('Location: ../dashboard?error=' . urlencode($error));
                            exit;
                        }
                    } catch (PDOException $e) {
                        // Handle the exception
                        $error = "Error: " . $e->getMessage();
                        header('Location: ../dashboard?error=' . urlencode($error));
                        exit;
                    }
                }
         
                 $result = json_decode($response);
                 if ($result === null && json_last_error() !== JSON_ERROR_NONE) {
                    $error = "Error: Invalid JSON response from the API";
                    header('Location: ../data?error=' . urlencode($error));
                    exit();
                } else if (isset($result->content->response_description) && $result->content->response_description) {
                    $error = "Error: " . $result->content->response_description;
                    header('Location: ../data?error=' . urlencode($error));
                    exit();
                }
        
                // Process the successful request
                //print_r($result);


            // Prepare the SQL statement
                $sql = "INSERT INTO bill_payments (payment_id, user_id, service_type, product_name, biller_code, payment_amount, payment_status, total_amount, payment_reference)
                VALUES (:payment_id, :user_id, :service_type, :product_name, :biller_code, :payment_amount, :payment_status, :total_amount, :payment_reference)";
                $stmt = $pdo->prepare($sql);

                // Define all the needed variables
                $payment_id = $paymentReference;
                $user_id = $user;
                $service_type = $result->content->transactions->type;
                $product_name = $result->content->transactions->product_name;
                $biller_code = $result->content->transactions->unique_element;
                $payment_amount = $result->content->transactions->unit_price;
                $payment_status = $result->content->transactions->status;
                $total_amount = $result->content->transactions->total_amount;
                $payment_ref = $result->content->transactions->transactionId;

                // Bind all the values
                $stmt->bindValue(':payment_id', $payment_id);
                $stmt->bindValue(':user_id', $user_id);
                $stmt->bindValue(':service_type', $service_type);
                $stmt->bindValue(':product_name', $product_name);
                $stmt->bindValue(':biller_code', $biller_code);
                $stmt->bindValue(':payment_amount', $payment_amount);
                $stmt->bindValue(':payment_status', $payment_status);
                $stmt->bindValue(':total_amount', $total_amount);
                $stmt->bindValue(':payment_reference', $payment_ref);

                // Execute the SQL
                try {
                $stmt->execute();

                if ($stmt->rowCount() > 0) {
                // Insertion successful
                            // Prepare the SQL statement
                            $sql = "INSERT INTO transactions (user_id, transaction_type, transaction_status, transaction_reference, transaction_amount, transaction_total_amount, transaction_description, transaction_notes, user_paid, profit)
                            VALUES (:user_id, :transaction_type, :transaction_status, :transaction_reference, :transaction_amount, :transaction_total_amount, :transaction_description, :transaction_note, :discountedPrice, :profit)";
                            $stmt = $pdo->prepare($sql);

                            // Define all the needed variables
                            $user_id = $user;
                            $transaction_type = 'Bill payment';
                            $transaction_status = $payment_status;
                            $transaction_reference = $payment_id;
                            $transaction_amount = $payment_amount;
                            $transaction_total_amount = $total_amount;
                            $transaction_description = $product_name;
                            $transaction_note = $service_type;
                            $profit = $discountedPrice - $transaction_total_amount;

                            // Bind all the values
                            $stmt->bindValue(':user_id', $user_id);
                            $stmt->bindValue(':transaction_type', $transaction_type);
                            $stmt->bindValue(':transaction_status', $transaction_status);
                            $stmt->bindValue(':transaction_reference', $transaction_reference);
                            $stmt->bindValue(':transaction_amount', $transaction_amount);
                            $stmt->bindValue(':transaction_total_amount', $transaction_total_amount);
                            $stmt->bindValue(':transaction_description', $transaction_description);
                            $stmt->bindValue(':transaction_note', $transaction_note);
                            $stmt->bindValue(':discountedPrice', $discountedPrice);
                            $stmt->bindValue(':profit', $profit);


                            // Execute the SQL
                            try {
                            $stmt->execute();

                            if ($stmt->rowCount() > 0) {
                            // Insertion successful
                            $success = "Transaction has been recorded successfully.";
                            // Redirect to the dashboard, or display success message depending on your app
                            header('Location: ../dashboard?message=' . urlencode($success));
                            exit;
                            } else {
                            // Failed to insert
                            $error = "Error: Transaction recording failed.";
                            header('Location: ../dashboard?error=' . urlencode($error));
                            exit;
                            }
                            } catch (PDOException $e) {
                            // Handle the exception
                            $error = "Error: " . $e->getMessage();
                            header('Location: ../dashboard?error=' . urlencode($error));
                            exit;
                            }








                
                header('Location: ../dashboard?message=' . urlencode($success));
                exit;
                } else {
                // Failed to insert
                $error = "Error: Payment recording failed.";
                header('Location: ../dashboard?error=' . urlencode($error));
                exit;
                }
                } catch (PDOException $e) {
                // Handle the exception
                $error = "Error: " . $e->getMessage();
                header('Location: ../dashboard?error=' . urlencode($error));
                exit;
                }
                

                



        


        //print_r(number_format(intval($productRow['cost_price']), 2, '.', ','));


    } catch (PDOException $e) {
        // Handle exceptions
        $errorMessage = 'Error: ' . $e->getMessage();
        header("Location: ../data?err=$errorMessage");
    }
    
}
//------------------------------------------------------------------------------------------------
//Code to process buying of airtime

if(isset($_POST['subscribe'])) {
    print_r($_POST);
    if (empty($_POST['service'])) {
        $error = 'Please select a service provider.';
        header('Location: ../cable-tv?error=' . urlencode($error));
        exit;
    }

    if (empty($_POST['product_select'])) {
        $error = 'Please select a subscription plan provider.';
        header('Location: ../cable-tv?error=' . urlencode($error));
        exit;
    }




    if (empty($_POST['smartcard']) || !preg_match('/^[0-9]{12}$/', $_POST['smartcard'])) {
        $error = 'Please enter a valid 11-digit smartcard number.';
        header('Location: ../cable-tv?error=' . urlencode($error));
        exit;
    }

    $randomString = generateRandomString();
    $smartcard = filter_var($_POST['smartcard'], FILTER_SANITIZE_NUMBER_INT);
    //$amount = filter_var($_POST['amount'], FILTER_SANITIZE_NUMBER_INT);
    $service = filter_input(INPUT_POST, 'service', FILTER_SANITIZE_SPECIAL_CHARS);
    $cablePlan = filter_input(INPUT_POST, 'product_select', FILTER_SANITIZE_SPECIAL_CHARS);
    $user = filter_input(INPUT_POST, 'user', FILTER_SANITIZE_SPECIAL_CHARS);
    $wallet = filter_input(INPUT_POST, 'wallet', FILTER_SANITIZE_SPECIAL_CHARS);
    $profile = filter_input(INPUT_POST, 'profile', FILTER_SANITIZE_SPECIAL_CHARS);
    $paymentReference = $formattedTime . $randomString;

// Database connection
require_once '../config/database.php';

try {
    // Connect to the database
    // $pdo = new PDO("mysql:host=$hostname;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Query the users table
    $userStmt = $pdo->prepare('SELECT * FROM users WHERE user_id = :userId');
    $userStmt->bindParam(':userId', $user);
    $userStmt->execute();
    $userRow = $userStmt->fetch(PDO::FETCH_ASSOC);

    // Query the wallets table
    $walletStmt = $pdo->prepare('SELECT * FROM wallets WHERE wallet_id = :walletId');
    $walletStmt->bindParam(':walletId', $wallet);
    $walletStmt->execute();
    $walletRow = $walletStmt->fetch(PDO::FETCH_ASSOC);

    // Query the profile table
    $profileStmt = $pdo->prepare('SELECT * FROM user_profiles WHERE user_id = :userId');
    $profileStmt->bindParam(':userId', $profile);
    $profileStmt->execute();
    $profileRow = $profileStmt->fetch(PDO::FETCH_ASSOC);

    // Query the product table
    $productStmt = $pdo->prepare('SELECT * FROM products WHERE product_code = :productCode');
    $productStmt->bindParam(':productCode', $cablePlan);
    $productStmt->execute();
    $productRow = $productStmt->fetch(PDO::FETCH_ASSOC);
    $amount = $productRow['cost_price'];

    // Prepare and execute the SQL query

    $sql = "
            SELECT SUM(
                    CASE transaction_type
                        WHEN 'Bill payment' THEN transaction_amount
                        WHEN 'Transfer' THEN transaction_amount
                        WHEN 'Withdraw' THEN transaction_amount
                        ELSE 0
                    END
                ) as total_amount
            FROM transactions
            WHERE user_id = :user_id
            AND (transaction_type = 'Bill payment'
                    OR transaction_type = 'Transfer'
                    OR transaction_type = 'Withdraw')
        ";


        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':user_id', $userRow['user_id'], PDO::PARAM_INT);
        $stmt->execute();
        $transactionsTotal = $stmt->fetch(PDO::FETCH_ASSOC);

        // Get the total success deposits
        $sql = "SELECT SUM(deposit_amount) as total_success_deposit FROM deposits WHERE deposit_status = 'approved' AND user_id = :user_id";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':user_id', $userRow['user_id'], PDO::PARAM_INT);
        $stmt->execute();
        $depositsResult = $stmt->fetch(PDO::FETCH_ASSOC);

        // Compare the wallet balance with the total success deposits - total transaction amounts
        $totalSuccessDeposits = $depositsResult['total_success_deposit'];
        $totalAmount = $transactionsTotal['total_amount'];
            //REACTIVATE THIS WHEN IT IS SET
            if ($walletRow['balance'] != $totalSuccessDeposits - $totalAmount) {
                // Redirect with the error message
                $errorMessage = 'Mismatch Between Balance And Total Amount. Total Deposits: ' . number_format($totalSuccessDeposits, 2, '.',',') . ', Total Tranx Amount: ' . number_format($totalAmount, 2, '.', ',') . ', Wallet Balance: ' . number_format( $walletRow['balance'], 2, '.', ',');
    
                header('Location: ../dashboard?error=' . urlencode($errorMessage));
                exit;
            }

        $discount = '';

            if($service === 'dstv') {
                $discount = 2.5;
            } else if ($service === 'gotv') {
                $discount = 2;
            } else if($service === 'startimes') {
                $discount = 2.3;
            } else {
                $discount = 0;
            }

            $discountedPrice = $amount - (($discount / 100) * $amount);







     // Check if all rows exist
    if (!$userRow || !$walletRow || !$profileRow || !$productRow) {
        // Redirect to ../data with an error
        $errorMessage = 'Error: User, wallet, profile, or product data missing.';
        header("Location: ../data?err=$errorMessage");
        exit();
    }





    // Check if the wallet balance is greater than or equal to the product cost
    if ($walletRow["balance"] < $productRow["cost_price"]) {
        $errorMessage = 'Error: Insufficient balance to fulfill the request.';
        header("Location: ../data?error=$errorMessage");
        exit();
    }

    
  
       
            
             //VTPass Integration
             $apiUrl = "https://sandbox.vtpass.com/api/pay";
             $data = array(
                 "request_id" => $paymentReference,
                 "serviceID" => $service,
                 "billersCode" => $smartcard,
                 "variation_code" => $cablePlan,
                 "amount" => $productRow['cost_price'],
                 "phone" => $profileRow['user_phone_number'],
                 "subscription_type" => "change"
             );
     
             //Setup cURL Config
             $ch = curl_init($apiUrl);
             curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
             curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
             curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
             curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                 "api-key: 3102513ed61158fba8421f5702df0f73",
                 "secret-key: SK_320fee7b00786294796d39a675a510770b257f51c5d",
                 "Content-Type: application/json"
             ));
             $response = curl_exec($ch);
             
     
             if ($response === false) {
                 die("cURL error: " . curl_error($ch));
             }
     
             $httpStatusCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
     
             if ($httpStatusCode !== 200) {
                $error = "Error: Unexpected HTTP status code: " . $httpStatusCode;
                header('Location: ../dashboard?error=' . urlencode($error));
                exit();
            } else {
                try {
                    // Subtract the product cost from the wallet balance
                        $productCost = (float) $amount;
                        $updatedBalance = $walletRow["balance"] - $discountedPrice;

                    // Prepare and execute theSQL query
                    $stmt = $pdo->prepare("UPDATE wallets SET balance = balance - :amount WHERE wallet_id = :wallet_id");
                    $stmt->bindParam(':amount', $discountedPrice, PDO::PARAM_INT);
                    $stmt->bindParam(':wallet_id', $wallet, PDO::PARAM_INT);
                    $stmt->execute();
            
                    if ($stmt->rowCount() > 0) {
                       
                    } else {
                        // Wallet ID not found in the table
                        $error = "Error: Could not find the specified wallet.";
                        header('Location: ../dashboard?error=' . urlencode($error));
                        exit;
                    }
                } catch (PDOException $e) {
                    // Handle the exception
                    $error = "Error: " . $e->getMessage();
                    header('Location: ../dashboard?error=' . urlencode($error));
                    exit;
                }
            }
     
             $result = json_decode($response);
             if ($result === null && json_last_error() !== JSON_ERROR_NONE) {
                $error = "Error: Invalid JSON response from the API";
                header('Location: ../cable-tv?error=' . urlencode($error));
                exit();
            } else if (isset($result->content->response_description) && $result->content->response_description) {
                $error = "Error: " . $result->content->response_description;
                header('Location: ../cable-tv?error=' . urlencode($error));
                exit();
            }
    
            // Process the successful request
            //print_r($result);


        // Prepare the SQL statement
            $sql = "INSERT INTO bill_payments (payment_id, user_id, service_type, product_name, biller_code, payment_amount, payment_status, total_amount, payment_reference)
            VALUES (:payment_id, :user_id, :service_type, :product_name, :biller_code, :payment_amount, :payment_status, :total_amount, :payment_reference)";
            $stmt = $pdo->prepare($sql);

            // Define all the needed variables
            $payment_id = $result->requestId;
            $user_id = $user;
            $service_type = $result->content->transactions->type;
            $product_name = $result->content->transactions->product_name;
            $biller_code = $result->content->transactions->unique_element;
            $payment_amount = $result->content->transactions->unit_price;
            $payment_status = $result->content->transactions->status;
            $total_amount = $result->content->transactions->total_amount;
            $payment_ref = $result->content->transactions->transactionId;

            // Bind all the values
            $stmt->bindValue(':payment_id', $payment_id);
            $stmt->bindValue(':user_id', $user_id);
            $stmt->bindValue(':service_type', $service_type);
            $stmt->bindValue(':product_name', $product_name);
            $stmt->bindValue(':biller_code', $biller_code);
            $stmt->bindValue(':payment_amount', $payment_amount);
            $stmt->bindValue(':payment_status', $payment_status);
            $stmt->bindValue(':total_amount', $total_amount);
            $stmt->bindValue(':payment_reference', $payment_ref);

            // Execute the SQL
            try {
            $stmt->execute();

            if ($stmt->rowCount() > 0) {
            // Insertion successful
                        // Prepare the SQL statement
                        $sql = "INSERT INTO transactions (user_id, transaction_type, transaction_status, transaction_reference, transaction_amount, transaction_total_amount, transaction_description, transaction_notes, user_paid, profit)
                        VALUES (:user_id, :transaction_type, :transaction_status, :transaction_reference, :transaction_amount, :transaction_total_amount, :transaction_description, :transaction_note, :discountedPrice, :profit)";
                        $stmt = $pdo->prepare($sql);

                        // Define all the needed variables
                        $user_id = $user;
                        $transaction_type = 'Bill payment';
                        $transaction_status = $payment_status;
                        $transaction_reference = $payment_id;
                        $transaction_amount = $payment_amount;
                        $transaction_total_amount = $total_amount;
                        $transaction_description = $product_name;
                        $transaction_note = $service_type;

                        // Bind all the values
                        $stmt->bindValue(':user_id', $user_id);
                        $stmt->bindValue(':transaction_type', $transaction_type);
                        $stmt->bindValue(':transaction_status', $transaction_status);
                        $stmt->bindValue(':transaction_reference', $transaction_reference);
                        $stmt->bindValue(':transaction_amount', $transaction_amount);
                        $stmt->bindValue(':transaction_total_amount', $transaction_total_amount);
                        $stmt->bindValue(':transaction_description', $transaction_description);
                        $stmt->bindValue(':transaction_note', $transaction_note);
                        $stmt->bindValue(':discountedPrice', $discountedPrice);
                        $stmt->bindValue(':profit', $profit);

                        // Execute the SQL
                        try {
                        $stmt->execute();

                        if ($stmt->rowCount() > 0) {
                        // Insertion successful
                        $success = "Transaction has been recorded successfully.";
                        // Redirect to the dashboard, or display success message depending on your app
                        header('Location: ../cable-tv?message=' . urlencode($success));
                        exit;
                        } else {
                        // Failed to insert
                        $error = "Error: Transaction recording failed.";
                        header('Location: ../cable-tv?error=' . urlencode($error));
                        exit;
                        }
                        } catch (PDOException $e) {
                        // Handle the exception
                        $error = "Error: " . $e->getMessage();
                        header('Location: ../cable-tv?error=' . urlencode($error));
                        exit;
                        }








            
            header('Location: ../cable-tv?message=' . urlencode($success));
            exit;
            } else {
            // Failed to insert
            $error = "Error: Payment recording failed.";
            header('Location: ../cable-tv?error=' . urlencode($error));
            exit;
            }
            } catch (PDOException $e) {
            // Handle the exception
            $error = "Error: " . $e->getMessage();
            header('Location: ../cable-tv?error=' . urlencode($error));
            exit;
            }
            

            



   


    //print_r(number_format(intval($productRow['cost_price']), 2, '.', ','));


} catch (PDOException $e) {
    // Handle exceptions
    $errorMessage = 'Error: ' . $e->getMessage();
    header("Location: ../data?err=$errorMessage");
}


} 



if(isset($_POST['process-electric'])) {
    print_r($_POST);
    if (empty($_POST['electric-distributor'])) {
        $error = 'Please select your electric provider.';
        header('Location: ../buy-electric?error=' . urlencode($error));
        exit;
    }

    if (empty($_POST['meter-type'])) {
        $error = 'Please select a meter type.';
        header('Location: ../buy-electric?error=' . urlencode($error));
        exit;
    }




    if (empty($_POST['meter']) || !preg_match('/^[0-9]{13}$/', $_POST['meter'])) {
        $error = 'Please enter a valid 13-digit meter number.';
        header('Location: ../buy-electric?error=' . urlencode($error));
        exit;
    }

    if (empty($_POST['amount'])) {
        $error = 'Please enter the amount to pay.';
        header('Location: ../buy-electric?error=' . urlencode($error));
        exit;
    }


    
    $randomString = generateRandomString();
    $meter = filter_var($_POST['meter'], FILTER_SANITIZE_NUMBER_INT);
    $amount = filter_var($_POST['amount'], FILTER_SANITIZE_NUMBER_INT);
    $service = filter_input(INPUT_POST, 'electric-distributor', FILTER_SANITIZE_SPECIAL_CHARS);
    $meterType = filter_input(INPUT_POST, 'meter-type', FILTER_SANITIZE_SPECIAL_CHARS);
    $user = filter_input(INPUT_POST, 'user', FILTER_SANITIZE_SPECIAL_CHARS);
    $wallet = filter_input(INPUT_POST, 'wallet', FILTER_SANITIZE_SPECIAL_CHARS);
    $profile = filter_input(INPUT_POST, 'profile', FILTER_SANITIZE_SPECIAL_CHARS);
    $paymentReference = $formattedTime . $randomString;

    // Database connection
require_once '../config/database.php';

try {
    // Connect to the database
    // $pdo = new PDO("mysql:host=$hostname;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Query the users table
    $userStmt = $pdo->prepare('SELECT * FROM users WHERE user_id = :userId');
    $userStmt->bindParam(':userId', $user);
    $userStmt->execute();
    $userRow = $userStmt->fetch(PDO::FETCH_ASSOC);

    // Query the wallets table
    $walletStmt = $pdo->prepare('SELECT * FROM wallets WHERE wallet_id = :walletId');
    $walletStmt->bindParam(':walletId', $wallet);
    $walletStmt->execute();
    $walletRow = $walletStmt->fetch(PDO::FETCH_ASSOC);

    // Query the profile table
    $profileStmt = $pdo->prepare('SELECT * FROM user_profiles WHERE user_id = :userId');
    $profileStmt->bindParam(':userId', $profile);
    $profileStmt->execute();
    $profileRow = $profileStmt->fetch(PDO::FETCH_ASSOC);

    // Prepare and execute the SQL query
    $sql = "
        SELECT SUM(
                CASE transaction_type
                    WHEN 'Bill payment' THEN transaction_amount
                    WHEN 'Transfer' THEN transaction_amount
                    WHEN 'Withdraw' THEN transaction_amount
                    ELSE 0
                END
            ) as total_amount
        FROM transactions
        WHERE user_id = :user_id
        AND (transaction_type = 'Bill payment'
            OR transaction_type = 'Transfer'
            OR transaction_type = 'Withdraw')
    ";

    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':user_id', $userRow['user_id'], PDO::PARAM_INT);
    $stmt->execute();
    $transactionsTotal = $stmt->fetch(PDO::FETCH_ASSOC);

    // Get the total success deposits
    $sql = "SELECT SUM(deposit_amount) as total_success_deposit FROM deposits WHERE deposit_status = 'approved' AND user_id = :user_id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':user_id', $userRow['user_id'], PDO::PARAM_INT);
    $stmt->execute();
    $depositsResult = $stmt->fetch(PDO::FETCH_ASSOC);

    // Compare the wallet balance with the total success deposits - total transaction amounts
    $totalSuccessDeposits = $depositsResult['total_success_deposit'];
    $totalAmount = $transactionsTotal['total_amount'];
        //REACTIVATE THIS WHEN IT IS SET
        if ($walletRow['balance'] != $totalSuccessDeposits - $totalAmount) {
            // Redirect with the error message
            $errorMessage = 'Mismatch Between Balance And Total Amount. Total Deposits: ' . number_format($totalSuccessDeposits, 2, '.',',') . ', Total Tranx Amount: ' . number_format($totalAmount, 2, '.', ',') . ', Wallet Balance: ' . number_format( $walletRow['balance'], 2, '.', ',');

            header('Location: ../dashboard?error=' . urlencode($errorMessage));
            exit;
        }

        $discount = '';

            if($network === 'mtn-data') {
                $discount = 2.5;
            } else if ($network === 'glo-data') {
                $discount = 2;
            } else if($network === 'airtel-data') {
                $discount = 2.3;
            } else if ($network === 'etisalat-data') {
                $discount = 3;
            } else {
                $discount = 0;
            }

            $discountedPrice = $amount - (($discount / 100) * $amount);


     // Check if all rows exist
    if (!$userRow || !$walletRow || !$profileRow) {
        // Redirect to ../data with an error
        $errorMessage = 'Error: User, wallet, profile, or missing.';
        header("Location: ../buy-electric?err=$errorMessage");
        exit();
    }

    // Check if the wallet balance is greater than or equal to the product cost
    if ($walletRow["balance"] < $amount) {
        $errorMessage = 'Error: Insufficient balance to fulfill the request.';
        header("Location: ../buy-electric?error=$errorMessage");
        exit();
    }

     


    if ($updateBalanceStmt->execute()) {
       
            
             //VTPass Integration
             $apiUrl = "https://sandbox.vtpass.com/api/pay";
             $data = array(
                 "request_id" => $paymentReference,
                 "serviceID" => $service,
                 "billersCode" => $meter,
                 "variation_code" => $meterType,
                 "amount" => $amount,
                 "phone" => $profileRow['user_phone_number']
             );
     
             //Setup cURL Config
             $ch = curl_init($apiUrl);
             curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
             curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
             curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
             curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                 "api-key: 3102513ed61158fba8421f5702df0f73",
                 "secret-key: SK_320fee7b00786294796d39a675a510770b257f51c5d",
                 "Content-Type: application/json"
             ));
             $response = curl_exec($ch);
             
     
             if ($response === false) {
                 die("cURL error: " . curl_error($ch));
             }
     
             $httpStatusCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
     
             if ($httpStatusCode !== 200) {
                $error = "Error: Unexpected HTTP status code: " . $httpStatusCode;
                header('Location: ../dashboard?error=' . urlencode($error));
                exit();
            } else {
                try {
                    // Subtract the product cost from the wallet balance
                    $productCost = (float) $amount;
                    $updatedBalance = $walletRow["balance"] - $discountedPrice;

                    // Prepare and execute theSQL query
                    $stmt = $pdo->prepare("UPDATE wallets SET balance = balance - :amount WHERE wallet_id = :wallet_id");
                    $stmt->bindParam(':amount', $discountedPrice, PDO::PARAM_INT);
                    $stmt->bindParam(':wallet_id', $wallet, PDO::PARAM_INT);
                    $stmt->execute();
            
                    if ($stmt->rowCount() > 0) {
                       
                    } else {
                        // Wallet ID not found in the table
                        $error = "Error: Could not find the specified wallet.";
                        header('Location: ../dashboard?error=' . urlencode($error));
                        exit;
                    }
                } catch (PDOException $e) {
                    // Handle the exception
                    $error = "Error: " . $e->getMessage();
                    header('Location: ../dashboard?error=' . urlencode($error));
                    exit;
                }
            }
     
             $result = json_decode($response);
             if ($result === null && json_last_error() !== JSON_ERROR_NONE) {
                $error = "Error: Invalid JSON response from the API";
                header('Location: ../buy-electric?error=' . urlencode($error));
                exit();
            } else if (isset($result->content->response_description) && $result->content->response_description) {
                $error = "Error: " . $result->content->response_description;
                header('Location: ../buy-electric?error=' . urlencode($error));
                exit();
            }
    
            // Process the successful request
            //print_r($result);


        // Prepare the SQL statement
            $sql = "INSERT INTO bill_payments (payment_id, user_id, service_type, product_name, biller_code, payment_amount, payment_status, total_amount, payment_reference)
            VALUES (:payment_id, :user_id, :service_type, :product_name, :biller_code, :payment_amount, :payment_status, :total_amount, :payment_reference)";
            $stmt = $pdo->prepare($sql);

            // Define all the needed variables
            $payment_id = $result->requestId;
            $user_id = $user;
            $service_type = $result->content->transactions->type;
            $product_name = $result->content->transactions->product_name;
            $biller_code = $result->content->transactions->unique_element;
            $payment_amount = $result->content->transactions->unit_price;
            $payment_status = $result->content->transactions->status;
            $total_amount = $result->content->transactions->total_amount;
            $payment_ref = $result->content->transactions->transactionId;

            // Bind all the values
            $stmt->bindValue(':payment_id', $payment_id);
            $stmt->bindValue(':user_id', $user_id);
            $stmt->bindValue(':service_type', $service_type);
            $stmt->bindValue(':product_name', $product_name);
            $stmt->bindValue(':biller_code', $biller_code);
            $stmt->bindValue(':payment_amount', $payment_amount);
            $stmt->bindValue(':payment_status', $payment_status);
            $stmt->bindValue(':total_amount', $total_amount);
            $stmt->bindValue(':payment_reference', $payment_ref);

            // Execute the SQL
            try {
            $stmt->execute();

            if ($stmt->rowCount() > 0) {
            // Insertion successful
                        // Prepare the SQL statement
                        $sql = "INSERT INTO transactions (user_id, transaction_type, transaction_status, transaction_reference, transaction_amount, transaction_total_amount, transaction_description, transaction_notes, user_paid, profit)
                        VALUES (:user_id, :transaction_type, :transaction_status, :transaction_reference, :transaction_amount, :transaction_total_amount, :transaction_description, :transaction_note, :discountedPrice, :profit)";
                        $stmt = $pdo->prepare($sql);

                        // Define all the needed variables
                        $user_id = $user;
                        $transaction_type = 'Bill payment';
                        $transaction_status = $payment_status;
                        $transaction_reference = $payment_id;
                        $transaction_amount = $payment_amount;
                        $transaction_total_amount = $total_amount;
                        $transaction_description = $product_name;
                        $transaction_note = $service_type;

                        // Bind all the values
                        $stmt->bindValue(':user_id', $user_id);
                        $stmt->bindValue(':transaction_type', $transaction_type);
                        $stmt->bindValue(':transaction_status', $transaction_status);
                        $stmt->bindValue(':transaction_reference', $transaction_reference);
                        $stmt->bindValue(':transaction_amount', $transaction_amount);
                        $stmt->bindValue(':transaction_total_amount', $transaction_total_amount);
                        $stmt->bindValue(':transaction_description', $transaction_description);
                        $stmt->bindValue(':transaction_note', $transaction_note);
                        $stmt->bindValue(':discountedPrice', $discountedPrice);
                        $stmt->bindValue(':profit', $profit);


                        // Execute the SQL
                        try {
                        $stmt->execute();

                        if ($stmt->rowCount() > 0) {
                        // Insertion successful
                        $success = "Transaction has been recorded successfully.";
                        // Redirect to the dashboard, or display success message depending on your app
                        header('Location: ../buy-electric?message=' . urlencode($success));
                        exit;
                        } else {
                        // Failed to insert
                        $error = "Error: Transaction recording failed.";
                        header('Location: ../buy-electric?error=' . urlencode($error));
                        exit;
                        }
                        } catch (PDOException $e) {
                        // Handle the exception
                        $error = "Error: " . $e->getMessage();
                        header('Location: ../buy-electric?error=' . urlencode($error));
                        exit;
                        }








            
            header('Location: ../buy-electric?message=' . urlencode($success));
            exit;
            } else {
            // Failed to insert
            $error = "Error: Payment recording failed.";
            header('Location: ../buy-electric?error=' . urlencode($error));
            exit;
            }
            } catch (PDOException $e) {
            // Handle the exception
            $error = "Error: " . $e->getMessage();
            header('Location: ../buy-electric?error=' . urlencode($error));
            exit;
            }
            

            



    } else {
        $error = $pdo->errorInfo();
        header("Location: ../buy-electric?error=" . urlencode($error[2]));
        die();
    }


    //print_r(number_format(intval($productRow['cost_price']), 2, '.', ','));


} catch (PDOException $e) {
    // Handle exceptions
    $errorMessage = 'Error: ' . $e->getMessage();
    header("Location: ../buy-electric?err=$errorMessage");
}


} 



