<?php 


function generatePaymentReference($length = 20)
{
    // Generate a random string
    $randomString = '';
    $alphanumericChars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
    while (strlen($randomString) < $length - 8) {
        $randomChar = $alphanumericChars[mt_rand(0, strlen($alphanumericChars) - 1)];
        $randomString .= $randomChar;
    }

    // Generate the date portion of the payment reference
    $date = gmdate('YmdGis', time() + (60 * 60)); // get GMT+1 timestring

    // Combine the date and random string to create the payment reference
    $paymentReference = "$date$randomString";

    // Check if the payment reference is of the required length
    if (strlen($paymentReference) !== $length) {
        throw new Exception('Unable to generate payment reference of the required length.');
    }

    return $paymentReference;
}

//FUNCTION TO GENERATE 5 RANDOM STRING FOR TRANSACTION
function generateRandomString($length = 5) {
    $characters = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    $charactersLength = strlen($characters);
    $randomString = "";
    for ($i= 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, $charactersLength -1)];
    }
    return $randomString;
}

        date_default_timezone_set('Africa/Lagos');
        //Get current time
        $currentTime = new DateTime();
        $formattedTime = $currentTime->format('YmdHi');




//-------------------------------------------------------------------------------------------


if(isset($_POST['subscribe'])) {
    print_r($_POST);
    if (empty($_POST['service'])) {
        $error = 'Please select a service provider.';
        header('Location: ../cable-tv?error=' . urlencode($error));
        exit;
    }

    if (empty($_POST['product_select'])) {
        $error = 'Please select a subscription plan provider.';
        header('Location: ../cable-tv?error=' . urlencode($error));
        exit;
    }




    if (empty($_POST['smartcard']) || !preg_match('/^[0-9]{11}$/', $_POST['smartcard'])) {
        $error = 'Please enter a valid 11-digit smartcard number.';
        header('Location: ../cable-tv?error=' . urlencode($error));
        exit;
    }




} else {
    header('Location : ../cable-tv');
}