<?php

require_once './function.php';
require '../config/database.php';


if(isset($_POST['register'])) {


$referredBy = '';
$referredBy = $_POST['referredBy'];

    // Get the user inputed username
$username = $_POST['username'];

// Get the user inputed email
$email = $_POST['email'];

// Get the user inputed password
$password = $_POST['password'];

// Get the user inputed confirm password
$confirm_password = $_POST['confirm-password'];


// Get the user inputed username
$referredBy = filter_var($_POST['referredBy'], FILTER_SANITIZE_SPECIAL_CHARS);
$username = filter_var($_POST['username'], FILTER_SANITIZE_SPECIAL_CHARS);

// Get the user inputed email
$email = filter_var($_POST['email'], FILTER_SANITIZE_EMAIL);

// Get the user inputed password
$password = $_POST['password'];

// Get the user inputed confirm password
$confirm_password = $_POST['confirm-password'];

// Get the user inputed password
$password = filter_var($_POST['password'], FILTER_SANITIZE_SPECIAL_CHARS);

// Get the user inputed confirm password
$confirm_password = filter_var($_POST['confirm-password'], FILTER_SANITIZE_SPECIAL_CHARS);



// Validate the user input
if (
    // Check if the username is valid
    !validate_username($username)

    // Check if the email is valid
    || !filter_var($email, FILTER_VALIDATE_EMAIL)

    // Check if the password is at least 6 characters
    || strlen($password) < 8

    // Check if the confirm password matches the password
    || $password !== $confirm_password
) {
    // The user input is invalid
    // Store the error message
    $error = 'Please enter a valid username, email, and password';
    // Render the registration form with the error message
    header('Location: ../register?error=' . urlencode($error));
    exit;
}

//----------------------------------------------------------------
//USERNAME VALIDATION
// Check if the username is in the correct format
$username = preg_replace('/[^a-zA-Z0-9]/', '', $username);



// Check if the username is empty
if (empty($username)) {
    // The username is empty
    // Store the error message
    $error = 'Please enter a username';
    // Render the registration form with the error message
    header('Location: ../register?error=' . urlencode($error));
    exit;
}


// Check if the username is at least 3 characters long and not greater than 20 characters
if (strlen($username) < 3 || strlen($username) > 20) {
    // The username is invalid
    // Store the error message
    $error = 'The username must be at least 3 characters and not greater than 20 characters';
    // Render the registration form with the error message
    header('Location: ../register?error=' . urlencode($error));
    exit;
}


// Prepare the SQL statement
$stmt = $pdo->prepare('SELECT * FROM users WHERE username = :username OR email = :email');

// Execute the SQL statement
$stmt->execute([':username' => $username, ':email' => $email]);

// Check if the username or email is already registered
if ($stmt->rowCount() > 0) {
    // The username or email is already registered
    // Store the error message
    $error = 'This username or email is already registered';
    // Render the registration form with the error message
    header('Location: ../register?error=' . urlencode($error));
    exit;
}






// ----------------------------------------------------------------
//EMAIL VALIDATION

// Get the user inputed email
$email = filter_var($_POST['email'], FILTER_SANITIZE_EMAIL);

// Check if the email is not empty
if (empty($email)) {
    // The email is empty
    // Store the error message
    $error = 'Please enter an email';
    // Render the registration form with the error message
    header('Location: ../register?error=' . urlencode($error));
    exit;
}


// Check if the email is valid
if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    // The email is invalid
    // Store the error message
    $error = 'Please enter a valid email';
    // Render the registration form with the error message
    header('Location: ../register?error=' . urlencode($error));
    exit;
}



// Check if the email is a Gmail email address
if (!preg_match('/@gmail\.com$/', $email)) {
    // The email is not a Gmail email address
    // Store the error message
    $error = 'Please enter a Gmail email address';
    // Render the registration form with the error message
    header('Location: register?error=' . urlencode($error));
    exit;
}

// Prepare the SQL statement
$stmt = $pdo->prepare('SELECT * FROM users WHERE email = :email');

// Execute the SQL statement
$stmt->execute([':email' => $email]);

// Check if the email is already registered
if ($stmt->rowCount() > 0) {
    // The email is already registered
    // Store the error message
    $error = 'This email is already registered';
    // Render the registration form with the error message
    header('Location: ../register?error=' . urlencode($error));
    exit;
}


//----------------------------------------------------------------
//PASSWORD VALIDATION

// Check if the password is not empty
if (empty($password)) {
    // The password is empty
    // Store the error message
    $error = 'The password field cannot be empty';
    // Render the registration form with the error message
    header('Location: ../register?error=' . urlencode($error));
    exit;
}


// Check if the password is at least 8 characters long
if (strlen($password) < 8) {
    // The password is not long enough
    // Store the error message
    $error = 'The password must be at least 8 characters long';
    // Render the registration form with the error message
    header('Location: ../register?error=' . urlencode($error));
    exit;
}


// Check if the password has at least one uppercase letter
if (!preg_match('/[A-Z]/', $password)) {
    // The password does not have an uppercase letter
    // Store the error message
    $error = 'The password must have at least one uppercase letter';
    // Render the registration form with the error message
    header('Location: ../register?error=' . urlencode($error));
    exit;
}

// Check if the password has at least one lowercase letter
if (!preg_match('/[a-z]/', $password)) {
    // The password does not have a lowercase letter
    // Store the error message
    $error = 'The password must have at least one lowercase letter';
    // Render the registration form with the error message
    header('Location: ../register?error=' . urlencode($error));
    exit;
}

// Check if the password has at least one number
if (!preg_match('/\d/', $password)) {
    // The password does not have a number
    // Store the error message
    $error = 'The password must have at least one number';
    // Render the registration form with the error message
    header('Location: ../register?error=' . urlencode($error));
    exit;
}

// Check if the password has at least one symbol
if (!preg_match('/\W/', $password)) {
    // The password does not have a symbol
    // Store the error message
    $error = 'The password must have at least one symbol';
    // Render the registration form with the error message
    header('Location: ../register?error=' . urlencode($error));
    exit;
}

//----------------------------------------------------------------
//CONFIRM PASSWORD VALIDATION

// Check if the confirm password is not empty
if (empty($confirm_password)) {
    // The confirm password is empty
    // Store the error message
    $error = 'The confirm password field cannot be empty';
    // Render the registration form with the error message
    header('Location: ../register?error=' . urlencode($error));
    exit;
}

// Check if the password matches the confirm password
if ($password !== $confirm_password) {
    // The passwords do not match
    // Store the error message
    $error = 'The passwords do not match';
    // Render the registration form with the error message
    header('Location: ../register?error=' . urlencode($error));
    exit;
}


$hashed_password = password_hash($password, PASSWORD_BCRYPT);
// Generate a referral code for a user
$referral_code = generate_referral_code();

// Generate a unique verification string
$verification_code = generate_unique_verification_string_md5();


// Generate a unique user ID with initials "TP" and a random 6-digit code
do {
    $randomCode = generateRandomCode();
    $userId = 'TP' . $randomCode;
} while (checkIfUserIdExists($userId));

// Store the generated user ID in a variable
$generatedUserId = $userId;

// Create a new user profile record
createUserProfile($pdo, $generatedUserId, $referredBy);
createWalletForUser($pdo, $generatedUserId);


// Insert the user data into the users database
$stmt = $pdo->prepare('
    INSERT INTO users (user_id, email, username, password, referral_code, email_verification_code, created_at)
    VALUES (:user_id, :email, :username, :password, :referral_code, :verification_code, CURRENT_TIMESTAMP)
');

$stmt->bindValue(':user_id', $generatedUserId, PDO::PARAM_STR);
$stmt->bindValue(':email', $email, PDO::PARAM_STR);
$stmt->bindValue(':username', $username, PDO::PARAM_STR);
$stmt->bindValue(':password', $hashed_password, PDO::PARAM_STR);
$stmt->bindValue(':referral_code', $referral_code, PDO::PARAM_STR);
$stmt->bindValue(':verification_code', $verification_code, PDO::PARAM_STR);

try {
    $stmt->execute();
    

    if ($stmt->rowCount() > 0) {
        echo "User created with user ID: $generatedUserId (email: $email, username: $username, referral code: $referral_code)...\n";

        // Create a new user profile record
        createUserProfile($pdo, $generatedUserId, $referredBy);
        createWalletForUser($pdo, $generatedUserId);

        // // Send an email verification link to the user
        sendVerificationEmail($email, $verification_code, $username, $verificationTime);

        // Redirect to the registration success page
        header('Location: ../register-success');
        exit;
    } else {
        echo "Failed to create user...\n";
    }
} catch (PDOException $e) {
    echo "PDOException: " . $e->getMessage() . "\n";
}









} 
else {
    header("Location: ../register");
}