<?php 
if(isset($_GET['kyc_id'])) {
    require_once '../config/database.php';
    $user = filter_var($_GET['user'], FILTER_SANITIZE_SPECIAL_CHARS);

    $kyc_id = filter_var($_GET['kyc_id'], FILTER_SANITIZE_NUMBER_INT);
    if(!is_numeric($kyc_id)) {
        die('Invalid kyc_id');
    }
    // $host = "hostname";
    // $db = "database_name";
    // $user = "username";
    // $pass = "password";
    // $charset = "utf8mb4";

    //$dsn = "mysql:host=$host;dbname=$db;charset=$charset";
    // $opt = [
    //     PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    //     PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    //     PDO::ATTR_EMULATE_PREPARES   => false,
    // ];
    // $pdo = new PDO($dsn, $user, $pass, $opt);

    $sql = "SELECT * FROM kyc WHERE id = :kyc_id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindValue(':kyc_id', $kyc_id);
    $stmt->execute();
    $result = $stmt->fetch();
    if($result['status'] !== 'pending' || $result['status'] !== 'approved') {
        //redirect back to kyc list
        header ('Location: ../kyc');
    }

    if($result && $result['status'] === 'pending' || $result['status'] === 'approved') {
        $update = "UPDATE kyc SET status = 'rejected', approved_by = :updated_by WHERE id = :kyc_id";
        $update_stmt = $pdo->prepare($update);
        $update_stmt->bindValue(':kyc_id', $kyc_id);
        $update_stmt->bindValue(':updated_by', $user);
        $update_stmt->execute();

        // $kyc_data = "SELECT * FROM kyc WHERE kyc_id = :kyc_id";
        // $kyc_stmt = $pdo->prepare($kyc_data);
        // $kyc_stmt->bindValue(':kyc_id',$kyc_id);
        // $kyc_stmt->execute();
        // $kyc_result = $kyc_stmt->fetch();
        // print_r($kyc_result);

        print_r($result);
        

        $update_user = "UPDATE user_profiles SET is_kyc_verified = 0, is_phone_verified = 0 WHERE user_id = :user_id";
        $update_user_stmt = $pdo->prepare($update_user);
        $update_user_stmt->bindValue(':user_id', $result['user_id']);
        $update_user_stmt->execute();

        if($update && $update_user) {
        
        echo "KYC id $kyc_id has been approved.";
        header("Location:../kyc");
    } else {
        echo "KYC id $kyc_id is not pending.";
        header("Location:../kyc");
    }
}

} else {
    header ('Location: ../kyc');
}

