<?php

if (isset($_POST['change'])) {
    $password = trim($_POST['password']);
    $confirmPassword = trim($_POST['confirm-password']);

    // Sanitize input
    $password = filter_var($password, FILTER_SANITIZE_SPECIAL_CHARS);
    $confirmPassword = filter_var($confirmPassword, FILTER_SANITIZE_SPECIAL_CHARS);

    // Validate input
    if (empty($password) || empty($confirmPassword)) {
        // Return error message if password or confirm password are empty
        header('Location:../reset_password?error=empty-password');
    } else if (strlen($password) < 8) {
        // Return error message if password is shorter than 8 characters
        header('Location:../reset_password?error=short-password');
    } else if (strlen($confirmPassword) < 8) {
        // Return error message if confirm password is shorter than 8 characters
        header('Location:../reset_password?error=short-confirm-password');
    } else if (!preg_match("#[A-Z]+#", $confirmPassword)) {
        // Return error message if confirm password doesn't contain an uppercase character
        header('Location:../reset_password?error=no-uppercase');
    } else if (!preg_match("#[a-z]+#", $confirmPassword)) {
        // Return error message if confirm password doesn't contain a lowercase character
        header('Location:../reset_password?error=no-lowercase');
    } else if (!preg_match("#[0-9]+#", $confirmPassword)) {
        // Return error message if confirm password doesn't contain a number
        header('Location:../reset_password?error=no-number');
    } else if (!preg_match("#[\!\$\%\^\&\*\+\=\-\_\@\#\~\`\{\}\[\]\|]+#", $confirmPassword)) {
        // Return error message if confirm password doesn't contain a symbol
        header('Location:../reset_password?error=no-symbol');
    } else if ($password!== $confirmPassword) {
        // Return error message if password and confirm password don't match
        header('Location:../reset_password?error=password-mismatch');
    } else {
        // Password is valid and matches confirm password, proceed with updating password
    }
}