<?php 
 
function isValidNigerianPhoneNumber($phone) {
    return preg_match('/^[0-9]{11}$/', $phone);
}

function isValidDateOfBirth($dob) {
    return preg_match('/^\d{2}\/\d{2}\/\d{4}$/', $dob);
}

function sanitizeUserInput($data) {
    $data = trim($data);
    $data = stripslashes($data);
    $data = htmlspecialchars($data);
    $data = filter_var($data, FILTER_SANITIZE_SPECIAL_CHARS);

    return $data;
}

if (isset($_POST['update-profile'])) {
    // Require database permission
    require_once '../config/database.php';
    // Define an array of Nigerian states
$nigerianStates = ['Abia', 'Adamawa', 'Akwa Ibom', 'Anambra', 'Bauchi', 'Bayelsa', 'Benue', 'Borno', 'Cross River', 'Delta', 'Ebonyi', 'Edo', 'Ekiti', 'Enugu', 'FCT - Abuja', 'Gombe', 'Imo', 'Jigawa', 'Kaduna', 'Kano', 'Katsina', 'Kebbi', 'Kogi', 'Kwara', 'Lagos', 'Nasarawa', 'Niger', 'Ogun', 'Ondo', 'Osun', 'Oyo', 'Plateau', 'Rivers', 'Sokoto', 'Taraba', 'Yobe', 'Zamfara'];

// Validate first name
if (!preg_match('/^[a-zA-Z\s]+$/', $_POST['firstname'])) {
    $errorMessage = urlencode('Invalid first name');
    header('Location: ../profile?error=' . $errorMessage);
    exit();
} else {
    $_POST['firstname'] = sanitizeUserInput($_POST['firstname']);

    // Validate last name
    if (!preg_match('/^[a-zA-Z\s]+$/', $_POST['lastname'])) {
        $errorMessage = urlencode('Invalid last name');
        header('Location: ../profile?error=' . $errorMessage);
        exit();
    } else {
        $_POST['lastname'] = sanitizeUserInput($_POST['lastname']);

        // Validate phone number
        if (trim(!preg_match('/^(\+\d{1,2}\s)?\d{10,12}$/', $_POST['phone']))) {
            $errorMessage = urlencode('Invalid phone number');
            header('Location: ../profile?error=' . $errorMessage);
            exit();
        } else {
            $_POST['phone'] = sanitizeUserInput($_POST['phone']);

            // Validate state
            if (!in_array($_POST['state'], $nigerianStates)) {
                $errorMessage = urlencode('Invalid state');
                header('Location: ../profile?error=' . $errorMessage);
                exit();
            } else {
                $_POST['state'] = sanitizeUserInput($_POST['state']);

                // Validate zip code
                if (trim(!preg_match('/^\d{6}$/', $_POST['zip-code']))) {
                    $errorMessage = urlencode('Invalid zip code');
                    header('Location: ../profile?error=' . $errorMessage);
                    exit();
                } else {
                    $_POST['zip-code'] = sanitizeUserInput($_POST['zip-code']);

                    // Validate transaction pin
                    // if (!preg_match('/^\d{4}$/', $_POST['transaction-pin'])) {
                    //     $errorMessage = urlencode('Invalid transaction pin');
                    //     header('Location: ../profile?error=' . $errorMessage);
                    //     exit();
                    // } else {
                    //     $_POST['transaction-pin'] = sanitizeUserInput($_POST['transaction-pin']);
                    //     $validationResult = ['status' => 'success', 'userDetails' => $_POST];


            
            // Get the transaction-pin from the form
            $transaction_pin = $_POST['transaction-pin'];

            // Hash the transaction-pin using the password_hash function
            $hashed_transaction_pin = password_hash($transaction_pin, PASSWORD_DEFAULT);


                        
                        // Check if the user_id exists in the user_profiles table
$query = "SELECT * FROM user_profiles WHERE user_id = :user_id";
$stmt = $pdo->prepare($query);
$stmt->execute([':user_id' => $_POST['user_id']]);

if ($stmt->rowCount() > 0) {
    // Update user details into user_profiles table
    $query = "UPDATE user_profiles SET user_first_name = :firstname, user_last_name = :lastname, user_phone_number = :phone, user_state = :state, user_city = :city, user_transaction_pin = :transactionPin, user_address_line_1 = :address, date_of_birth = :dob, user_zip_code = :zipCode WHERE user_id = :user_id";

    $stmt = $pdo->prepare($query);
    $result = $stmt->execute([
        ':firstname' => $_POST['firstname'],
        ':lastname' => $_POST['lastname'],
        ':phone' => $_POST['phone'],
        ':state' => $_POST['state'],
        ':city' => $_POST['city'],
        ':transactionPin' => $hashed_transaction_pin,
        ':address' => $_POST['address'],
        ':dob' => $_POST['dob'],
        ':zipCode' => $_POST['zip-code'],
        ':user_id' => $_POST['user_id'] // Add this line to bind the user_id parameter
    ]);

    if ($result) {
        // User account was updated successfully
        $message = urlencode('User profile updated successfully');
        header('Location: ../profile?message=' . $message);
    } else {
        // Error updating user account
        $errorMessage = urlencode('Error updating user profile');
        header('Location: ../profile?error=' . $errorMessage);
    }
} else {
    // User not found
    $errorMessage = urlencode('User not found');
    header('Location: ../profile?error=' . $errorMessage);
}
                    //}
                }
            }
        }
    }
}


}




//----------------------------------------------------------------

//FUNCTION TO GET THE USERS TOP 5 LATEST TRANSACTIONS FROM THE DATABASE
function getTop5LatestTransactions($user_id) {
    global $pdo; // Assuming you have a global $pdo object for database connection

    $query = "SELECT * FROM transactions WHERE user_id = ? ORDER BY created_at DESC LIMIT 5";
    $stmt = $pdo->prepare($query);
    $stmt->execute([$user_id]);

    if ($stmt->rowCount() === 0) {
        echo '
        <tr>
            <td colspan="8" class="text-center">
               
                <span class="lead text-center">No transactions found.</span>
            </td>
        </tr>
        ';
        return;
    }

    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $transaction_status = match ($row['transaction_status']) {
            'pending' => '<div class="data-state data-state-pending"></div>',
            'progress' => '<div class="data-state data-state-progress"></div>',
            'approved' => '<div class="data-state data-state-approved"></div>',
            'delivered' => '<div class="data-state data-state-approved"></div>',
            'failed' => '<div class="data-state data-state-failed"></div>',
            'cancelled' => '<div class="data-state data-state-canceled"></div>',
            default => '<div class="data-state data-state-unknown"></div>',
        };

        $badge_class = match ($row['transaction_status']) {
            'pending' => 'info',
            'progress' => 'primary',
            'approved' => 'success',
            'delivered' => 'success',
            'failed' => 'danger',
            'cancelled' => 'danger',
            default => 'secondary',
        };

        ?>
        <tr>
            <td>
                <div class="d-flex align-items-center">
                    <?php echo $transaction_status; ?><span class="lead"><?php echo $row['transaction_reference']; ?></span></div>
            </td>
            <td><span><span class="lead"><?php echo $row['transaction_amount']; ?></span><span class="sub"><?php echo $row['transaction_currency']; ?> <em class="fas fa-info-circle" data-toggle="tooltip" data-placement="bottom" data-original-title=" <?php echo $row['transaction_type']; ?>"></em></span></span>
            </td>
            <td class="d-none d-sm-table-cell tnx-date"><span class="sub sub-s2"><?php echo date('M d, Y h:i A', strtotime($row['created_at'])); ?></span></td>
            
        </tr>
        <?php
    }

    $stmt = null;
}

// ----------------------------------------------------------------

//FUNCTION TO CREATE CHART TABLES

function getTransactionChartData($user_id) {
    global $pdo;

    $query = "SELECT transaction_type, SUM(transaction_amount) as total_amount
              FROM transactions
              WHERE user_id = ?
              GROUP BY transaction_type";
    $stmt = $pdo->prepare($query);
    $stmt->execute([$user_id]);

    $chartData = [
        'labels' => [],
        'datasets' => [
            [
                'label' => 'Bill Payments',
                'data' => [],
                'backgroundColor' => [],
                'borderColor' => [],
            ],
            [
                'label' => 'Deposits',
                'data' => [],
                'backgroundColor' => [],
                'borderColor' => [],
            ],
        ],
    ];

    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $transactionType = strtolower($row['transaction_type']);
        $totalAmount = floatval($row['total_amount']);

        switch ($transactionType) {
            case 'Bill payment':
                $chartData['datasets'][0]['data'][] = $totalAmount;
                $chartData['labels'][] = 'Bill Payments';
                $chartData['datasets'][0]['backgroundColor'][] = 'rgba(255, 99, 132, 0.2)';
                $chartData['datasets'][0]['borderColor'][] = 'rgba(255, 99, 132, 1)';
                break;
            case 'Deposit':
                $chartData['datasets'][1]['data'][] = $totalAmount;
                $chartData['labels'][] = 'Deposits';
                $chartData['datasets'][1]['backgroundColor'][] = 'rgba(54, 162, 235, 0.2)';
                $chartData['datasets'][1]['borderColor'][] = 'rgba(54, 162, 235, 1)';
                break;
            default:
                // Handle other transaction types if needed
                break;
        }
    }

    return $chartData;
}


//----------------------------------------------------------------
//FUNCTION TO VALIDATE AND UPDAATE USER PASSWORD
function validateAndUpdatePassword($userId, $oldPassword, $newPassword, $confirmPassword) {
    global $pdo;

    if ($newPassword !== $confirmPassword) {
        header("location: ../profile?error=" . urlencode('New password and confirm password do not match'));
        return;
    }

    // Check if the new password is valid (contains at least one capital letter, one small letter, one number, and one symbol)
    if (!preg_match('/^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[!@#$%^&*]).+$/', $newPassword)) {
        header("location: ../profile?error=" . urlencode('New password must contain at least one capital letter, one small letter, one number, and one symbol'));
        return;
    }

    
    

    // Retrieve the user's password from the database
    $query = "SELECT password FROM users WHERE user_id = ?";
    $stmt = $pdo->prepare($query);
    $stmt->execute([$userId]);
    $userPassword = $stmt->fetch(PDO::FETCH_ASSOC);

    // Verify the old password with the stored password
    if (password_verify($oldPassword, $userPassword['password'])) {
        // Hash the new password
        $hashedNewPassword = password_hash($newPassword, PASSWORD_DEFAULT);

        // Update the user's password in the database
        $query = "UPDATE users SET password = ? WHERE id = ?";
        $stmt = $pdo->prepare($query);
        $stmt->execute([$hashedNewPassword, $userId]);

        header("location: ../profile?message=Password Changed Successfully");
    } else {
        header("location: ../profile?error=" . urlencode('Incorrect old password'));
    }
}

if(isset($_POST['changePassword'])) {
    require_once '../config/database.php';
    $userId = filter_var($_GET['userId'], FILTER_SANITIZE_SPECIAL_CHARS);
    $oldPassword = filter_input(INPUT_POST, 'old_password', FILTER_SANITIZE_SPECIAL_CHARS);
    $newPassword = filter_input(INPUT_POST, 'new_password', FILTER_SANITIZE_SPECIAL_CHARS);
    $confirmPassword = filter_input(INPUT_POST, 'confirm_password', FILTER_SANITIZE_SPECIAL_CHARS);
    validateAndUpdatePassword($userId, $oldPassword, $newPassword, $confirmPassword);
   
}


//----------------------------------------------------------------
//FUNBCTION TO VERIFY USER KYC DATAS


function verifyAndSanitizeUserDetails() {
    require_once '../config/database.php';
    $errorMessage = '';
    $nigerianStates = ['Abia', 'Adamawa', 'Akwa Ibom', 'Anambra', 'Bauchi', 'Bayelsa', 'Benue', 'Borno', 'Cross River', 'Delta', 'Ebonyi', 'Edo', 'Ekiti', 'Enugu', 'FCT - Abuja', 'Gombe', 'Imo', 'Jigawa', 'Kaduna', 'Kano', 'Katsina', 'Kebbi', 'Kogi', 'Kwara', 'Lagos', 'Nasarawa', 'Niger', 'Ogun', 'Ondo', 'Osun', 'Oyo', 'Plateau', 'Rivers', 'Sokoto', 'Taraba', 'Yobe', 'Zamfara'];

    // Check if the form is submitted
    if (isset($_POST['verify-kyc'])) {
        //require '../config/database.php';
        // Get the user details from the form
        $userId = $_POST['user_id'];
        $firstname = $_POST['firstname'];
        $lastname = $_POST['lastname'];
        $email = $_POST['email'];
        $phone = $_POST['phone'];
        $dob = $_POST['dob'];
        $gender = $_POST['gender'];
        $bvn = $_POST['bvn'];
        $nin = $_POST['nin'];
        $address = $_POST['address'];
        $city = $_POST['city'];
        $state = $_POST['state'];
        $zipCode = $_POST['zip-code'];
        $country = $_POST['country'];
        $toc = isset($_POST['toc']) ? 1 : 0; // Check if the user has agreed to the terms of service
        $agree = isset($_POST['agree']) ? 1 : 0; // Check if the user has agreed to the terms of service

        // Verify and sanitize the user details
        $userId = filter_var($userId, FILTER_SANITIZE_SPECIAL_CHARS);
        $firstname = filter_var($firstname, FILTER_SANITIZE_SPECIAL_CHARS);
        $lastname = filter_var($lastname, FILTER_SANITIZE_SPECIAL_CHARS);
        $email = filter_var($email, FILTER_SANITIZE_EMAIL);
        $phone = filter_var($phone, FILTER_SANITIZE_SPECIAL_CHARS);
        $dob = filter_var($dob, FILTER_SANITIZE_SPECIAL_CHARS);
        $bvn = filter_var($bvn, FILTER_SANITIZE_SPECIAL_CHARS);
        $gender = filter_var($gender, FILTER_SANITIZE_SPECIAL_CHARS);
        $nin = filter_var($nin, FILTER_SANITIZE_SPECIAL_CHARS);
        $address = filter_var($address, FILTER_SANITIZE_SPECIAL_CHARS);
        $city = filter_var($city, FILTER_SANITIZE_SPECIAL_CHARS);
        $state = filter_var($state, FILTER_SANITIZE_SPECIAL_CHARS);
        $zipCode = filter_var($zipCode, FILTER_SANITIZE_SPECIAL_CHARS);

        // $stmt = $pdo->prepare('SELECT * FROM user_profiles WHERE user_id = :user_id');
        // $stmt->bindParam(':user_id', $userId, PDO::PARAM_INT);
        // $stmt->execute();

        //$userProfiles = $stmt->fetchAll(PDO::FETCH_ASSOC);
        ///////////////////////////////
        // $stmt = $pdo->prepare("SELECT up.*, u.* FROM user_profiles up INNER JOIN users u ON up.user_id = u.user_id WHERE up.user_id = :userId");
        // $stmt->bindParam(':userId', $userId, PDO::PARAM_INT);
        // $stmt->execute();
        // $result = $stmt->fetchAll(PDO::FETCH_ASSOC);

        // Verify that the country is Nigeria
        if ($country !== 'Nigeria') {
            $errorMessage = urlencode('Invalid country');
            header('Location: ../kyc-form?error=' . $errorMessage);
            exit();
        }

        // Verify that the user has agreed to the terms of service
        if (!$toc) {
            $errorMessage = urlencode('You must agree to the terms of service');
            header('Location: ../kyc-form?error=' . $errorMessage);
            exit();
        }

        if (!$agree) {
            $errorMessage = urlencode('You must confirm that your inputed details are correct');
            header('Location: ../kyc-form?error=' . $errorMessage);
            exit();
        }

        // Verify and sanitize the phone number
        if (!isValidNigerianPhoneNumber($phone)) {
            $errorMessage = urlencode('Invalid phone number');
            header('Location: ../kyc-form?error=' . $errorMessage);
            exit();
        }

        // Verify and sanitize the date of birth
        if (!isValidDateOfBirth($dob)) {
            $errorMessage = urlencode('Invalid date of birth');
            header('Location: ../kyc-form?error=' . $errorMessage);
            exit();
        }

        // Verify and sanitize the BVN
        if (!preg_match('/^\d{11}$/', $bvn)) {
            $errorMessage = urlencode('Invalid BVN');
            header('Location: ../kyc-form?error=' . $errorMessage);
            exit();
        }

        // Verify and sanitize the NIN
        if (!preg_match('/^\d{11}$/', $nin)) {
            $errorMessage = urlencode('Invalid NIN');
            header('Location: ../kyc-form?error=' . $errorMessage);
            exit();
        }

         // Verify and sanitize the zip code
    if (!preg_match('/^\d{6}$/', $zipCode)) {
        $errorMessage = urlencode('Invalid zip code');
        header('Location: ../kyc-form?error=' . $errorMessage);
        exit();
    }

    // Verify that the state is a valid Nigerian state
    if (!in_array($state, $nigerianStates)) {
        $errorMessage = urlencode('Invalid state');
        header('Location: ../kyc-form?error=' . $errorMessage);
        exit();
    }

        $gen = '';
    if($gender == 'male') {
        $gen = 0;
    } else {
        $gen = 1;
    }

    // Verify and sanitize the file upload
    $file = $_FILES['file'];
    $fileError = $file['error'];
    $fileDestPath = '';
    if ($fileError === UPLOAD_ERR_OK) {
        $allowedTypes = ['image/jpeg', 'image/png', 'image/jpg'];
        $maxFileSize = 1000000; // 1 MB
        $fileType = $file['type'];
        $fileSize = $file['size'];
        $fileName = $file['name'];
        $fileTmpPath = $file['tmp_name'];

        if (in_array($fileType, $allowedTypes) && $fileSize <= $maxFileSize) {
            $fileDestPath = '../upload/' . time() . '-' . $fileName;
            if (move_uploaded_file($fileTmpPath, $fileDestPath)) {
                echo "File uploaded successfully: $fileDestPath<br>";
            } else {
                echo "Error moving uploaded file: $fileTmpPath<br>";
                $errorMessage = urlencode('Error moving uploaded file');
                header('Location: ../kyc-form?error=' . $errorMessage);
                exit();
            }
        } else {
            echo "Invalid file type or size<br>";
            $errorMessage = urlencode('Invalid file type or size');
            header('Location: ../kyc-form?error=' . $errorMessage);
            exit();
        }
    }


    //////////////////////////////////// TRY GENERATING A USER ACCOUNT FROM 9PSB

    $api_url = "http://102.216.128.75:9090/bank9ja/api/v2/k1/authenticate";
    $username = "trilspay";
    $password = "uMmNx3B4sDJTgdETq2FPOq5z38aandFl2FSObKg9jmTyvxgYca";
    $client_id = "waas";
    $client_secret = "cRAwnWElcNMUZpALdnlve6PubUkCPOQR";

    $data = array(
        'username' => $username,
        'password' => $password,
        'clientId' => $client_id,
        'clientSecret' => $client_secret
    );

    $ch = curl_init();

    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));

    $response = curl_exec($ch);
    // JSON response containing the access token
    $json_response = $response;

    // Decode the JSON response
    $response_data = json_decode($json_response, true);

    // Extract the access token value
    $access_token = $response_data['accessToken'];

    // Output the access token value
    //echo "Access Token: " . $access_token;

    if (!$response) {
        die('Error: "' . curl_error($ch) . '" - Code: ' . curl_errno($ch));
    }

    curl_close($ch);

    $result = json_decode($response, true);


    /////////////////////////////////////////////////////////////

    $api_url = "http://102.216.128.75:9090/waas/api/v1/open_wallet";
                            $access_token = $access_token;

                                ///print_r($user);
                            // Assign values to PHP variables
                            $transactionTrackingRef = $userId;
                            $lastName = $lastname;
                            $otherNames = $firstname;
                            $accountName = $firstname . ' ' . $lastname;
                            $phoneNo = $phone;
                            $gender = $gen;
                            $dateOfBirth = $dob;
                            $email = $email;
                            $bvn = $bvn;
                            $customerID = $userId;
                            $walletType = "INDIVIDUAL";




                            // Parse the date into a DateTime object
                            $date = DateTime::createFromFormat('m/d/Y', $dateOfBirth);

                            // Convert the date to the desired format: dd/mm/yyyy
                            $dateOfBirth = $date->format('d/m/Y');
                            //echo $dateOfBirth;

                            //////////////////////////////////////////////////////////////////////////////////////

                            $api_url = "http://102.216.128.75:9090/waas/api/v1/open_wallet";
                            $access_token = $access_token;

                            $data = array(
                                "transactionTrackingRef" => $transactionTrackingRef,
                                "lastName" => $lastName,
                                "otherNames" => $otherNames,
                                "accountName" => $accountName,
                                "phoneNo" => $phoneNo,
                                "gender" => $gender,
                                "dateOfBirth" => $dateOfBirth,
                                "email" => $email,
                                "bvn" => $bvn,
                                "customerID" => $customerID,
                                "walletType" => $walletType
                            );

                            $data_json = json_encode($data);

                            //print_r($data_json);

                            $ch = curl_init();
                            curl_setopt($ch, CURLOPT_URL, $api_url);
                            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                            curl_setopt($ch, CURLOPT_POST, 1);
                            curl_setopt($ch, CURLOPT_POSTFIELDS, $data_json);
                            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                                'Content-Type: application/json',
                                'Authorization: Bearer ' . $access_token
                            ));

                            $response = curl_exec($ch);
                            //print_r($response);

                            if ($response === false) {
                                die('Curl error: ' . curl_error($ch));
                            }

                            // $http_status = curl_getinfo($ch, CURLINFO_HTTP_CODE);

                            // if ($http_status !== 200) {
                            //     die('HTTP error: ' . $http_status);
                            // }

                            curl_close($ch);

                            $result = json_decode($response, true);

                            // if (json_last_error() !== JSON_ERROR_NONE) {
                            //     die('JSON decode error: ' . json_last_error_msg());
                            // }

                            //print_r($result);

                            // Decode the JSON response
                            $response_data = json_decode($response, true);
                            print_r($response_data);
                            // Extract data and assign to variables
                            $status = $response_data['status'];
                            // $message = $response_data['message'];
                            // $orderRef = $response_data['data']['orderRef'];
                            // $accountNumber = $response_data['data']['accountNumber'];
                            // $customerID = $response_data['data']['customerID'];
                            // $fullName = $response_data['data']['fullName'];


                            if($status !== 'FAILED') {
                                //echo strtoupper($status);

                                print_r($response_data);





                                if ($errorMessage === '') {



                                    PRINT_R($_POST);
                                    global $pdo;
                                    $stmt = $pdo->prepare('INSERT INTO kyc (user_id, user_first_name, user_last_name, user_email, user_phone, user_dob, user_bvn, user_nin, user_address, user_city, user_state, user_country, user_zip_code, user_nepa_bill_img_link, toc, agree) VALUES (:user_id, :firstname, :lastname, :email, :phone, :dob, :bvn, :nin, :address, :city, :state, :country, :zip_code, :file_path, :toc, :agree)');
                                    $stmt->bindParam(':user_id', $userId);
                                    $stmt->bindParam(':firstname', $firstname);
                                    $stmt->bindParam(':lastname', $lastname);
                                    $stmt->bindParam(':email', $email);
                                    $stmt->bindParam(':phone', $phone);
                                    $stmt->bindParam(':dob', $dob);
                                    $stmt->bindParam(':bvn', $bvn);
                                    $stmt->bindParam(':nin', $nin);
                                    $stmt->bindParam(':address', $address);
                                    $stmt->bindParam(':city', $city);
                                    $stmt->bindParam(':state', $state);
                                    $stmt->bindParam(':country', $country);
                                    $stmt->bindParam(':zip_code', $zipCode);
                                    $stmt->bindParam(':file_path', $fileDestPath);
                                    $stmt->bindParam(':toc', $toc);
                                    $stmt->bindParam(':agree', $agree);
                                    
                            
                                    if ($stmt->execute()) {
                                        
                                    } else {
                                        echo "Error inserting user details<br>";$errorMessage = urlencode('The form is not unable to process the request, Please contact support.');
                                        header('Location: ../kyc-form?error=' . $errorMessage);
                                        exit();
                                    }
                                }


                            } else {
                                echo "Error uploading file<br>";$errorMessage = urlencode('Invalid NIN or BVN provided. Please kindly provide a valid one to proceed with your request.');
                                header('Location: ../kyc-form?error=' . $errorMessage);
                                exit();
                            }



    ////////////////////////////////////////////////////////////////////




    //If everything is valid, insert the user details into the kyc table
    
}

// If the form is not submitted, return an error
//header('Location: ../kyc-thank-you');
//exit();
}


if(isset($_POST['verify-kyc'])) {

    require_once '../config/database.php';

if (!$pdo) {
    die('Database connection failed');
}

    verifyAndSanitizeUserDetails();


  


}


//----------------------------------------------------------------

//FUNCTION TO PAGINATE USER TRANSACTIONS

function getPaginationLinks($totalTransactions, $currentPage) {
    if (!is_int($totalTransactions)) {
        // Handle the error here, such as returning an empty string or throwing an exception
        return '';
    }

    $totalPages = ceil($totalTransactions / 25);

    if ($totalPages <= 1) {
        return '';
    }

    $paginationHtml = '<ul class="pagination">';

    if ($currentPage > 1) {
        $paginationHtml .= '<li class="page-item"><a class="page-link" href="?page=' . ($currentPage - 1) . '">Previous</a></li>';
    }

    for ($i = 1; $i <= $totalPages; $i++) {
        if ($i == $currentPage) {
            $paginationHtml .= '<li class="page-item active"><a class="page-link" href="?page=' . $i . '">' . $i . '</a></li>';
        } else {
            $paginationHtml .= '<li class="page-item"><a class="page-link" href="?page=' . $i . '">' . $i . '</a></li>';
        }
    }

    if ($currentPage < $totalPages) {
        $paginationHtml .= '<li class="page-item"><a class="page-link" href="?page=' . ($currentPage + 1) . '">Next</a></li>';
    }

    $paginationHtml .= '</ul>';

    return $paginationHtml;
}

//---------------------------------------------------------------------------------------------------------------------------

//FUNCTION TO RETURN USER TRANSACTIONS

function getUserTransactions($user, $page = 1) {
    //require_once '../config/database.php';
    global $pdo;

    $limit = 25; // Number of transactions per page
    $offset = ($page - 1) * $limit; // Calculate the offset
    $currentPage = isset($_GET['page']) && is_numeric($_GET['page']) ? (int) $_GET['page'] : 1;

    $stmt = $pdo->prepare('SELECT * FROM transactions WHERE user_id = :user_id ORDER BY created_at DESC LIMIT :limit OFFSET :offset');
    $stmt->bindParam(':user_id', $user['user_id']);
    $stmt->bindParam(':limit', $limit, PDO::PARAM_INT);
    $stmt->bindParam(':offset', $offset, PDO::PARAM_INT);
    $stmt->execute();

    $transactions = $stmt->fetchAll(PDO::FETCH_ASSOC);
    $paginationHtml = getPaginationLinks($transactions, $currentPage);

    $transactionsPerPage = 25;
    $offset = ($currentPage - 1) * $transactionsPerPage;
    

    if (empty($transactions)) {
        // Call the function if there are no transactions
        noTransactionsFound();
    } else {
        $transactionHtml = '';
        foreach ($transactions as $transaction) {
            $statusIconClass = '';

            if ($transaction['transaction_status'] == 'pending') {
                $statusIconClass = 'data-state-pending';
            } elseif ($transaction['transaction_status'] == 'approved' || $transaction['transaction_status'] == 'delivered') {
                $statusIconClass = 'data-state-approved';
            } elseif ($transaction['transaction_status'] == 'cancelled') {
                $statusIconClass = 'data-state-canceled';
            } elseif ($transaction['transaction_status'] == 'progress') {
                $statusIconClass = 'data-state-progress';
            }
            $transactionHtml .= '
<tr class="data-item">
    <td class="data-col dt-tnxno">
        <div class="d-flex align-items-center">
        <div class="data-state ' . $statusIconClass . '"><span class="d-none"></span></div>
                
            <div class="fake-class"><span class="lead tnx-id">' . htmlspecialchars($transaction['transaction_description']) . '</span><span class="sub sub-date">' . htmlspecialchars(date('d-M-Y h:i A', strtotime($transaction['created_at']))) . '</span></div>
        </div>
    </td>
    <td class="data-col dt-token"><span class="lead token-amount">' . htmlspecialchars($transaction['transaction_reference']) . '</span><span class="sub sub-symbol">' . htmlspecialchars($transaction['transaction_currency']) . '</span></td>
    <td class="data-col dt-amount"><span class="lead amount-pay">' . htmlspecialchars(number_format($transaction['transaction_amount'], 2, '.', ',')) . '</span><span class="sub sub-symbol">' . htmlspecialchars($transaction['transaction_currency']) . ' </span></span></td>
    <td class="data-col dt-usd-amount"><span class="lead amount-pay">' . htmlspecialchars(number_format($transaction['user_paid'], 2, '.', ',')) . '</span><span class="sub sub-symbol">NGN </span></td>
    <td class="data-col dt-account"><span class="lead user-info">' . htmlspecialchars($transaction['transaction_status']) . '</span></td>
    <td class="data-col dt-type"><span class="dt-type-md badge badge-outline badge-success badge-md">' . htmlspecialchars(ucfirst($transaction['transaction_type'])) . '</span><span class="dt-type-sm badge badge-sq badge-outline badge-success badge-md">' . htmlspecialchars(strtoupper($transaction['transaction_type'][0])) . '</span></td>
    <td class="data-col text-right"><a href="transaction-details?tranx-ref=' . htmlspecialchars($transaction['transaction_reference']) . '" class="btn btn-light-alt btn-xs btn-icon"><em class="ti ti-eye"></em></a></td>
</tr>
';
        }

        return $transactionHtml;
    }
}

function noTransactionsFound() {
    // Code to execute if there are no transactions found
    echo 'No transactions found.';
}


//----------------------------------------------------------------
//GET TRANSACTION DETAILS 
function getTransactionDetails($transactionReference, $pdo) {
    // Sanitize the transaction reference to prevent SQL injection and vulnerabilities
    $transactionReference = filter_var($transactionReference, FILTER_SANITIZE_SPECIAL_CHARS);

    // Prepare a SQL query to retrieve the transaction details
    $stmt = $pdo->prepare('SELECT * FROM transactions WHERE transaction_reference = :transaction_reference');

    // Bind the transaction reference parameter
    $stmt->bindParam(':transaction_reference', $transactionReference);

    // Execute the query
    $stmt->execute();

    // Fetch the transaction details as an associative array
    $transactionDetails = $stmt->fetch(PDO::FETCH_ASSOC);

    // Check if the transaction exists
    if (empty($transactionDetails)) {
        // Transaction not found, redirect to the transaction page with an error message
        $errorMessage = urlencode('Transaction not found');
        header('Location: ../transaction?error=' . $errorMessage);
        exit;
    }

    // Return the transaction details
    return $transactionDetails;
}



function getTransactionReferenceFromUrl() {
    // Get the current URL
    $url = "http://" . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];

    // Parse the URL into an array of components
    $urlParts = parse_url($url);

    // Get the query string from the URL
    $queryString = isset($urlParts['query']) ? $urlParts['query'] : '';

    // Parse the query string into an associative array of key-value pairs
    $queryParams = [];
    parse_str($queryString, $queryParams);

    // Get the transaction reference from the query parameters
    $transactionReference = isset($queryParams['tranx-ref']) ? $queryParams['tranx-ref'] : '';

    // Validate the transaction reference
    if (!preg_match('/^[a-zA-Z0-9]+$/', $transactionReference)) {
        // Invalid transaction reference
        return '';
    }

    // Sanitize the transaction reference
    $transactionReference = htmlspecialchars($transactionReference);

    // Return the transaction reference
    return $transactionReference;
}



//CODE TO ADD SERVICES TO DATABASE

if(isset($_POST['add-service'])) {

        require_once '../config/database.php';
//COLLECT THE USER INPUTTED DETAILS AND VALIDATE THEM

    $service_name = filter_input(INPUT_POST, 'service_name', FILTER_SANITIZE_SPECIAL_CHARS);
    if (strlen($service_name) < 1) {
        exit('Invalid service name.');
    }

    // Sanitize service_code
    $service_code = filter_input(INPUT_POST, 'serviceID', FILTER_SANITIZE_SPECIAL_CHARS);
    if (strlen($service_code) < 1) {
        exit('Invalid service code.');
    }

// Prepare the SQL statement
    $stmt = $pdo->prepare("INSERT INTO services (service_name, service_code) VALUES (:service_name, :service_code)");

    // Bind the values
    $stmt->bindValue(':service_name', $service_name);
    $stmt->bindValue(':service_code', $service_code);

    // Execute the SQL
    try {
        $stmt->execute();

        if ($stmt->rowCount() > 0) {
            // Insertion successful
            $success = "Service has been added successfully.";
            // Redirect to the dashboard, or display success message depending on your app
            header('Location: ../services?message=' . urlencode($success));
            exit;
        } else {
            // Failed to insert
            $error = "Error: Failed to add the service.";
            header('Location: ../services?error=' . urlencode($error));
            exit;
        }
    } catch (PDOException $e) {
        // Handle the exception
        $error = "Error: " . $e->getMessage();
        header('Location: ../services?error=' . urlencode($error));
        exit;
    }

}




//----------------------------------------------------------------------------------------------------
//CODE TO ADD NEW PRODUCT INTO DATABASE

if(isset($_POST['add-product'])) {
    //print_r($_POST);-'
    require_once '../config/database.php';

    //COLLECT THE USER INPUTTED DETAILS AND VALIDATE THEM

    $product_name = filter_input(INPUT_POST, 'product_name', FILTER_SANITIZE_SPECIAL_CHARS);
    if (strlen($product_name) < 1) {
        exit('Invalid product name.');
    }

    // Sanitize product_code
    $product_code = filter_input(INPUT_POST, 'variation_code', FILTER_SANITIZE_SPECIAL_CHARS);
    if (strlen($product_code) < 1) {
        exit('Invalid service code.');
    }

    // Sanitize product_code
    $costPrice = filter_input(INPUT_POST, 'cost', FILTER_SANITIZE_NUMBER_INT);
    if (strlen($costPrice) < 1) {
        exit('Invalid cost price.');
    }

   

    // Sanitize product_code
    $serviceID = filter_input(INPUT_POST, 'serviceID', FILTER_SANITIZE_SPECIAL_CHARS);
    if (strlen($serviceID) < 1) {
        exit('Invalid serviceID.');
    }

    // Sanitize product_code
    $duration = filter_input(INPUT_POST, 'duration', FILTER_SANITIZE_SPECIAL_CHARS);
    if (strlen($duration) < 1) {
        exit('Invalid duration.');
    }

// Prepare the SQL statement
    $stmt = $pdo->prepare("INSERT INTO products (product_name, product_code, cost_price, duration, service_code) VALUES (:product_name, :product_code, :cost_price, :duration, :service_code)");

    // Bind the values
    $stmt->bindValue(':product_name', $product_name);
    $stmt->bindValue(':product_code', $product_code);
    $stmt->bindValue(':cost_price', $costPrice);
    $stmt->bindValue(':duration', $duration);
    $stmt->bindValue(':service_code', $serviceID);

    // Execute the SQL
    try {
        $stmt->execute();

        if ($stmt->rowCount() > 0) {
            // Insertion successful
            $success = "Product has been added successfully.";
            // Redirect to the dashboard, or display success message depending on your app
            header('Location: ../product?message=' . urlencode($success));
            exit;
        } else {
            // Failed to insert
            $error = "Error: Failed to add the service.";
            header('Location: ../product?error=' . urlencode($error));
            exit;
        }
    } catch (PDOException $e) {
        // Handle the exception
        $error = "Error: " . $e->getMessage();
        header('Location: ../product?error=' . urlencode($error));
        exit;
    }


}


