<?php

// Get the verification code from the URL
if (isset($_GET['code']) && !empty($_GET['code'])) {
    $verificationCode = $_GET['code'];

    require_once '../config/database.php';
    
    // Check if the verification code exists in the database

    $stmt = $pdo->prepare('
      SELECT user_id
      FROM users
      WHERE email_verification_code = :code
    ');

    $stmt->bindValue(':code', $verificationCode, PDO::PARAM_STR);

    $stmt->execute();

    $userProfile = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($userProfile) {
      // Verification code found in database
      $userId = $userProfile['user_id'];
      // You can now use the $userProfile variable in your code
      // Check if the user's email is already verified

      

  $stmt = $pdo->prepare('
    SELECT is_email_verified
    FROM user_profiles
    WHERE user_id = :user_id
  ');

  $stmt->bindValue(':user_id', $userId, PDO::PARAM_STR);

  $stmt->execute();

  $userProfile = $stmt->fetch(PDO::FETCH_ASSOC);

  if ($userProfile && $userProfile['is_email_verified'] == 1) {
    // Email already verified
    $message = "Your email is already verified.";
    header('Location: ../email-verify?message=' . urlencode($message));
  exit;
  }
  else {
    // Email not yet verified
    // Update the user's email_verified status and email_verification_time
  $stmt = $pdo->prepare('
  UPDATE user_profiles
  SET is_email_verified = 1,
      email_verification_time = NOW()
    WHERE user_id = :user_id
  ');

  $stmt->bindValue(':user_id', $userId, PDO::PARAM_STR);

  $stmt->execute();

  // Delete the email_verification_code from the users table
  $stmt = $pdo->prepare('
    UPDATE users
    SET email_verification_code = NULL
    WHERE user_id = :user_id
  ');

  $stmt->bindValue(':user_id', $userId, PDO::PARAM_STR);

  $stmt->execute();

  // Set the success message
  $message = "Your email has been verified successfully!";

  // Redirect to the registration success page
  header('Location: ../email-verify?message=' . urlencode($message));
  exit;


// 
  }
      // For example, you can update the user's email_verified status
    }
    else {
      // Verification code not found in database
       // Verification code not found in database
      $error = "The verification code is invalid.";
      header('Location: ../email-verify?error=' . urlencode($error));
  exit;
    }
  }
  else {
    // Verification code not found in URL
    header('Location: ../login');
    exit;
  }