<?php

// Database connection
require_once './config/database.php';
$service_code = $_POST['data_network'] ?? '';
$service_code = htmlspecialchars($service_code, ENT_QUOTES, 'UTF-8');

// Check the provided service code
if (!in_array($service_code, $allowed_service_codes = ['mtn-data', 'glo-data', 'etisalat-data', 'airtel-data'])) {
    echo "The provided service code ($service_code) is not valid. Please choose a valid option.";
    exit();
}

// Fetch products for the selected service
$stmt = $pdo->prepare("SELECT DISTINCT duration FROM products WHERE service_code = :code");
$stmt->bindParam(':code', $service_code);
$stmt->execute();

// Generate <option> elements for each duration
$durations = $stmt->fetchAll(PDO::FETCH_ASSOC);
$durationOptions = "<option value=''>Select a duration</option>";

if ($durations) {
    foreach ($durations as $duration) {
        $durationOptions .= "<option>" . htmlspecialchars($duration["duration"]) . "</option>";
    }
} else {
    $durationOptions .= "<option>No service durations found</option>";
}

echo $durationOptions;