<?php

// Database connection
require_once './config/database.php';

$data_plan_id = $_POST['data_plan'] ?? '';

try {
    // Connect to the database
    //$pdo = new PDO("mysql:host=$hostname;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Validate the data plan ID
    if (!empty($data_plan_id)) {
        // Fetch the product price
        $stmt = $pdo->prepare("SELECT cost_price FROM products WHERE product_code = :product_id");
        $stmt->bindParam(':product_id', $data_plan_id);
        $stmt->execute();

        // Check if the product price exists
        if ($productPrice = $stmt->fetchColumn()) {
            // Send the product price back divided by 100
            $price = $productPrice;
            echo $price;
        } else {
            echo "Product price not found.";
        }
    } else {
        echo "Data plan ID is missing.";
    }
} catch (PDOException $e) {
    echo 'Error!: ' . $e->getMessage();
}