<?php
// Database connection
require_once './config/database.php';

$service_code = $_POST['data_network'] ?? '';
$service_code = htmlspecialchars($service_code, ENT_QUOTES, 'UTF-8');

if (!in_array($service_code, $allowed_service_codes = ['mtn-data', 'glo-data', 'etisalat-data', 'airtel-data'])) {
    echo "The provided service code ($service_code) is not valid. Please choose a valid option.";
    exit();
}

$duration = $_POST['duration'] ?? '';
$duration = htmlspecialchars($duration, ENT_QUOTES, 'UTF-8');

// Fetch products for the selected service
$stmt = $pdo->prepare("SELECT DISTINCT product_name, product_code FROM products WHERE service_code = :code AND duration = :duration");
$stmt->bindParam(':code', $service_code);
$stmt->bindParam(':duration', $duration);

$stmt->execute();

// Generate <option> elements for each product
$datas = $stmt->fetchAll(PDO::FETCH_ASSOC);
$dataOptions = "<option value=''>Select a plan</option>";

if ($datas) {
    foreach ($datas as $data) {
        $dataOptions .= "<option value='" . htmlspecialchars($data["product_code"]) . "'>" . htmlspecialchars($data["product_name"]) . "</option>";
    }
} else {
    $dataOptions .= "<option>No service plans found</option>";
}

echo $dataOptions;