<?php
// Start the session
session_start();

// Check if the user is logged in
if (isset($_SESSION['user'])) {
  require_once './config/database.php';
  require_once './functions/function.php';
  // Get the user details from the database
  $user_id = $_SESSION['user'];

  $user = getUser($user_id);
  $wallet = getWallet($user_id);
  $profile = getProfile($user_id);
  $transaction = getTransactions($user_id);
 

} else {
    header("Location: ./login.php");
}

$title = 'KYC Application';

?>

<!DOCTYPE html>
<html lang="en" class="js">

<head>
    <meta charset="utf-8">
    <meta name="author" content="Dasodhub">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="Pay Bills Seamlessly With the Trilspay App">
    <!-- Fav Icon -->
    <link rel="shortcut icon" href="./assets/images/favicon1.png">
    
    <!-- Site Title  -->
    <title><?php echo $title ?> - Pay Bills Seamlessly with Trilspay</title>
    <!-- Vendor Bundle CSS -->
    <link rel="stylesheet" href="assets/css/vendor.bundle49f7.css?ver=104">
    <!-- Custom styles for this template -->
    <link rel="stylesheet" href="assets/css/style.css" id="layoutstyle">
    
    <script>
        (function(i, s, o, g, r, a, m) {
            i['GoogleAnalyticsObject'] = r;
            i[r] = i[r] || function() {
                (i[r].q = i[r].q || []).push(arguments)
            }, i[r].l = 1 * new Date();
            a = s.createElement(o), m = s.getElementsByTagName(o)[0];
            a.async = 1;
            a.src = g;
            m.parentNode.insertBefore(a, m)
        })(window, document, 'script', '../../www.google-analytics.com/analytics.js', 'ga');
        ga('create', 'UA-91615293-2', 'auto');
        ga('send', 'pageview');
    </script>
</head>



<?php 
require_once './topbar.php';
?>
<!-- .topbar-wrap -->
<div class="page-header page-header-kyc">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-8 col-xl-7 text-center">
                <h2 class="page-title">KYC Verification</h2>
                <p class="large">To comply with regulation each user will have to go through identity verification (KYC/AML) to prevent fraud causes. Please, complete our fast and secure verification process.</p>
            </div>
        </div>
    </div>
    <!-- .container -->
</div>
<!-- .page-header -->
<div class="page-content">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10 col-xl-9">
                <div class="kyc-status card mx-lg-4">
                    <div class="card-innr">
                        <div class="status status-empty">
                            <div class="status-icon"><em class="ti ti-files"></em></div><span class="status-text text-dark">You have not submitted your necessary documents to verify your identity. In order to <b>CREDIT OR WITHDRAW</b> from your Wallet, please verify your identity.</span><a href="kyc-form"
                                class="btn btn-primary">Click here to complete your KYC</a></div>
                    </div>
                </div>
                <!-- .card -->
                <p class="text-light text-center">If you have any question, please contact our support team <a href="#">support@trilpay.com</a>.</p>
                <div class="gaps-1x"></div>
                <div class="gaps-3x d-none d-sm-block"></div>
            </div>
        </div>
    </div>
    <!-- .container -->
</div>
<?php
require_once './footer.php';
?>