<?php
// Start the session
session_start();

// Check if the user is logged in
if (isset($_SESSION['user'])) {
  require_once './config/database.php';
  require_once './functions/function.php';
  // Get the user details from the database
  $user_id = $_SESSION['user'];

  $user = getUser($user_id);
  $wallet = getWallet($user_id);
  $profile = getProfile($user_id);
  $transaction = getTransactions($user_id);
 

} else {
    header("Location: ./login.php");
}

$title = 'User KYC Details';

?>

<!DOCTYPE html>
<html lang="en" class="js">

<head>
    <meta charset="utf-8">
    <meta name="author" content="Dasodhub">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="Pay Bills Seamlessly With the Trilspay App">
    <!-- Fav Icon -->
    <link rel="shortcut icon" href="./assets/images/favicon1.png">
    
    <!-- Site Title  -->
    <title><?php echo $title ?> - Pay Bills Seamlessly with Trilspay</title>
    <!-- Vendor Bundle CSS -->
    <link rel="stylesheet" href="assets/css/vendor.bundle49f7.css?ver=104">
    <!-- Custom styles for this template -->
    <link rel="stylesheet" href="assets/css/style.css" id="layoutstyle">
    
    <script>
        (function(i, s, o, g, r, a, m) {
            i['GoogleAnalyticsObject'] = r;
            i[r] = i[r] || function() {
                (i[r].q = i[r].q || []).push(arguments)
            }, i[r].l = 1 * new Date();
            a = s.createElement(o), m = s.getElementsByTagName(o)[0];
            a.async = 1;
            a.src = g;
            m.parentNode.insertBefore(a, m)
        })(window, document, 'script', '../../www.google-analytics.com/analytics.js', 'ga');
        ga('create', 'UA-91615293-2', 'auto');
        ga('send', 'pageview');
    </script>
</head>



<?php
require_once './topbar.php';

if(isset($_GET['kyc_id'])) {
// Sanitized kyc_id from user input
$sanitized_kyc_id = filter_var($_GET['kyc_id'], FILTER_SANITIZE_NUMBER_INT);


// Query to check if the sanitized kyc_id exists in the KYC table
$query = "SELECT * FROM kyc WHERE id = :kyc_id";
$stmt = $pdo->prepare($query);
$stmt->bindParam(':kyc_id', $sanitized_kyc_id);
$stmt->execute();

// If the sanitized kyc_id does not exist in the KYC table
// If the sanitized kyc_id exists in the KYC table
if ($stmt->rowCount() > 0) {
    // Fetch all data from the KYC table where the kyc_id matches the sanitized kyc_id
    $kyc_data = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Do something with the $kyc_data array
   
} else {
    // Redirect back to kyc
    header("Location: ./kyc");
    exit();
}
} else {
    header("Location: ./kyc");
    exit();
}




// print_r($kyc_data);

// echo '<br>';
// echo '<br>';

// echo htmlspecialchars(pathinfo($kyc_data[0]['user_nepa_bill_img_link'], PATHINFO_BASENAME));

?>
    <!-- .topbar-wrap -->
    <div class="page-content">
        <div class="container">
            <div class="card content-area">
                <div class="card-innr">
                    <div class="card-head d-flex justify-content-between align-items-center">
                        <h4 class="card-title mb-0">KYC Details</h4>
                        <div class="d-flex align-items-center guttar-20px">
                            <div class="flex-col d-sm-block d-none"><a href="./kyc" class="btn btn-sm btn-auto btn-primary"><em class="fas fa-arrow-left mr-3"></em>Back</a></div>
                            <div class="flex-col d-sm-none"><a href="./kyc" class="btn btn-icon btn-sm btn-primary"><em class="fas fa-arrow-left"></em></a></div>
                            <div class="relative d-inline-block"><a href="#" class="btn btn-dark btn-sm btn-icon toggle-tigger"><em class="ti ti-more-alt"></em></a>
                                <div class="toggle-class dropdown-content dropdown-content-top-left">
                                    <ul class="dropdown-list">
                                    <li><a href="./functions/approve-kyc.php?kyc_id=<?php echo htmlspecialchars($kyc_data[0]['id'])?>&user=<?php echo htmlspecialchars($user['username'])?>"><em class="ti ti-check"></em> Approve</a></li>
                                    <li><a href="./functions/reject-kyc.php?kyc_id=<?php echo htmlspecialchars($kyc_data[0]['id'])?>&user=<?php echo htmlspecialchars($user['username'])?>"><em class="ti ti-na"></em> Reject</a></li>
                                    <li><a href="delete.php?kyc_id=<?php echo htmlspecialchars($kyc_data[0]['id']) ?>"><em class="ti ti-trash"></em> Delete</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php
                    print_r($user['username']);
                     ?>
                    <div class="gaps-1-5x"></div>
                    <div class="data-details d-md-flex flex-wrap align-items-center justify-content-between">
                    <div class="fake-class"><span class="data-details-title">Submited By</span><span class="data-details-info"><?php echo htmlspecialchars($kyc_data[0]['user_id']) ?></span></div>
        
                        <div class="fake-class"><span class="data-details-title">Submited On</span><span class="data-details-info"<?php echo htmlspecialchars($kyc_data[0]['created_at']) ?></span></div>
                        <div class="fake-class"><span class="data-details-title">Checked By</span><span class="data-details-info"><?php if ($kyc_data[0]['status'] == 'approved') { echo htmlspecialchars($kyc_data[0]['approved_by']); } ?></span></div>
                        <div class="fake-class"><span class="data-details-title">Checked On</span><span class="data-details-info"><?php echo htmlspecialchars($kyc_data[0]['updated_at']) ?></span></div>
                        <div class="fake-class"><span class="badge badge-md badge-block <?php if ($kyc_data[0]['status'] == 'pending') { echo 'badge-warning'; } else { echo 'badge-success'; } ?> ucap"><?php echo htmlspecialchars($kyc_data[0]['status']) ?></span></div>
                        <div class="gaps-2x w-100 d-none d-md-block"></div>
                        <div class="w-100"><span class="data-details-title">Admin Note</span><span class="data-details-info">Verified by phone call</span></div>
                    </div>
                    <div class="gaps-3x"></div>
                    <h6 class="card-sub-title">Personal Information</h6>
                    <ul class="data-details-list">
                        <li>
                        <li>
                            <div class="data-details-head">First Name</div>
                            <div class="data-details-des"><?php echo htmlspecialchars($kyc_data[0]['user_first_name']) ?></div>
                        </li>
                        
                        <!-- li -->
                        <li>
                            <div class="data-details-head">Last Name</div>
                            <div class="data-details-des"><?php echo htmlspecialchars($kyc_data[0]['user_last_name']) ?></div>
      
                        </li>
                        <!-- li -->
                        <li>
                            <div class="data-details-head">Email Address</div>
                            <div class="data-details-des"><?php echo htmlspecialchars($kyc_data[0]['user_email']) ?></div>
      
                        </li>
                        <!-- li -->
                        <li>
                            <div class="data-details-head">Phone Number</div>
                            <div class="data-details-des"><?php echo htmlspecialchars($kyc_data[0]['user_phone']) ?></div>
      
                        </li>
                        <!-- li -->
                        <li>
                            <div class="data-details-head">Full Address</div>
                            <div class="data-details-des"><?php echo htmlspecialchars($kyc_data[0]['user_address']) ?></div>
                        </li>
                        <!-- li -->
                        <li>
                        <div class="data-details-head">City</div>
                        <div class="data-details-des"><?php echo htmlspecialchars($kyc_data[0]['user_city']) ?></div>
        
                        </li>
                        <!-- li -->
                        <li>
                        <div class="data-details-head">State</div>
                        <div class="data-details-des"><?php echo htmlspecialchars($kyc_data[0]['user_state']) ?></div>
        
                        </li>
                        <!-- li -->
                        <li>
                            <div class="data-details-head">Country</div>
                            <div class="data-details-des"><?php echo htmlspecialchars($kyc_data[0]['user_country']) ?></div>
     
                        </li>
                        <!-- li -->
                        <li>
                            <div class="data-details-head">Zip Code</div>
                            <div class="data-details-des"><?php echo htmlspecialchars($kyc_data[0]['user_zip_code']) ?></div>
                        </li>
                                    </ul>
                    <div class="gaps-3x"></div>
                    <h6 class="card-sub-title">Uploaded Documnets</h6>
                    <ul class="data-details-list">
                    `   <li>
                            <div class="data-details-head">NEPA Bill</div>
                            <ul class="data-details-docs">
                                <li><span class="data-details-docs-title">Image</span>
                                    <div class="data-doc-item data-doc-item-lg">
                                    <div class="data-doc-image"><img src="./upload/<?php echo htmlspecialchars(pathinfo($kyc_data[0]['user_nepa_bill_img_link'], PATHINFO_BASENAME)) ?>" alt="NEPA Bill"></div>
                                    <ul class="data-doc-actions">
                                        <li><a href="./upload/<?php echo htmlspecialchars(pathinfo($kyc_data[0]['user_nepa_bill_img_link'], PATHINFO_BASENAME)) ?>" target="_blank"><em class="ti ti-import"></em></a></li>
                                    </ul>
                                    </div>
                        </li>
                            <!-- li -->
                    </ul>
                </div>
                <!-- .card-innr -->
            </div>
            <!-- .card -->
        </div>
        <!-- .container -->
    </div>
    <!-- .page-content -->
    <?php 

    require_once './footer.php';
    ?>