<?php
// Start the session
session_start();

// Check if the user is logged in
if (isset($_SESSION['user'])) {
  require_once './config/database.php';
  require_once './functions/function.php';
  // Get the user details from the database
  $user_id = $_SESSION['user'];

  $user = getUser($user_id);
  $wallet = getWallet($user_id);
  $profile = getProfile($user_id);
  $transaction = getTransactions($user_id);
 

} else {
    header("Location: ./login.php");
}

$title = 'KYC Application Form';

?>

<!DOCTYPE html>
<html lang="en" class="js">

<head>
    <meta charset="utf-8">
    <meta name="author" content="Dasodhub">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="Pay Bills Seamlessly With the Trilspay App">
    <!-- Fav Icon -->
    <link rel="shortcut icon" href="./assets/images/favicon1.png">
    
    <!-- Site Title  -->
    <title><?php echo $title ?> - Pay Bills Seamlessly with Trilspay</title>
    <!-- Vendor Bundle CSS -->
    <link rel="stylesheet" href="assets/css/vendor.bundle49f7.css?ver=104">
    <!-- Custom styles for this template -->
    <link rel="stylesheet" href="assets/css/style.css" id="layoutstyle">
    
    <script>
        (function(i, s, o, g, r, a, m) {
            i['GoogleAnalyticsObject'] = r;
            i[r] = i[r] || function() {
                (i[r].q = i[r].q || []).push(arguments)
            }, i[r].l = 1 * new Date();
            a = s.createElement(o), m = s.getElementsByTagName(o)[0];
            a.async = 1;
            a.src = g;
            m.parentNode.insertBefore(a, m)
        })(window, document, 'script', '../../www.google-analytics.com/analytics.js', 'ga');
        ga('create', 'UA-91615293-2', 'auto');
        ga('send', 'pageview');
    </script>
</head>




<?php 
require_once './topbar.php';
?>
<!-- .topbar-wrap -->
<div class="page-header page-header-kyc">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-8 col-xl-7 text-center">
                <h2 class="page-title">Begin your ID-Verification</h2>
            </div>
        </div>
    </div>
    <!-- .container -->
</div>
<!-- .page-header -->
<div class="page-content">
    <div class="container">
        
        <div class="row justify-content-center">
            <div class="col-lg-10 col-xl-9">
            
            <form action="./functions/validation.php" method="post" enctype="multipart/form-data">
                <div class="kyc-form-steps card mx-lg-4">
                    <?php
                    
                    if (isset($_GET['error'])) {
                        $error = htmlspecialchars($_GET['error']);
                        echo "<div class='alert alert-danger' role='alert'>$error</div>";
                    }

                    ?>
                    <br>
                    <div class="form-step form-step1">
                        <div class="form-step-head card-innr">
                            
                            <div class="step-head">
                                <div class="step-number">01</div>
                                <div class="step-head-text">
                                    <h4>Personal Details</h4>
                                    <p>Your simple personal information required for identification</p>
                                </div>
                            </div>
                        </div>
                        <!-- .step-head -->
                        <div class="form-step-fields card-innr">
                            <div class="note note-plane note-light-alt note-md pdb-1x"><em class="fas fa-info-circle"></em>
                            <p>Please type carefully and fill out the form with your personal details. <span class="text-danger">**Ensure that you provide your correct <strong>Bank Verification Number (BVN)</strong> and <strong>National Identification Number (NIN)</strong>**</span> as these details cannot be edited once the form is submitted.</p>
                            </div>
                            <div class="row">
                                <input type="text" value="<?php echo $user['user_id']; ?>" name="user_id" hidden/>
                                <div class="col-md-6">
                                    <div class="input-item input-with-label"><label class="input-item-label">First Name <span class="text-danger">*</span></label><input class="input-bordered" type="text" value="<?php if(isset($profile['user_first_name'])) {echo $profile['user_first_name'];} ?>" name="firstname"></div>
                                    <!-- .input-item -->
                                </div>
                                <!-- .col -->
                                <div class="col-md-6">
                                    <div class="input-item input-with-label"><label class="input-item-label">Last Name <span class="text-danger">*</span></label><input class="input-bordered" type="text" value="<?php if(isset($profile['user_last_name'])) {echo $profile['user_last_name'];} ?>" name="lastname"></div>
                                    <!-- .input-item -->
                                </div>
                                <!-- .col -->
                                <div class="col-md-6">
                                    <div class="input-item input-with-label"><label class="input-item-label">Email Address <span class="text-danger">*</span></label><input class="input-bordered" type="email" value="<?php if(isset($user['email'])) {echo $user['email'];} ?>" required name="email"></div>
                                    <!-- .input-item -->
                                </div>
                                <!-- .col -->
                                <div class="col-md-6">
                                    <div class="input-item input-with-label"><label class="input-item-label">Phone Number <span class="text-danger">*</span></label><input class="input-bordered" type="tel" value="<?php if(isset($profile['user_phone_number'])) {echo $profile['user_phone_number'];} ?>" name="phone"></div>
                                    <!-- .input-item -->
                                </div>
                                <!-- .col -->
                                <div class="col-md-6">
                                    <div class="input-item input-with-label"><label class="input-item-label">Date of Birth <span class="text-danger">*</span></label><input class="input-bordered date-picker" type="text" value="<?php if(isset($profile['date_of_birth'])) {echo $profile['date_of_birth'];} ?>" name="dob"></div>
                                    <!-- .input-item -->
                                </div>

                                <div class="col-md-6">
                                    <div class="input-item input-with-label">
                                        <label class="input-item-label">Gender <span class="text-danger">*</span></label>
                                        <select class="input-bordered" name="gender">
                                            <option value="male" <?php if(isset($profile['gender']) && $profile['gender'] == 'male') echo 'selected'; ?>>Male</option>
                                            <option value="female" <?php if(isset($profile['gender']) && $profile['gender'] == 'female') echo 'selected'; ?>>Female</option>
                                        </select>
                                    </div>
                                    <!-- .input-item -->
                                </div>
                                <!-- .col -->
                                <div class="col-md-6">
                                    <div class="input-item input-with-label"><label class="input-item-label">BVN<span class="text-danger">*</span></label><input class="input-bordered" type="text" required name="bvn"></div>
                                    <!-- .input-item -->
                                </div>
                                <!-- .col -->

                                <!-- .col -->
                                <div class="col-md-6">
                                    <div class="input-item input-with-label"><label class="input-item-label">NIN<span class="text-danger">*</span></label><input class="input-bordered" type="text" required name="nin"></div>
                                    <!-- .input-item -->
                                </div>
                                <!-- .col -->
                            </div>
                            <!-- .row -->
                            <h4 class="text-secondary mgt-0-5x">Your Address</h4>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="input-item input-with-label"><label class="input-item-label">Address Line 1 <span class="text-danger">*</span></label><input class="input-bordered" type="text" value="<?php if(isset($profile['user_address_line_1'])) {echo $profile['user_address_line_1'];} ?>" name="address"></div>
                                    <!-- .input-item -->
                                </div>
                              
                                <div class="col-md-6">
                                    <div class="input-item input-with-label"><label class="input-item-label">City <span class="text-danger">*</span></label><input class="input-bordered" type="text" value="<?php if(isset($profile['user_city'])) {echo $profile['user_city'];} ?>" name="city"></div>
                                    <!-- .input-item -->
                                </div>
                                <!-- .col -->
                                <div class="col-md-6">
                                <div class="input-item input-with-label">
  <label class="input-item-label">State <span class="text-danger">*</span></label>
  <select class="input-bordered" name="state">
    <?php
      $states = array(
        'Abia', 'Adamawa', 'Akwa Ibom', 'Anambra', 'Bauchi', 'Bayelsa', 'Benue', 'Borno', 'Cross River', 'Delta', 'Ebonyi', 'Edo', 'Ekiti', 'Enugu', 'Gombe', 'Imo', 'Jigawa', 'Kaduna', 'Kano', 'Katsina', 'Kebbi', 'Kogi', 'Kwara', 'Lagos', 'Nasarawa', 'Niger', 'Ogun', 'Ondo', 'Osun', 'Oyo', 'Plateau', 'Rivers', 'Sokoto', 'Taraba', 'Yobe', 'Zamfara', 'FCT'
      );
      
      foreach ($states as $state) {
        $selected = (isset($profile['user_state']) && $profile['user_state'] == $state) ? 'selected' : '';
        echo "<option value='$state' $selected>$state</option>";
      }
    ?>
  </select>
</div>
                                    <!-- .input-item -->
                                </div>
                                <!-- .col -->
                                <div class="col-md-6">
                                    <div class="input-item input-with-label"><label class="input-item-label">Country <span class="text-danger">*</span></label><input class="input-bordered" type="text" value="<?php if(isset($profile['user_country'])){echo $profile['user_country'];} ?>" name="country"></div>
                                    <!-- .input-item -->
                                </div>
                                <!-- .col -->
                                <div class="col-md-6">
                                    <div class="input-item input-with-label"><label class="input-item-label">Zip Code <span class="text-danger">*</span></label><input class="input-bordered" type="text" value="<?php if(isset($profile['user_zip_code'])) {echo $profile['user_zip_code'];} ?>" name="zip-code"></div>
                                    <!-- .input-item -->
                                </div>
                                <!-- .col -->
                            </div>
                            <!-- .row -->
                        </div>
                        <!-- .step-fields -->
                    </div>
                    <div class="form-step form-step2">
                        <div class="form-step-head card-innr">
                            <div class="step-head">
                                <div class="step-number">02</div>
                                <div class="step-head-text">
                                    <h4>Document Upload</h4>
                                    <p>To verify your identity, please upload a recent Nepa Bill</p>
                                </div>
                            </div>
                        </div>
                        <!-- .step-head -->
                         <div class="form-step form-step2">
                            <!-- existing form elements -->
                            <div class="form-step-fields card-innr">
                                <!-- existing form elements -->
                                <div class="form-group">
                        <label for="file-input">Select a file:</label>
                        <input type="file" class="form-control-file" id="file-input" name="file">
                    </div>
            <!-- existing form elements -->
                        </div>
                        <!-- existing form elements -->
                    </div>
                    </div>   
                    
                    <div class="form-step form-step-final">
                        <div class="form-step-fields card-innr">
                            <div class="input-item"><input class="input-checkbox input-checkbox-md" id="term-condition" type="checkbox" name="toc"><label for="term-condition">I have read the <a href="#">Terms of Condition</a> and <a href="#">Privary Policy.</a></label></div>
                            <div class="input-item"><input class="input-checkbox input-checkbox-md" id="info-currect" type="checkbox" name="agree"><label for="info-currect">All the personal information I have entered is correct.</label></div>
                            <div class="gaps-1x"></div><button name="verify-kyc" class="btn btn-primary">Process for Verify</button></div>
                        <!-- .step-fields -->
                    </div>
                </div>
</form>
                <!-- .card -->
            </div>
        </div>
    </div>
    <!-- .container -->
</div>
<!-- .page-content -->
<?php 
require_once './footer.php';
?>