<?php
// Start the session
session_start();

// Check if the user is logged in
if (isset($_SESSION['user'])) {
  require_once './config/database.php';
  require_once './functions/function.php';
  // Get the user details from the database
  $user_id = $_SESSION['user'];

  $user = getUser($user_id);
  $wallet = getWallet($user_id);
  $profile = getProfile($user_id);
  $transaction = getTransactions($user_id);
 

} else {
    header("Location: ./login.php");
}

$title = 'KYC Application';

?>

<!DOCTYPE html>
<html lang="en" class="js">

<head>
    <meta charset="utf-8">
    <meta name="author" content="Dasodhub">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="Pay Bills Seamlessly With the Trilspay App">
    <!-- Fav Icon -->
    <link rel="shortcut icon" href="./assets/images/favicon1.png">
    
    <!-- Site Title  -->
    <title><?php echo $title ?> - Pay Bills Seamlessly with Trilspay</title>
    <!-- Vendor Bundle CSS -->
    <link rel="stylesheet" href="assets/css/vendor.bundle49f7.css?ver=104">
    <!-- Custom styles for this template -->
    <link rel="stylesheet" href="assets/css/style.css" id="layoutstyle">
    
    <script>
        (function(i, s, o, g, r, a, m) {
            i['GoogleAnalyticsObject'] = r;
            i[r] = i[r] || function() {
                (i[r].q = i[r].q || []).push(arguments)
            }, i[r].l = 1 * new Date();
            a = s.createElement(o), m = s.getElementsByTagName(o)[0];
            a.async = 1;
            a.src = g;
            m.parentNode.insertBefore(a, m)
        })(window, document, 'script', '../../www.google-analytics.com/analytics.js', 'ga');
        ga('create', 'UA-91615293-2', 'auto');
        ga('send', 'pageview');
    </script>
</head>



<?php 
require_once './topbar.php';
?>
<!-- .topbar-wrap -->
<div class="page-header page-header-kyc">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-8 col-xl-7 text-center">
                <h2 class="page-title">Begin your ID-Verification</h2>
                <p class="large">Verify your identity to participate in tokensale.</p>
            </div>
        </div>
    </div>
    <!-- .container -->
</div>
<!-- .page-header -->
<div class="page-content">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10 col-xl-9">
                <div class="kyc-status card mx-lg-4">
                    <div class="card-innr">
                        <div class="status status-thank px-md-5">
                            <div class="status-icon"><em class="ti ti-check"></em></div><span class="status-text large text-dark">You have completed the process of KYC</span>
                            <p class="px-md-5">We are still waiting for your identity verification. Once our team verified your indentity, you will be notified by email. You can also check your KYC compliance status from your profile page.</p><a href="./profile" class="btn btn-primary">Back to Profile</a></div>
                    </div>
                </div>
                <!-- .card -->
                <p class="text-light text-center mgmt-1x">If you have any question, please contact our support team <a href="#">info@tokenwiz.com</a>.</p>
                <div class="gaps-1x"></div>
                <div class="gaps-3x d-none d-sm-block"></div>
            </div>
        </div>
    </div>
    <!-- .container -->
</div>
<!-- .page-content -->
<?php 
require_once './footer.php';
?>