<?php
// Start the session
session_start();

// Check if the user is logged in
if (isset($_SESSION['user'])) {
  require_once './config/database.php';
  require_once './functions/function.php';
  // Get the user details from the database
  $user_id = $_SESSION['user'];

  $user = getUser($user_id);
  $wallet = getWallet($user_id);
  $profile = getProfile($user_id);
  $transaction = getTransactions($user_id);
 

} else {
    header("Location: ./login.php");
}

$title = 'Profile';

?>

<!DOCTYPE html>
<html lang="en" class="js">

<head>
    <meta charset="utf-8">
    <meta name="author" content="Dasodhub">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="Pay Bills Seamlessly With the Trilspay App">
    <!-- Fav Icon -->
    <link rel="shortcut icon" href="./assets/images/favicon1.png">
    
    <!-- Site Title  -->
    <title><?php echo $title ?> - Pay Bills Seamlessly with Trilspay</title>
    <!-- Vendor Bundle CSS -->
    <link rel="stylesheet" href="assets/css/vendor.bundle49f7.css?ver=104">
    <!-- Custom styles for this template -->
    <link rel="stylesheet" href="assets/css/style.css" id="layoutstyle">
    
    <script>
        (function(i, s, o, g, r, a, m) {
            i['GoogleAnalyticsObject'] = r;
            i[r] = i[r] || function() {
                (i[r].q = i[r].q || []).push(arguments)
            }, i[r].l = 1 * new Date();
            a = s.createElement(o), m = s.getElementsByTagName(o)[0];
            a.async = 1;
            a.src = g;
            m.parentNode.insertBefore(a, m)
        })(window, document, 'script', '../../www.google-analytics.com/analytics.js', 'ga');
        ga('create', 'UA-91615293-2', 'auto');
        ga('send', 'pageview');
    </script>
</head>







<?php 
require_once './topbar.php';





//----------------------------------------------------------------
//CHANGE USER PASSWORD

if(isset($_POST['change-password'])) {
    include './config/database.php';
    require_once './functions/validation.php';

    //VALIDATE AND SANITIZE USER INPUT

    $oldPass = filter_var($_POST['old-pass'], FILTER_SANITIZE_SPECIAL_CHARS);

    $newPass = filter_var($_POST['new-pass'], FILTER_SANITIZE_SPECIAL_CHARS);
}





















?>



<!-- .topbar-wrap -->
<div class="page-content">
    <div class="container">
        <div class="row">
            <div class="main-content col-lg-8">
            <?php
    if (isset($_GET['error'])) {
        $errorMessage = urldecode($_GET['error']);
        echo "<div class='alert alert-danger'>$errorMessage <button type='button' class='close' data-dismiss='alert' aria-label='Close'><span aria-hidden='true'>&times;</span></button></div>";
    }

    if (isset($_GET['message']) || isset($_GET['success'])) {
        if (isset($_GET['message'])) {
            $message = urldecode($_GET['message']);
            echo "<div class='alert alert-success'>$message <button type='button' class='close' data-dismiss='alert' aria-label='Close'><span aria-hidden='true'>&times;</span></button></div>";
        } elseif (isset($_GET['success'])) {
            $message = urldecode($_GET['success']);
            echo "<div class='alert alert-success'>$message <button type='button' class='close' data-dismiss='alert' aria-label='Close'><span aria-hidden='true'>&times;</span></button></div>";
        }
    }
?>
                <div class="content-area card">
                    <div class="card-innr">
                        <div class="card-head">
                            <h4 class="card-title">Profile Details</h4>
                        </div>
                        <ul class="nav nav-tabs nav-tabs-line" role="tablist">
                            <li class="nav-item"><a class="nav-link active" data-toggle="tab" href="#personal-data">Personal Data</a></li>
                            <!-- <li class="nav-item"><a class="nav-link" data-toggle="tab" href="#settings">Transaction Pin</a></li> -->
                            <li class="nav-item"><a class="nav-link" data-toggle="tab" href="#password">Password</a></li>
                        </ul>
                        <!-- .nav-tabs-line -->
                        <div class="tab-content" id="profile-details">
                            <div class="tab-pane fade show active" id="personal-data">
                                <form action="./functions/validation.php" method="post">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <input type="text" name="user_id" hidden value="<?php echo $user['user_id']; ?>">
                                            <div class="input-item input-with-label"><label for="full-name" class="input-item-label">Username</label><input class="input-bordered" type="text" id="full-name" name="username" value="<?php echo $user['username']?>" disabled></div>
                                            <!-- .input-item -->
                                        </div>
                                        
                                        <div class="col-md-6">
                                            <div class="input-item input-with-label"><label for="email-address" class="input-item-label">Email Address</label><input class="input-bordered" type="text" id="email-address" name="email-address" value="<?php echo $user['email']; ?>" disabled></div>
                                            <!-- .input-item -->
                                        </div>
                                        <div class="col-md-6">
                                            <div class="input-item input-with-label"><label for="full-name" class="input-item-label">First name</label><input class="input-bordered" type="text" id="full-name" name="firstname" value="<?php
                                            if (isset($profile['user_first_name'])) {
                                                echo $profile['user_first_name'];
                                            } else {
                                                // Display a blank space
                                                echo "&nbsp;";
                                            }
                                            ?>" ></div>
                                            <!-- .input-item -->
                                        </div>
                                        <div class="col-md-6">
                                            <div class="input-item input-with-label"><label for="full-name" class="input-item-label">Last name</label><input class="input-bordered" type="text" id="full-name" name="lastname" value="<?php
                                            if (isset($profile['user_last_name'])) {
                                                echo $profile['user_last_name'];
                                            } else {
                                                // Display a blank space
                                                echo "&nbsp;";
                                            }
                                            ?>" ></div>
                                            <!-- .input-item -->
                                        </div>
                                        <div class="col-md-6">
                                            <div class="input-item input-with-label"><label for="mobile-number" class="input-item-label">Mobile Number</label><input class="input-bordered" type="tel" id="mobile-number" name="phone" value="<?php
                                            if (isset($profile['user_phone_number'])) {
                                                echo $profile['user_phone_number'];
                                            } else {
                                                // Display a blank space
                                                echo "&nbsp;";
                                            }
                                            ?>"></div>
                                                                                        <!-- .input-item -->
                                        </div>
                                        <div class="col-md-6">
                                            <div class="input-item input-with-label"><label for="date-of-birth" class="input-item-label">Date of Birth</label><input class="input-bordered date-picker-dob" type="text" id="date-of-birth" name="dob" value="<?php
                                            if (isset($profile['date_of_birth'])) {
                                                echo $profile['date_of_birth'];
                                            } else {
                                                // Display a blank space
                                                echo "&nbsp;";
                                            }
                                            ?>"></div>
                                            <!-- .input-item -->
                                        </div>
                                        <!-- .col -->
                                        <div class="col-md-6">
                                            <div class="input-item input-with-label"><label for="nationality" class="input-item-label">Nationality</label><select class="select-bordered select-block" name="nationality" id="nationality" disabled><option value="us"><?php echo $profile['user_country'] ?></option><option value="uk">United KingDom</option><option value="fr">France</option><option value="ch">China</option><option value="cr">Czech Republic</option><option value="cb">Colombia</option></select></div>
                                            <!-- .input-item -->
                                        </div>
                                        <!-- .col -->

                                        
                                        
                                        
                                        <div class="col-md-6">
                                            <div class="input-item input-with-label"><label for="address-1" class="input-item-label">State</label><input class="input-bordered" type="text" id="state" name="state" value="<?php
                                            if (isset($profile['user_state'])) {
                                                echo $profile['user_state'];
                                            } else {
                                                // Display a blank space
                                                echo "&nbsp;";
                                            }
                                            ?>"></div>
                                                                                        <!-- .input-item -->
                                        </div>


                                        
                                        <div class="col-md-6">
                                            <div class="input-item input-with-label"><label for="city" class="input-item-label">City</label><input class="input-bordered" type="text" id="city" name="city" value="<?php
                                            if (isset($profile['user_city'])) {
                                                echo $profile['user_city'];
                                            } else {
                                                // Display a blank space
                                                echo "&nbsp;";
                                            }
                                            ?>"></div>
                                                                                        <!-- .input-item -->
                                        </div>



                                        <div class="col-md-6">
                                            <div class="input-item input-with-label"><label for="address-1" class="input-item-label">Address</label><input class="input-bordered" type="text" id="address-1" name="address" value="<?php
                                            if (isset($profile['user_address_line_1'])) {
                                                echo $profile['user_address_line_1'];
                                            } else {
                                                // Display a blank space
                                                echo "&nbsp;";
                                            }
                                            ?>"></div>
                                                                                        <!-- .input-item -->
                                        </div>

                                        <div class="col-md-6">
                                            <div class="input-item input-with-label"><label for="zip-code" class="input-item-label">Zip Code</label><input class="input-bordered" type="text" id="zip-code" name="zip-code" value="<?php
                                            if (isset($profile['user_zip_code'])) {
                                                echo $profile['user_zip_code'];
                                            } else {
                                                // Display a blank space
                                                echo "&nbsp;";
                                            }
                                            ?>"></div>
                                                                                        <!-- .input-item -->
                                        </div>




                                        <!-- <div class="col-md-6">
                                            <div class="input-item input-with-label"><label for="transaction-pin" class="input-item-label">Transaction Pin</label><input class="input-bordered" type="text" id="transaction-pin" name="transaction-pin" value="<?php
                                            //if (isset($profile['user_transaction_pin'])) {
                                                //echo $profile['user_transaction_pin'];
                                            //} else {
                                                // Display a blank space
                                                //echo "&nbsp;";
                                            //}
                                            ?>"></div>
                                                                                    
                                        </div> -->



                                    </div>
                                    <!-- .row -->
                                    <div class="gaps-1x"></div>
                                    <!-- 10px gap -->
                                    <div class="d-sm-flex justify-content-between align-items-center"><button name="update-profile" class="btn btn-primary">Update Profile</button>
                                        <div class="gaps-2x d-sm-none"></div>
                                    
                                        

                                    </div>
                                        
                                </form>
                                <!-- form -->
                            </div>
                            <!-- .tab-pane -->
                            <!-- <div class="tab-pane fade" id="settings">
                                <div class="pdb-1-5x">
                                    <h5 class="card-title card-title-sm text-dark">Security Settings</h5>
                                </div>
                                <div class="input-item"><input type="checkbox" class="input-switch input-switch-sm" id="save-log" checked><label for="save-log">Save my Activities Log</label></div>
                                <div class="input-item"><input type="checkbox" class="input-switch input-switch-sm" id="pass-change-confirm"><label for="pass-change-confirm">Confirm me through email before password change</label></div>
                                <div class="pdb-1-5x">
                                    <h5 class="card-title card-title-sm text-dark">Manage Notification</h5>
                                </div>
                                <div class="input-item"><input type="checkbox" class="input-switch input-switch-sm" id="latest-news" checked><label for="latest-news">Notify me by email about sales and latest news</label></div>
                                <div class="input-item"><input type="checkbox" class="input-switch input-switch-sm" id="activity-alert" checked><label for="activity-alert">Alert me by email for unusual activity.</label></div>
                                <div class="gaps-1x"></div>
                                <div class="d-flex justify-content-between align-items-center"><span></span><span class="text-success"><em class="ti ti-check-box"></em> Setting has been updated</span></div>
                            </div> -->
                            <!-- .tab-pane -->
                           
                            <div class="tab-pane fade" id="password">
                             <form action="./functions/validation.php?userId=<?php echo $user['user_id']; ?>" method="post">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="input-item input-with-label"><label for="old-pass" class="input-item-label">Old Password</label><input class="input-bordered" type="text" id="old-pass" name="old_password"></div>
                                        <!-- .input-item -->
                                    </div>
                                    <!-- .col -->
                                </div>
                                <!-- .row -->
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="input-item input-with-label"><label for="new-pass" class="input-item-label">New Password</label><input class="input-bordered" type="text" id="new-pass" name="new_password"></div>
                                        <!-- .input-item -->
                                    </div>
                                    <!-- .col -->
                                    <div class="col-md-6">
                                        <div class="input-item input-with-label"><label for="confirm-pass" class="input-item-label">Confirm New Password</label><input class="input-bordered" type="text" id="confirm-pass" name="confirm_password"></div>
                                        <!-- .input-item -->
                                    </div>
                                    <!-- .col -->
                                </div>
                                <!-- .row -->
                                <div class="note note-plane note-info pdb-1x"><em class="fas fa-info-circle"></em>
                                    <p>Password should be minmum 8 letter and include lower and uppercase letter and special characters.</p>
                                </div>
                                <div class="gaps-1x"></div>
                                <!-- 10px gap -->
                                <div class="d-sm-flex justify-content-between align-items-center"><button class="btn btn-primary" name="changePassword">Change Password</button>
                                    <div class="gaps-2x d-sm-none"></div></div>
                                    </form>
                            </div>
                            
                            <!-- .tab-pane -->
                        </div>
                        <!-- .tab-content -->
                    </div>
                    <!-- .card-innr -->
                </div>
                
            </div>
            <!-- .col -->
            <div class="aside sidebar-right col-lg-4">
                <div class="account-info card">
                    <div class="card-innr">
                        <h6 class="card-title card-title-sm">Your Account Status</h6>
                        <ul class="btn-grp">
                            <?php 
                            if ($profile['is_email_verified'] == 1) {
                                // Email is verified
                                echo '<li><a href="#" class="btn btn-auto btn-xs btn-success">Email Verified</a></li>';
                            } else {
                                // Email is not verified
                                echo '<li><a href="#" class="btn btn-auto btn-xs btn-danger">Email Not Verified</a></li>';
                            }
                            ?>
                            <?php if($profile['is_kyc_verified']!= 1) {?>
                                <li><a href="#" class="btn btn-auto btn-xs btn-warning">KYC Not Verified</a></li>
                            <?php } else {?>
                                <li><a href="#" class="btn btn-auto btn-xs btn-success">KYC Verified</a></li>
                            <?php }?>
                        </ul>
                        <div class="gaps-2-5x"></div>
                        <h6 class="card-title card-title-sm">Receiving Account</h6>
                        <?php
if ($profile['is_email_verified'] === 1 || $profile['is_kyc_verified'] === 1) {
    $accountNumber = isset($profile['account_number']) ? $profile['account_number'] : "Withdrawal Account Not Set";
    echo "<div class='d-flex justify-content-between'><span><span>$accountNumber</span> <em class='fas fa-info-circle text-exlight' data-toggle='tooltip' data-placement='bottom' title='Withdrawal Account'></em></span><a href='#' data-toggle='modal' data-target='#edit-wallet' class='link link-ucap'>Edit</a></div></div>";
} else {
    echo "Please verify your email and KYC to set withdrawal details.";
}
?>
                </div>
                <div class="referral-info card">
                    <div class="card-innr">
                        <h6 class="card-title card-title-sm">Earn with Referral</h6>
                        <p class=" pdb-0-5x">Invite your friends &amp; family and receive a <strong><span class="text-primary">bonus - NGN500</span> for every valid user referred.</strong></p>
                        <div class="copy-wrap mgb-0-5x"><span class="copy-feedback"></span><em class="fas fa-link"></em><input type="text" class="copy-address" value="<?php echo $site_url. '/register?ref='. $user['referral_code'];?>" disabled><button class="copy-trigger copy-clipboard" data-clipboard-text="<?php echo $site_url. '/register?ref='. $user['referral_code'];?>"><em class="ti ti-files"></em></button></div>
                        <!-- .copy-wrap -->
                    </div>
                </div>
                <div class="kyc-info card">
                    <?php
      
      $kyc_query = "SELECT * FROM kyc WHERE user_id = :user_id";
$stmt = $pdo->prepare($kyc_query);
$stmt->bindParam(':user_id', $user['user_id']);
$stmt->execute();
$kyc_row = $stmt->fetch();

if (!$kyc_row) {
    echo '<div class="card-innr">
                <h6 class="card-title card-title-sm">Identity Verification - KYC</h6>
                <p>To comply with regulation, user will have to go through indentity verification.</p>
                <p class="lead text-light pdb-0-5x">You have not submitted your KYC application to verify your identity.</p><a href="./kyc-application" class="btn btn-primary btn-block">Click to Proceed</a>
                <h6 class="kyc-alert text-danger">* KYC verification required to withdraw and fund wallet</h6>
            </div>';
} elseif ($kyc_row['status'] != 'approved') {
    echo '<div class="card-innr">
                <h6 class="card-title card-title-sm">Identity Verification - KYC</h6>
                <p>To comply with regulation, user will have to go through indentity verification.</p>
                <p class="lead text-light pdb-0-5x">Your KYC application is pending approval.</p>
                <h6 class="kyc-alert text-danger">* KYC verification required to withdraw and fund wallet</h6>
            </div>';
} else {
    // KYC is approved, do nothing
}

?>
                </div>
            </div>
            <!-- .col -->
        </div>
        <!-- .container -->
    </div>
    <!-- .container -->
</div>
<!-- .page-content -->
<?php 



// ----------------------------------------------------------------
//UPDATE USER PROFILE SETTING
if(isset($_POST['update-profile'])) {
    include './config/database.php';
    require_once './functions/validation.php';


    $phone = filter_var($_POST['phone'], FILTER_SANITIZE_SPECIAL_CHARS);

    $dob = filter_var($_POST['dob'], FILTER_SANITIZE_SPECIAL_CHARS);

    // Call the function with reference
if (!isValidNigerianPhoneNumber($phone, $errorMessage)) {
    $message = $errorMessage;
}


// Call the function with reference
if (!isValidDateOfBirth($dob, $errorMessage)) {
    $message =  $errorMessage;
} 



// Date of birth and phone number are valid, update the user_profile
try {
    $user_id = $user['user_id'];

    // Assuming you have a connection object ($conn)
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $stmt = $pdo->prepare("UPDATE user_profiles SET user_phone_number = :phone, date_of_birth = :dob WHERE user_id = :user_id");

    $stmt->bindParam(':phone', $phone);
    $stmt->bindParam(':dob', $dob);
    $stmt->bindParam(':user_id', $user_id);
    $stmt->execute();
    print_r($_POST);
    $message = "User profile updated successfully";

} catch (PDOException $e) {
    $message = "Error updating user_profile: " . $e->getMessage();
}
 echo $message;

}


//----------------------------------------------------------------
//CHANGE USER PASSWORD

if(isset($_POST['change-password'])) {
    include './config/database.php';
    require_once './functions/validation.php';

    //VALIDATE AND SANITIZE USER INPUT

    $oldPass = filter_var($_POST['old-pass'], FILTER_SANITIZE_SPECIAL_CHARS);

    $newPass = filter_var($_POST['new-pass'], FILTER_SANITIZE_SPECIAL_CHARS);
}





































require_once './footer.php';

?>