<?php

if(isset($_GET['email']) && isset($_GET['token'])) {
    require_once './config/database.php';
    $email = filter_var($_GET['email'], FILTER_SANITIZE_EMAIL);
    $token = filter_var($_GET['token'], FILTER_SANITIZE_SPECIAL_CHARS);

    //print_r($_GET);
    if(filter_var($email, FILTER_VALIDATE_EMAIL)) {
        // Email is valid
        try {
            // Create a new database connection
            //$conn = new PDO("mysql:host=localhost;dbname=mydb", "username", "password");

            // Set PDO error mode to exception
            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

            // Prepare and execute the SQL query
            $stmt = $pdo->prepare("SELECT * FROM users WHERE email = :email AND forget_password = :token");
            $stmt->execute(['email' => $email, 'token' => $token]);

            // Fetch the result
            $row = $stmt->fetch(PDO::FETCH_ASSOC);

            if ($row) {
                // Token is valid, proceed with password reset
                //print_r($row);
            } else {
                // Token is not valid or password reset request not found
                // Return user to login page
                //header('Location:./login');
            }

            // Close the database connection
            $pdo = null;

        } catch(PDOException $e) {
            // Handle the error
            echo "Error: ". $e->getMessage();
        }
    } else {
        // Email is not valid
        // Return user to login page
        //header('Location:./reset_password');
    }

} else {
    //return user to login page
    //header('Location:./reset_password');
}
?>



<?php 

if (isset($_POST['change'])) {
    $password = trim($_POST['password']);
    $confirmPassword = trim($_POST['confirm-password']);
    $email = filter_var($_GET['email'], FILTER_SANITIZE_EMAIL);
    $token = filter_var($_GET['token'], FILTER_SANITIZE_SPECIAL_CHARS);

    // Sanitize input
    $password = filter_var($password, FILTER_SANITIZE_SPECIAL_CHARS);
    $confirmPassword = filter_var($confirmPassword, FILTER_SANITIZE_SPECIAL_CHARS);

    // Validate input
    if (empty($password) || empty($confirmPassword)) {
        $error = "Password or confirm password are empty";
    } else if (strlen($password) < 8) {
        $error = "Password is shorter than 8 characters";
    } else if (strlen($confirmPassword) < 8) {
        $error = "Confirm password is shorter than 8 characters";
    } else if (!preg_match("#[A-Z]+#", $password)) {
        $error = "Password doesn't contain an uppercase character";
    } else if (!preg_match("#[a-z]+#", $password)) {
        $error = "Password doesn't contain a lowercase character";
    } else if (!preg_match("#[0-9]+#", $password)) {
        $error = "Password doesn't contain a number";
    } else if (!preg_match("#[\!\$\%\^\&\*\+\=\-\_\@\#\~\`\{\}\[\]\|]+#", $password)) {
        $error = "Password doesn't contain a symbol";
    } else if ($password!== $confirmPassword) {
        $error = "Password and confirm password don't match";
    } else {
        // Password is valid and matches confirm password, proceed with updating password
        // Hash the password
        $hashedPassword = password_hash($password, PASSWORD_DEFAULT);

        // Create a new database connection
        $conn = new PDO("mysql:host=localhost;dbname=mydb", "username", "password");

        // Set PDO error mode to exception
        $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        // Prepare and execute the SQL query
        $sql = "UPDATE users SET password = :password, forget_password = NULL WHERE email = :email AND forget_password = :token";
        $stmt = $conn->prepare($sql);
        $stmt->execute([':password' => $hashedPassword, ':email' => $email, ':token' => $token]);

        // Close the database connection
        $conn = null;

        $success = "Password has been updated";
        header('Location: ./login');
    }
}


?>

<!DOCTYPE html>
<html lang="zxx" class="js">
<?php require_once './config/config.php'; ?>
<head>
    <meta charset="utf-8">
    <meta name="author" content="Softnio">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="Fully featured and complete ICO Dashboard template for ICO backend management.">
    <!-- Fav Icon -->
    <link rel="shortcut icon" href="./assets/images/favicon1.png">
    <!-- Site Title  -->
    <title>TokenWiz - ICO User Dashboard Admin Template</title>
    <!-- Vendor Bundle CSS -->
    <link rel="stylesheet" href="assets/css/vendor.bundle49f7.css?ver=104">
    <!-- Custom styles for this template -->
    <link rel="stylesheet" href="assets/css/style49f7.css?ver=104" id="layoutstyle">
    <script>
        (function(i, s, o, g, r, a, m) {
            i['GoogleAnalyticsObject'] = r;
            i[r] = i[r] || function() {
                (i[r].q = i[r].q || []).push(arguments)
            }, i[r].l = 1 * new Date();
            a = s.createElement(o), m = s.getElementsByTagName(o)[0];
            a.async = 1;
            a.src = g;
            m.parentNode.insertBefore(a, m)
        })(window, document, 'script', '../../www.google-analytics.com/analytics.js', 'ga');
        ga('create', 'UA-91615293-2', 'auto');
        ga('send', 'pageview');
    </script>
</head>

<body class="page-ath">
    <div class="page-ath-wrap">
        <div class="page-ath-content">
        <div class="page-ath-header">
                <a href="index" class="page-ath-logo"><img src="./assets/images/logo-dark1x.png" srcset="./assets/images/logo-dark1x.png" alt="logo"></a>
            </div>
            <div class="page-ath-form">
            <?php
                 //CODE TO RETURN EITHER  AN ERROR OR SUCCESS MESSAGE
                    if (isset($error)) {
                        
                        echo "<div class='alert alert-danger'>$error</div>";
                    }

                    if (isset($success)) {
                       
                        echo "<div class='alert alert-success'>$success</div>";
                    }

                    //END OF CODE TO RETURN EITHER ERROR OR SUCCESS MESSAGE
                    ?>
                <h2 class="page-ath-heading">Change password <span>If you forgot your password, well, then enter your new password.</span></h2>
                <form action="" method="post">
                    <div class="input-item"><input type="password" placeholder="Your New Password" class="input-bordered" name="password"></div>
                    <div class="input-item"><input type="password" placeholder="Confirm Passsword" class="input-bordered" name="confirm-password"></div>
                    <div class="d-flex justify-content-between align-items-center">
                        <div><button class="btn btn-primary btn-block" name="change">Change Password</button></div>
                       
                    </div>
                    <div class="gaps-2x"></div>
                </form>
            </div>
            <div class="page-ath-footer">
                <ul class="footer-links">
                    <li><a href="regular-page">Privacy Policy</a></li>
                    <li><a href="regular-page">Terms</a></li>
                    <li>&copy; <?php echo date('Y') . ' ' . $site_name; ?></li>
                </ul>
            </div>
        </div>
        <div class="page-ath-gfx">
            <div class="w-100 d-flex justify-content-center">
                <div class="col-md-8 col-xl-5"><img src="./assets/images/forget.png" alt="image"></div>
            </div>
        </div>
    </div>
    <!-- JavaScript (include all script here) -->
    <script src="assets/js/jquery.bundle49f7.js?ver=104"></script>

</body>

</html>
