<?php
// Start the session
session_start();

// Check if the user is logged in
if (isset($_SESSION['user'])) {
  require_once './config/database.php';
  require_once './functions/function.php';
  // Get the user details from the database
  $user_id = $_SESSION['user'];

  $user = getUser($user_id);
  $wallet = getWallet($user_id);
  $profile = getProfile($user_id);
  $transaction = getTransactions($user_id);
 

} else {
    header("Location: ./login.php");
}

$title = 'Services';

?>

<!DOCTYPE html>
<html lang="en" class="js">

<head>
    <meta charset="utf-8">
    <meta name="author" content="Dasodhub">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="Pay Bills Seamlessly With the Trilspay App">
    <!-- Fav Icon -->
    <link rel="shortcut icon" href="./assets/images/favicon1.png">
    
    <!-- Site Title  -->
    <title><?php echo $title ?> - Pay Bills Seamlessly with Trilspay</title>
    <!-- Vendor Bundle CSS -->
    <link rel="stylesheet" href="assets/css/vendor.bundle49f7.css?ver=104">
    <!-- Custom styles for this template -->
    <link rel="stylesheet" href="assets/css/style.css" id="layoutstyle">
    
    <script>
        (function(i, s, o, g, r, a, m) {
            i['GoogleAnalyticsObject'] = r;
            i[r] = i[r] || function() {
                (i[r].q = i[r].q || []).push(arguments)
            }, i[r].l = 1 * new Date();
            a = s.createElement(o), m = s.getElementsByTagName(o)[0];
            a.async = 1;
            a.src = g;
            m.parentNode.insertBefore(a, m)
        })(window, document, 'script', '../../www.google-analytics.com/analytics.js', 'ga');
        ga('create', 'UA-91615293-2', 'auto');
        ga('send', 'pageview');
    </script>
</head>



<?php 
require_once './topbar.php';



?>
    <!-- .topbar-wrap -->
    <div class="page-content">
        <div class="container">
        <?php
                 //CODE TO RETURN EITHER  AN ERROR OR SUCCESS MESSAGE
                    if (isset($_GET['error'])) {
                        $errorMessage = urldecode($_GET['error']);
                        echo "<div class='alert alert-danger'>$errorMessage</div>";
                    }

                    if (isset($_GET['message'])) {
                        $message = urldecode($_GET['message']);
                        echo "<div class='alert alert-success'>$message</div>";
                    }

                    //END OF CODE TO RETURN EITHER ERROR OR SUCCESS MESSAGE
                    ?>
            <div class="card"></div>
            <!-- .card -->
            <div class="col-lg-12">
                <div class="content-area card">
                    <div class="card-innr card-innr-fix">
                        <div class="card-head">
                            <h6 class="card-title">Add New Service</h6>
                        </div>
                        <div class="gaps-1x"></div>
                        <!-- .gaps -->
                        <form action="./functions/validation.php" method="post">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="input-item input-with-label"><label class="input-item-label text-exlight">Service Name</label><input class="input-bordered" type="text" name="service_name"><span class="input-note">Please enter Your Service Name</span></div>
                                </div>
                                <div class="col-md-6">
                                    <div class="input-item input-with-label"><label class="input-item-label text-exlight">Service Code</label><input class="input-bordered" type="text"  name="serviceID"><span class="input-note">Enter the service Id here for the service</span></div>
                                </div>

                            </div>
                            
                            
                            <div class="gaps-1x"></div><button class="btn btn-primary" name="add-service">Add Service</button>
                        </form>
                    </div>
                    <!-- .card-innr -->
                </div>
                <!-- .card -->


            </div>

        </div>
        <!-- .container -->
    </div>
    <!-- .page-content -->
 <?php 
 
 require_once './footer.php';
 
 ?>