<?php
// Start the session
session_start();

// Check if the user is logged in
if (isset($_SESSION['user'])) {
  require_once './config/database.php';
  require_once './functions/function.php';
  // Get the user details from the database
  $user_id = $_SESSION['user'];

  $user = getUser($user_id);
  $wallet = getWallet($user_id);
  $profile = getProfile($user_id);
  $transaction = getTransactions($user_id);
 

} else {
    header("Location: ./login.php");
}

$title = 'Settings';

?>

<!DOCTYPE html>
<html lang="en" class="js">

<head>
    <meta charset="utf-8">
    <meta name="author" content="Dasodhub">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="Pay Bills Seamlessly With the Trilspay App">
    <!-- Fav Icon -->
    <link rel="shortcut icon" href="./assets/images/favicon1.png">
    
    <!-- Site Title  -->
    <title><?php echo $title ?> - Pay Bills Seamlessly with Trilspay</title>
    <!-- Vendor Bundle CSS -->
    <link rel="stylesheet" href="assets/css/vendor.bundle49f7.css?ver=104">
    <!-- Custom styles for this template -->
    <link rel="stylesheet" href="assets/css/style.css" id="layoutstyle">
    
    <script>
        (function(i, s, o, g, r, a, m) {
            i['GoogleAnalyticsObject'] = r;
            i[r] = i[r] || function() {
                (i[r].q = i[r].q || []).push(arguments)
            }, i[r].l = 1 * new Date();
            a = s.createElement(o), m = s.getElementsByTagName(o)[0];
            a.async = 1;
            a.src = g;
            m.parentNode.insertBefore(a, m)
        })(window, document, 'script', '../../www.google-analytics.com/analytics.js', 'ga');
        ga('create', 'UA-91615293-2', 'auto');
        ga('send', 'pageview');
    </script>
</head>
 
 <?php 
    require_once './topbar.php';
  ?>
  
  <!-- .topbar-wrap -->
  <div class="page-content">
        <div class="container">
            <div class="card"></div>
            <!-- .card -->


            <div class="col-lg-12">
                <div class="content-area card">
                    <div class="card-innr">
                        <div class="card-head">
                            <h3 class="card-title">Discount (%) Settings</h3>
                        </div>
                        <div class="gaps-1x"></div>
                        <!-- .gaps -->
                        <h6 class="card-title">Airtime Discount (%) Settings</h6>
                        <div class="row">
                        
                            <div class="col-xl-3 col-sm-6">
                                <div class="input-item input-with-label"><label class="input-item-label ucap text-exlight">Mtn Airtime Discount</label><input class="input-bordered" type="text" name="mtn-airtime"><span class="input-note">Kindly enter the % discount to give mtn users.</span></div>
                            </div>
                            <div class="col-xl-3 col-sm-6">
                                <div class="input-item input-with-label"><label class="input-item-label ucap text-exlight">Glo Airtime Discount</label><input class="input-bordered" type="text" name="glo-airtime"><span class="input-note">Kindly enter the % discount to give glo users.</span></div>
                            </div>
                            <div class="col-xl-3 col-sm-6">
                                <div class="input-item input-with-label"><label class="input-item-label ucap text-exlight">Airtel Airtime Discount</label><input class="input-bordered" type="text" name="airtel-airtime"><span class="input-note">Kindly enter the % discount to give airtel users.</span></div>
                            </div>
                            <div class="col-xl-3 col-sm-6">
                                <div class="input-item input-with-label"><label class="input-item-label ucap text-exlight">9mobile Airtime Discount</label><input class="input-bordered" type="text" name="9mobile-airtime"><span class="input-note">Kindly enter the % discount to give 9mobile users.</span></div>
                            </div>
                        </div>


                        <div class="gaps-1x"></div>
                        <!-- .gaps -->
                        <h6 class="card-title">Data Discount (%) Settings</h6>
                        <div class="row">
                            <div class="col-xl-3 col-sm-6">
                                <div class="input-item input-with-label"><label class="input-item-label ucap text-exlight">Mtn DataBundle Discount</label><input class="input-bordered" type="text" name="mtn-data"><span class="input-note">Kindly enter the % discount to give mtn users.</span></div>
                            </div>
                            <div class="col-xl-3 col-sm-6">
                                <div class="input-item input-with-label"><label class="input-item-label ucap text-exlight">Glo DataBundle Discount</label><input class="input-bordered" type="text" name="glo-data"><span class="input-note">Kindly enter the % discount to give glo users.</span></div>
                            </div>
                            <div class="col-xl-3 col-sm-6">
                                <div class="input-item input-with-label"><label class="input-item-label ucap text-exlight">Airtel DataBundle Discount</label><input class="input-bordered" type="text" name="airtel-data"><span class="input-note">Kindly enter the % discount to give airtel users.</span></div>
                            </div>
                            <div class="col-xl-3 col-sm-6">
                                <div class="input-item input-with-label"><label class="input-item-label ucap text-exlight">9mobile DataBundle Discount</label><input class="input-bordered" type="text" name="9mobile-data"><span class="input-note">Kindly enter the % discount to give 9mobile users.</span></div>
                            </div>
                        </div>

                        <div class="gaps-1x"></div>
                        <!-- .gaps -->
                        <h6 class="card-title">TV Cable Discount (%) Settings</h6>
                        <div class="row">
                            <div class="col-xl-3 col-sm-6">
                                <div class="input-item input-with-label"><label class="input-item-label ucap text-exlight">DSTV Discount</label><input class="input-bordered" type="text" name="dstv"><span class="input-note">Kindly enter the % discount to give mtn users.</span></div>
                            </div>
                            <div class="col-xl-3 col-sm-6">
                                <div class="input-item input-with-label"><label class="input-item-label ucap text-exlight">GOTV Discount</label><input class="input-bordered" type="text" name="gotv"><span class="input-note">Kindly enter the % discount to give glo users.</span></div>
                            </div>
                            <div class="col-xl-3 col-sm-6">
                                <div class="input-item input-with-label"><label class="input-item-label ucap text-exlight">STARTIMES Discount</label><input class="input-bordered" type="text" name="startimes"><span class="input-note">Kindly enter the % discount to give airtel users.</span></div>
                            </div>
                        </div>

                        <div class="gaps-1x"></div>
                        <!-- .gaps -->
                        <h6 class="card-title">Electric Discount (%) Settings</h6>
                        <div class="row">
                            <div class="col-xl-3 col-sm-6">
                                <div class="input-item input-with-label"><label class="input-item-label ucap text-exlight">Ikeja Electric Discount</label><input class="input-bordered" type="text" name="ikeja-electric"><span class="input-note">Kindly enter the % discount to give mtn users.</span></div>
                            </div>
                            <div class="col-xl-3 col-sm-6">
                                <div class="input-item input-with-label"><label class="input-item-label ucap text-exlight">Eko Electric Discount</label><input class="input-bordered" type="text" name="eko-electric"><span class="input-note">Kindly enter the % discount to give glo users.</span></div>
                            </div>
                            <div class="col-xl-3 col-sm-6">
                                <div class="input-item input-with-label"><label class="input-item-label ucap text-exlight">Kano Electric Discount</label><input class="input-bordered" type="text" name="kano-electric"><span class="input-note">Kindly enter the % discount to give airtel users.</span></div>
                            </div>
                            <div class="col-xl-3 col-sm-6">
                                <div class="input-item input-with-label"><label class="input-item-label ucap text-exlight">Portharcourt Eletric Discount</label><input class="input-bordered" type="text" name="portharcourt-electric"><span class="input-note">Kindly enter the % discount to give 9mobile users.</span></div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-xl-3 col-sm-6">
                                <div class="input-item input-with-label"><label class="input-item-label ucap text-exlight">Ibadan Electric Discount</label><input class="input-bordered" type="text" name="ibadan-eletric"><span class="input-note">Kindly enter the % discount to give mtn users.</span></div>
                            </div>
                            <div class="col-xl-3 col-sm-6">
                                <div class="input-item input-with-label"><label class="input-item-label ucap text-exlight">Kaduna Electric Discount</label><input class="input-bordered" type="text" name="kaduna-electric"><span class="input-note">Kindly enter the % discount to give glo users.</span></div>
                            </div>
                            <div class="col-xl-3 col-sm-6">
                                <div class="input-item input-with-label"><label class="input-item-label ucap text-exlight">Abuja Electric Discount</label><input class="input-bordered" type="text"><span class="input-note">Kindly enter the % discount to give airtel users.</span></div>
                            </div>
                            <div class="col-xl-3 col-sm-6">
                                <div class="input-item input-with-label"><label class="input-item-label ucap text-exlight">Enugu Electric Discount</label><input class="input-bordered" type="text" name="enugu-electric"><span class="input-note">Kindly enter the % discount to give 9mobile users.</span></div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-xl-3 col-sm-6">
                                <div class="input-item input-with-label"><label class="input-item-label ucap text-exlight">Benin Electric Discount</label><input class="input-bordered" type="text" name="benin-electric"><span class="input-note">Kindly enter the % discount to give mtn users.</span></div>
                            </div>
                            <div class="col-xl-3 col-sm-6">
                                <div class="input-item input-with-label"><label class="input-item-label ucap text-exlight">Aba Electric Discount</label><input class="input-bordered" type="text" name="aba-electric"><span class="input-note">Kindly enter the % discount to give glo users.</span></div>
                            </div>
                            <div class="col-xl-3 col-sm-6">
                                <div class="input-item input-with-label"><label class="input-item-label ucap text-exlight">Yola Electric Discount</label><input class="input-bordered" type="text" name="yola-electric"><span class="input-note">Kindly enter the % discount to give airtel users.</span></div>
                            </div>
                           
                        </div>


                    </div>
                    <!-- .card-innr -->
                </div>
                <!-- .card -->
            </div>





        </div>
        <!-- .container -->
    </div>
    <!-- .page-content -->

    <?php 

    require_once './footer.php';

    ?>