<?php
// Start the session
session_start();

// Check if the user is logged in
if (isset($_SESSION['user'])) {
  require_once './config/database.php';
  require_once './functions/function.php';
  // Get the user details from the database
  $user_id = $_SESSION['user'];

  $user = getUser($user_id);
  $wallet = getWallet($user_id);
  $profile = getProfile($user_id);
  $transaction = getTransactions($user_id);
 

} else {
    header("Location: ./login.php");
}

$title = 'Transaction Details';

?>

<!DOCTYPE html>
<html lang="en" class="js">

<head>
    <meta charset="utf-8">
    <meta name="author" content="Dasodhub">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="Pay Bills Seamlessly With the Trilspay App">
    <!-- Fav Icon -->
    <link rel="shortcut icon" href="./assets/images/favicon1.png">
    
    <!-- Site Title  -->
    <title><?php echo $title ?> - Pay Bills Seamlessly with Trilspay</title>
    <!-- Vendor Bundle CSS -->
    <link rel="stylesheet" href="assets/css/vendor.bundle49f7.css?ver=104">
    <!-- Custom styles for this template -->
    <link rel="stylesheet" href="assets/css/style.css" id="layoutstyle">
    
    <script>
        (function(i, s, o, g, r, a, m) {
            i['GoogleAnalyticsObject'] = r;
            i[r] = i[r] || function() {
                (i[r].q = i[r].q || []).push(arguments)
            }, i[r].l = 1 * new Date();
            a = s.createElement(o), m = s.getElementsByTagName(o)[0];
            a.async = 1;
            a.src = g;
            m.parentNode.insertBefore(a, m)
        })(window, document, 'script', '../../www.google-analytics.com/analytics.js', 'ga');
        ga('create', 'UA-91615293-2', 'auto');
        ga('send', 'pageview');
    </script>
</head>


<?php
include './config/database.php';
include './functions/validation.php';


// Get the transaction reference from the URL
if (isset($_GET['tranx-ref'])) {
    $transactionReference = $_GET['tranx-ref'];
   
    $transactionDetails = getTransactionDetails($transactionReference, $pdo);

    // Display the transaction details
    if (!empty($transactionDetails)) {
        
    } else {
        // Transaction not found, redirect to the transaction page with an error message
        $errorMessage = urlencode('Transaction not found');
        header('Location: transactions?error=' . $errorMessage);
        exit;
    }
} else {
    // Transaction reference not provided in the URL, display an error message
    $errorMessage = urlencode('Transaction reference not provided');
    header('Location: transactions?error=' . $errorMessage);
    exit;
}

// Prepare a SQL query to retrieve the bill payment details
$stmt = $pdo->prepare('SELECT * FROM bill_payments WHERE payment_id = :transaction_reference');

// Bind the transaction reference parameter
$stmt->bindParam(':transaction_reference', $transactionReference);

// Execute the query
$stmt->execute();

// Fetch the bill payment details as an associative array
$billPayments = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Check if $billPayments is not empty and the 'biller_code' key exists
if(!empty($billPayments) && isset($billPayments[0]['biller_code'])) {
    //print_r($billPayments);
    //echo $billPayments[0]['biller_code'];
}

require_once './topbar.php';


?>



    <!-- .topbar-wrap -->
    <div class="page-content">
        <div class="container">
            <div class="card content-area">
                <div class="card-innr">
                    <div class="card-head d-flex justify-content-between align-items-center">
                        <h4 class="card-title mb-0">Transaction Details</h4><a href="./transactions" class="btn btn-sm btn-auto btn-primary d-sm-block d-none"><em class="fas fa-arrow-left mr-3"></em>Back</a>
                        <a href="./transactions" class="btn btn-icon btn-sm btn-primary d-sm-none"><em class="fas fa-arrow-left"></em></a>
                    </div>
                    <div class="gaps-1-5x"></div>
                    <div class="data-details d-md-flex">
                        <div class="fake-class"><span class="data-details-title">Tranx Date</span><span class="data-details-info"><?php echo date('d-M-Y h:i A', strtotime($transactionDetails['created_at'])); ?></span></div>
                        <div class="fake-class"><span class="data-details-title">Tranx Status</span><span class="badge badge-success ucap"><?php echo $transactionDetails['transaction_status']; ?></span></div>
                        <div class="fake-class"><span class="data-details-title">Tranx Approved Note</span><span class="data-details-info"> <strong><?php echo $transactionDetails['transaction_reference'] ?></strong> at <?php echo date('d-M-Y h:i A', strtotime($transactionDetails['updated_at'])); ?></span></div>
                    </div>
                    
                    
                    <div class="gaps-3x"></div>
                    <h6 class="card-sub-title">Transaction Info</h6>
                    <ul class="data-details-list">
                    <?php
                        if($user['role'] === 'admin')
                     //print_r($transactionDetails)?>
                 
                        <li>
                            <div class="data-details-head">Transaction by</div>
                            <div class="data-details-des"><strong><?php echo $transactionDetails['user_id'] ?></strong></div>
                        </li>
                       

                    <?php
                      ?>
                        <li>
                            <div class="data-details-head">Transaction Type</div>
                            <div class="data-details-des"><strong><?php echo $transactionDetails['transaction_type'] ?></strong></div>
                        </li>
                        <!-- li -->
                        <li>
                            <div class="data-details-head">Transaction Description</div>
                            <div class="data-details-des"><strong><?php echo $transactionDetails['transaction_description']; ?></strong></div>
                        </li>
                        <!-- li -->
                        <?php
                        if($transactionDetails['transaction_type'] === "Bill payment") {
                            ?>

                        <li>
                            <div class="data-details-head">Credited</div>
                            <div class="data-details-des"><strong><?php echo $billPayments[0]['biller_code']; ?></strong></div>
                        </li>

                            <?php
                        }
                        
                        ?>
                        <!-- li -->
                        <li>
                            <div class="data-details-head">Transaction Ref</div>
                            <div class="data-details-des"><strong><?php echo $transactionDetails['transaction_reference'] ?></strong></div>
                        </li>
                        <!-- li -->
                        
                        <!-- li -->
                        <li>
                            <div class="data-details-head">Details</div>
                            <div class="data-details-des"><?php echo $transactionDetails['transaction_notes']; ?></div>
                        </li>
                        <!-- li -->
                    </ul>
                    <!-- .data-details -->
                    <div class="gaps-3x"></div>
                    <h6 class="card-sub-title">Transaction Details</h6>
                    <ul class="data-details-list">
                      
                        <!-- li -->
                       
                        <!-- li -->
                        <li>
                            <div class="data-details-head">Transaction Amount</div>
                            <div class="data-details-des"><strong><?php echo number_format($transactionDetails['transaction_amount'], 2, '.', ',') ?> </strong></div>
                        </li>
                        <!-- li -->
                        <li>
                            <div class="data-details-head">Total Amount</div>
                            <div class="data-details-des"><span><?php echo number_format($transactionDetails['user_paid'], 2, '.', ',') ?> </span><span></span></div>
                        </li>
                        <!-- li -->
                        <li>
                            <div class="data-details-head">Bonus CashBack (NGN)</div>
                            <div class="data-details-des">
                                <span>
                                    <?php
                                    $amount = $transactionDetails['transaction_amount'];
                                    $total_amount = $transactionDetails['user_paid'];

                                    if (is_numeric($amount) && is_numeric($total_amount)) {
                                        $difference = $amount - $total_amount;
                                        echo number_format($difference, 2, '.', ',');
                                    } else {
                                        echo "Non-numeric value encountered";
                                    }
                                ?>
                                </span>
                            </div>
                        </li>
                        <!-- li -->
                        <?php
                            if($user['role'] === 'admin') {
                                //print_r($transactionDetails)
                        ?>
                                <li>
                                    <div class="data-details-head">Profit From Transaction</div>
                                    <div class="data-details-des"><strong><?php echo $transactionDetails['profit'] ?></strong></div>
                                </li>
                        <?php
                            }
                        ?>
                        <!-- li -->
                    </ul>
                    <!-- .data-details -->
                </div>
            </div>
            <!-- .card -->
        </div>
        <!-- .container -->
    </div>
    <!-- .page-content -->
    <?php 
    require_once './footer.php';
    ?>