<?php
// Start the session
session_start();

// Check if the user is logged in
if (isset($_SESSION['user'])) {
  require_once './config/database.php';
  require_once './functions/function.php';
  // Get the user details from the database
  $user_id = $_SESSION['user'];

  $user = getUser($user_id);
  $wallet = getWallet($user_id);
  $profile = getProfile($user_id);
  $transaction = getTransactions($user_id);
 

} else {
    header("Location: ./login.php");
}

$title = 'User Details';

?>

<!DOCTYPE html>
<html lang="en" class="js">

<head>
    <meta charset="utf-8">
    <meta name="author" content="Dasodhub">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="Pay Bills Seamlessly With the Trilspay App">
    <!-- Fav Icon -->
    <link rel="shortcut icon" href="./assets/images/favicon1.png">
    
    <!-- Site Title  -->
    <title><?php echo $title ?> - Pay Bills Seamlessly with Trilspay</title>
    <!-- Vendor Bundle CSS -->
    <link rel="stylesheet" href="assets/css/vendor.bundle49f7.css?ver=104">
    <!-- Custom styles for this template -->
    <link rel="stylesheet" href="assets/css/style.css" id="layoutstyle">
    
    <script>
        (function(i, s, o, g, r, a, m) {
            i['GoogleAnalyticsObject'] = r;
            i[r] = i[r] || function() {
                (i[r].q = i[r].q || []).push(arguments)
            }, i[r].l = 1 * new Date();
            a = s.createElement(o), m = s.getElementsByTagName(o)[0];
            a.async = 1;
            a.src = g;
            m.parentNode.insertBefore(a, m)
        })(window, document, 'script', '../../www.google-analytics.com/analytics.js', 'ga');
        ga('create', 'UA-91615293-2', 'auto');
        ga('send', 'pageview');
    </script>
</head>




<?php

require_once './topbar.php';

require './functions/admin.php';

$user = getUserDetailsByUserId($pdo, $_GET['id']);
//print_r($user);



?>



<!-- .topbar-wrap -->
<div class="page-content">
    <div class="container">
        <div class="card content-area">
            <div class="card-innr card-innr-fix">
                <div class="card-head d-flex justify-content-between align-items-center">
                    <h4 class="card-title mb-0">User Details</h4>
                    <div class="d-flex align-items-center guttar-20px">
                        <div class="flex-col d-sm-block d-none"><a href="./users" class="btn btn-sm btn-auto btn-primary"><em class="fas fa-arrow-left mr-3"></em>Back</a></div>
                        <div class="flex-col d-sm-none"><a href="users.html" class="btn btn-icon btn-sm btn-primary"><em class="fas fa-arrow-left"></em></a></div>
                        <div class="relative d-inline-block"><a href="#" class="btn btn-dark btn-sm btn-icon toggle-tigger"><em class="ti ti-more-alt"></em></a>
                            <div class="toggle-class dropdown-content dropdown-content-top-left">
                                <ul class="dropdown-list">
                                    <li><a href="#"><em class="far fa-envelope"></em> Send Mail</a></li>
                                    <li><a href="#"><em class="fas fa-shield-alt"></em> Reset Pass</a></li>
                                    <li><a href="#"><em class="fas fa-ban"></em> Suspend</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="gaps-1-5x"></div>
                <div class="data-details d-md-flex">
                    <div class="fake-class"><span class="data-details-title">Wallet Balance</span><span class="data-details-info large"><?php echo $user->wallet_balance ?> <small>NGN</small></span></div>
                    <div class="fake-class"><span class="data-details-title">Role</span><span class="data-details-info large"><?php echo htmlspecialchars($user->role); ?></span></div>
                    <div class="fake-class"><span class="data-details-title">User Status</span><span class="badge badge-success ucap">Active</span></div>
                    <ul class="data-vr-list">
                        <li>
                            <div class="data-state data-state-sm data-state-<?php echo $user->is_email_verified == '1' ? 'approved' : 'pending'; ?>"></div> Email</li>
                        <li>
                            <div class="data-state data-state-sm data-state-<?php echo $user->is_kyc_verified == '1' ? 'approved' : 'pending'; ?>"></div> KYC</li>
                        <!--<li>
                            <div class="data-state data-state-sm data-state-<?php echo $user->wl_status == 'approved' ? 'approved' : 'pending'; ?>"></div> WL</li> -->
                    </ul>
                </div>
                <div class="gaps-3x"></div>
                <h6 class="card-sub-title">User Information</h6>
                <ul class="data-details-list">
                    <li>
                        <div class="data-details-head">Username</div>
                        <div class="data-details-des"><?php echo htmlspecialchars($user->username) ?></div>
                    </li>
                    <!-- li -->
                    <li>
                        <div class="data-details-head">Surname</div>
                        <div class="data-details-des"><?php echo htmlspecialchars($user->user_last_name); ?></div>
                    </li>

                    <!-- li -->
                    <li>
                        <div class="data-details-head">Firstname</div>
                        <div class="data-details-des"><?php echo htmlspecialchars($user->user_first_name); ?></div>
                    </li>
                    <!-- li -->
                    <li>
                        <div class="data-details-head">Email Address</div>
                        <div class="data-details-des"><?php echo htmlspecialchars($user->email); ?></div>
                    </li>
                    <!-- li -->
                    <li>
                        <div class="data-details-head">Mobile Number</div>
                        <div class="data-details-des"><?php echo htmlspecialchars($user->user_phone_number); ?></div>
                    </li>
                    <!-- li -->
                    <li>
                        <div class="data-details-head">Date of Birth</div>
                        <div class="data-details-des"><?php echo htmlspecialchars($user->date_of_birth); ?></div>
                    </li>
                    <!-- li -->
                    <li>
                        <div class="data-details-head">Address</div>
                        <div class="data-details-des"><?php echo htmlspecialchars($user->user_address_line_1); ?></div>
                    </li>
                    <!-- li -->

                    <li>
                        <div class="data-details-head">City</div>
                        <div class="data-details-des"><?php echo htmlspecialchars($user->user_city); ?></div>
                    </li>
                    <!-- li -->

                    <li>
                        <div class="data-details-head">State</div>
                        <div class="data-details-des"><?php echo htmlspecialchars($user->user_state); ?></div>
                    </li>
                    <!-- li -->
                </ul>
                <div class="gaps-3x"></div>
                <h6 class="card-sub-title">More Information</h6>
                <ul class="data-details-list">
                    <li>
                        <div class="data-details-head">Joining Date</div>
                        <div class="data-details-des"><?php echo date('d M, Y h:i A', strtotime($user->created_at)); ?></div>
                    </li>
                    <!-- li -->
                    <!--<li>
                        <div class="data-details-head">Reg Method</div>
                        <div class="data-details-des">Email</div>
                    </li> -->
                    <!-- li -->
                    <li>
                        <div class="data-details-head">Last Login</div>
                        <div class="data-details-des"><?php echo date('d M, Y h:i A', strtotime($user->updated_at)); ?></div>
                    </li>
                    <!-- li -->
                    <!--<li>
                        <div class="data-details-head">Newsleter Subscription</div>
                        <div class="data-details-des">Yes</div>
                    </li> -->
                    <!-- li -->
                </ul>



                <div class="gaps-3x"></div>
                <h6 class="card-sub-title">Recent Transactions</h6>
                
                    
                    <!-- li -->
                    <!--<li>
                        <div class="data-details-head">Newsleter Subscription</div>
                        <div class="data-details-des">Yes</div>
                    </li> -->
                    <!-- li -->


                    <?php

                    // User ID
                    $user_id = $user->user_id;

                    // Prepare the SQL statement
                    $stmt = $pdo->prepare("SELECT * FROM transactions WHERE user_id = :user_id ORDER BY created_at DESC LIMIT 5");

                    // Bind the parameter
                    $stmt->bindParam(':user_id', $user_id);

                    // Execute the statement
                    $stmt->execute();

                    // Fetch the results
                    $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
                        
                    // Print the results
                    // Start the HTML table
                    echo "<table class='table'>";
                    echo "<thead>";
                    echo "<tr>";
                    echo "<th>Transaction ID</th>";
                    echo "<th>Amount</th>";
                    echo "<th>Status</th>";
                    echo "<th>Type</th>";
                    echo "<th>Date</th>";
                    echo "</tr>";
                    echo "</thead>";
                    echo "<tbody>";

                    // Print the results
                    foreach ($results as $row) {
                        echo "<tr>";
                        echo "<td>" . $row['transaction_reference'] . "</td>";
                        echo "<td>" . number_format($row['transaction_amount'], 2, '.', ',') . "</td>";
                        echo "<td>" . $row['transaction_status'] . "</td>";
                        echo "<td>" . $row['transaction_type'] . "</td>";
                        echo "<td>" . $row['created_at'] . "</td>";
                        echo "</tr>";
                    }

                    // End the HTML table
                    echo "</tbody>";
                    echo "</table>";
                    ?>



                
            </div>

            
            <!-- .card-innr -->
        </div>
        <!-- .card -->
    </div>
    <!-- .container -->
</div>
<!-- .page-content -->
<?php 
require_once './footer.php';

?>