<?php
// Start the session
session_start();

// Check if the user is logged in
if (isset($_SESSION['user'])) {
  require_once './config/database.php';
  require_once './functions/function.php';
  // Get the user details from the database
  $user_id = $_SESSION['user'];

  $user = getUser($user_id);
  $wallet = getWallet($user_id);
  $profile = getProfile($user_id);
  $transaction = getTransactions($user_id);
 

} else {
    header("Location: ./login.php");
}

$title = 'Users';

?>

<!DOCTYPE html>
<html lang="en" class="js">

<head>
    <meta charset="utf-8">
    <meta name="author" content="Dasodhub">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="Pay Bills Seamlessly With the Trilspay App">
    <!-- Fav Icon -->
    <link rel="shortcut icon" href="./assets/images/favicon1.png">
    
    <!-- Site Title  -->
    <title><?php echo $title ?> - Pay Bills Seamlessly with Trilspay</title>
    <!-- Vendor Bundle CSS -->
    <link rel="stylesheet" href="assets/css/vendor.bundle49f7.css?ver=104">
    <!-- Custom styles for this template -->
    <link rel="stylesheet" href="assets/css/style.css" id="layoutstyle">
    
    <script>
        (function(i, s, o, g, r, a, m) {
            i['GoogleAnalyticsObject'] = r;
            i[r] = i[r] || function() {
                (i[r].q = i[r].q || []).push(arguments)
            }, i[r].l = 1 * new Date();
            a = s.createElement(o), m = s.getElementsByTagName(o)[0];
            a.async = 1;
            a.src = g;
            m.parentNode.insertBefore(a, m)
        })(window, document, 'script', '../../www.google-analytics.com/analytics.js', 'ga');
        ga('create', 'UA-91615293-2', 'auto');
        ga('send', 'pageview');
    </script>
</head>





<?php 

require_once './topbar.php';

// Check if the user is an admin
if ($user['role'] !== 'admin') {
    // Redirect the user to the dashboard page
    header('Location: ./dashboard');
    exit;
}


?>




    <!-- .topbar-wrap -->
    <div class="page-content">
        <div class="container">
            <div class="card content-area">
                <div class="card-innr">
                    <div class="card-head">
                        <h4 class="card-title">User List</h4>
                    </div>

                    <?php 
                    include './functions/admin.php';
                    // Call the getAllUsers() function to get all users
                    $allUsers = getAllUsers($pdo);
                    //print_r($allUsers);
                    
                    
                    ?>
                    <table class="data-table dt-init user-list">
                        <thead>
                            <tr class="data-item data-head">
                                <th class="data-col dt-user">User</th>
                                <th class="data-col dt-email">Email</th>
                                <th class="data-col dt-token">Wallet Balance</th>
                                <th class="data-col dt-verify">Verified Status</th>
                                <th class="data-col dt-login">Last Login</th>
                                <th class="data-col dt-status">
                                    <div class="dt-status-text">Status</div>
                                </th>
                                <th class="data-col"></th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php
// Connect to the database
//$pdo = new PDO('mysql:host=localhost;dbname=mydatabase', 'username', 'password');

// Call the getAllUsers() function to get all users
$allUsers = getAllUsers($pdo);

// Loop through the users and display each user's data in a table row
foreach ($allUsers as $allUser) {
    // Display the user's data in the table row
    echo '<tr class="data-item">';
    echo '<td class="data-col dt-user"><span class="lead user-name">' . htmlspecialchars($allUser->username) . '</span><span class="sub user-id">' . htmlspecialchars($allUser->user_id) . '</span></td>';
    echo '<td class="data-col dt-email"><span class="sub sub-s2 sub-email">' . htmlspecialchars($allUser->email) . '</span></td>';
    echo '<td class="data-col dt-token"><span class="lead lead-btoken">' . number_format($allUser->wallet_balance, 2, '.', ',') . '</span></td>';
    echo '<td class="data-col dt-verify">';
    echo '<ul class="data-vr-list">';
    if ($allUser->is_email_verified) {
        echo '<li><div class="data-state data-state-sm data-state-approved"></div> Email</li>';
    } else {
        echo '<li><div class="data-state data-state-sm data-state-pending"></div> Email</li>';
    }
    if ($allUser->is_kyc_verified) {
        echo '<li><div class="data-state data-state-sm data-state-approved"></div> KYC</li>';
    } else {
        echo '<li><div class="data-state data-state-sm data-state-pending"></div> KYC</li>';
    }
    echo '</ul>';
    echo '</td>';
    echo '<td class="data-col dt-login"><span class="sub sub-s2 sub-time">' . htmlspecialchars($allUser->updated_at) . '</span></td>';
    echo '<td class="data-col dt-status"><span class="dt-status-md badge badge-outline badge-success badge-md">' . htmlspecialchars($allUser->role) . '</span><span class="dt-status-sm badge badge-sq badge-outline badge-success badge-md">' . htmlspecialchars(substr($allUser->role, 0, 1)) . '</span></td>';
    echo '<td class="data-col text-right">';
    echo '<div class="relative d-inline-block"><a href="#" class="btn btn-light-alt btn-xs btn-icon toggle-tigger"><em class="ti ti-more-alt"></em></a>';
    echo '<div class="toggle-class dropdown-content dropdown-content-top-left">';
    echo '<ul class="dropdown-list">';
    echo '<li><a href="user-details?id=' . $allUser->user_id . '"><em class="ti ti-eye"></em> View Details</a></li>';
    if ($allUser->is_email_verified == '1') {
        echo '<li><a href="suspend?id=' . $allUser->user_id . '"><em class="ti ti-na"></em> Suspend</a></li>';
    } else {
        echo '<li><a href="activate?id=' . $allUser->user_id . '"><em class="ti ti-check"></em> Activate</a></li>';
    }
    echo '<li><a href="delete?id=' . $allUser->user_id . '"><em class="ti ti-trash"></em> Delete</a></li>';
    echo '</ul>';
    echo '</div>';
    echo '</div>';
    echo '</td>';
    echo '</tr>';
}
?>
                            <!-- .data-item -->
                            
                            
                            
                            
                            <!-- .data-item -->
                        </tbody>
                    </table>
                </div>
                <!-- .card-innr -->
            </div>
            <!-- .card -->
        </div>
        <!-- .container -->
    </div>
    <!-- .page-content -->
    <?php 

    require_once './footer.php';