<?php


// function verifySmartcardCode($smartcardCode) {
//     return preg_match("/^[0-9]{5}$/", $smartcardCode);
// }

function process_smartcard_verification($service, $smartcard)
{
    require_once './config/database.php';

    // Prepare the SQL statement using parameterized query to prevent SQL injection
    $stmt = $pdo->prepare("SELECT * FROM products WHERE service_code = :serviceId");
    $stmt->bindParam(":serviceId", $service);
    $stmt->execute();
    $product = $stmt->fetch();

    if ($product) {
        $apiUrl = "https://sandbox.vtpass.com/api/merchant-verify";
        $data = array(
            "serviceID" => $service,
            "billersCode" => $smartcard,
        );

        $options = array(
            "http" => array(
                "header"  => "Content-type: application/x-www-form-urlencoded\r\n"
                            ."api-key: 3102513ed61158fba8421f5702df0f73\r\n"
                            ."secret-key: SK_320fee7b00786294796d39a675a510770b257f51c5d\r\n",
                "method"  => "POST",
                "content" => http_build_query($data),
            ),
        );
        $context  = stream_context_create($options);
        $result = file_get_contents($apiUrl, false, $context);

        if ($result === FALSE) {
            /* Handle error */
            return array('error' => 'Error when calling the API');
        }

        $response = json_decode($result);

        if ($response->code === '000') {
            $customerName = htmlspecialchars($response->content->Customer_Name);
            $status = htmlspecialchars($response->content->Status);
            $dueDate = htmlspecialchars($response->content->Due_Date);
            $customerType = htmlspecialchars($response->content->Customer_Type);
            $currentPlan = htmlspecialchars($response->content->Current_Bouquet);
            $currentPlanCode = htmlspecialchars($response->content->Current_Bouquet_Code);

            $responseArray = array(
                'status' => 'success',
                'smartcardCode' => $smartcard,
                'product' => $product,
                'customerName' => $customerName,
                'status' => $status,
                'dueDate' => $dueDate,
                'customerType' => $customerType,
                'currentPlan' => $currentPlan,
                'currentPlanCode' => $currentPlanCode
            );

            return $responseArray;

        }
    }

    // Return an error message
    return array('error' => 'Smartcard verification failed');
}

// Call the function with POST data
$serviceId = trim(htmlspecialchars(filter_input(INPUT_POST, 'service', FILTER_SANITIZE_SPECIAL_CHARS)));
$smartCard = trim(htmlspecialchars(filter_input(INPUT_POST, 'smartcard', FILTER_SANITIZE_SPECIAL_CHARS)));

$result = process_smartcard_verification($serviceId, $smartCard);

if (isset($result['error'])) {
    echo json_encode($result);
} else {
    echo json_encode(array('data' => $result));
}


?>