<?php
// Start the session
session_start();

// Check if the user is logged in
if (isset($_SESSION['user'])) {
  require_once './config/database.php';
  require_once './functions/function.php';
  // Get the user details from the database
  $user_id = $_SESSION['user'];

  $user = getUser($user_id);
  $wallet = getWallet($user_id);
  $profile = getProfile($user_id);
  $transaction = getTransactions($user_id);
 

} else {
    header("Location: ./login.php");
}

////////////////////////////////////////////////////////

if($profile['is_kyc_verified'] != 1) {
    header("Location: ./dashboard.php?error=Please complete your KYC Verification before accessing this page!");
}




$title = 'Fund Wallet';

?>

<!DOCTYPE html>
<html lang="en" class="js">

<head>
    <meta charset="utf-8">
    <meta name="author" content="Dasodhub">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="Pay Bills Seamlessly With the Trilspay App">
    <!-- Fav Icon -->
    <link rel="shortcut icon" href="./assets/images/favicon1.png">
    
    <!-- Site Title  -->
    <title><?php echo $title ?> - Pay Bills Seamlessly with Trilspay</title>
    <!-- Vendor Bundle CSS -->
    <link rel="stylesheet" href="assets/css/vendor.bundle49f7.css?ver=104">
    <!-- Custom styles for this template -->
    <link rel="stylesheet" href="assets/css/style.css" id="layoutstyle">
    
    <script>
        (function(i, s, o, g, r, a, m) {
            i['GoogleAnalyticsObject'] = r;
            i[r] = i[r] || function() {
                (i[r].q = i[r].q || []).push(arguments)
            }, i[r].l = 1 * new Date();
            a = s.createElement(o), m = s.getElementsByTagName(o)[0];
            a.async = 1;
            a.src = g;
            m.parentNode.insertBefore(a, m)
        })(window, document, 'script', '../../www.google-analytics.com/analytics.js', 'ga');
        ga('create', 'UA-91615293-2', 'auto');
        ga('send', 'pageview');
    </script>
</head>



<?php 
require_once './topbar.php';
 ?>
<!-- .topbar-wrap -->
<div class="page-content">
    <div class="container">
        <div class="card">
            
        </div>

        <div class="page-content">
    <div class="container">
        <div class="content-area card">
            <div class="card-innr">
                
                
                
                <div class="hr"></div>
                <div class="card-head">
                    <h6 class="card-title">Credit Wallet</h6>
                </div>
                <div class="gaps-1x"></div>
                <ul class="nav nav-tabs nav-tabs-line" role="tablist">
                    <li class="nav-item"><a class="nav-link active" data-toggle="tab" href="#tab-item-4">Fund With Manual Bank Transfer</a></li>
                    <li class="nav-item"><a class="nav-link" data-toggle="tab" href="#tab-item-5">Fund With Automatic Bank Transfer</a></li>
                    <li class="nav-item"><a class="nav-link" data-toggle="tab" href="#tab-item-6">Fund with card</a></li>
                </ul>
                <div class="tab-content">
                    <div class="tab-pane fade active show" id="tab-item-4">
                        <h4>Fund your Wallet Manually</h4>
                        
                        <p>To fund your wallet, make payment into this account. Your Wallet will be credited automatically. Account number is dedicated to crediting your wallet.<br><br>
                        IMPORTANT: payments made into this account are automated. This means that once you transfer, your wallet is credited automatically.<br> <br>


                    </div>
                    <div class="tab-pane fade" id="tab-item-5">
                    <p>To fund your wallet, make payment into this account. Your Wallet will be credited automatically. Account number is dedicated to crediting your wallet.<br><br>
                    IMPORTANT: payments made into this account are automated. This means that once you transfer, your wallet is credited automatically.<br> <br>
                    P.S: Just like every other transfers, you could experience a slight delay in wallet funding. You only need to hold on patiently as your wallet would be credited once processed. You do not need to contact support after funding your wallet, It is automated.</p>
                    </div>
                    <div class="tab-pane fade" id="tab-item-6">
                        <h4>Fund your Wallet with card</h4>
                        <script type="text/javascript" src="https://sdk.monnify.com/plugin/monnify.js"></script>
                        <script>
                            function payWithMonnify() {
                                MonnifySDK.initialize({
                                    amount: 100,
                                    currency: "NGN",
                                    reference: new String((new Date()).getTime()),
                                    customerFullName: "Damilare Ogunnaike",
                                    customerEmail: <?php  ?>,
                                    apiKey: "MK_TEST_164S33M9G5",
                                    contractCode: "1161080530",
                                    paymentDescription: "Lahray World",
                                    metadata: {
                                        "name": "Damilare",
                                        "age": 45
                                    },
                                    
                                    onLoadStart: () => {
                                        console.log("loading has started");
                                    },
                                    onLoadComplete: () => {
                                        console.log("SDK is UP");
                                    },
                                    onComplete: function(response) {
                                        //Implement what happens when the transaction is completed.
                                        console.log(response);
                                    },
                                    onClose: function(data) {
                                        //Implement what should happen when the modal is closed here
                                        console.log(data);
                                    }
                                });
                            }
                        </script>

    <div>
        <button type="button" onclick="payWithMonnify()">Pay With Monnify</button>
    </div>

                    </div>
                </div>
            </div>
        </div>
        <!-- .card -->
    </div>
    <!-- .container -->
</div>
        <!-- .card -->
        
    </div>
    <!-- .container -->
</div>
<!-- .page-content -->
<?php
require_once './footer.php';

?>